/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.featuregroup;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.app.FsJobManagerController;
import io.hops.hopsworks.common.featurestore.datavalidationv2.reports.ValidationReportController;
import io.hops.hopsworks.common.featurestore.datavalidationv2.suites.ExpectationSuiteController;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeatureGroupInputValidation;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.cached.CachedFeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.ondemand.OnDemandFeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.online.OnlineFeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.stream.StreamFeatureGroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.stream.StreamFeatureGroupDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.stream.StreamFeatureGroupFacade;
import io.hops.hopsworks.common.featurestore.statistics.StatisticsController;
import io.hops.hopsworks.common.featurestore.statistics.columns.StatisticColumnController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorController;
import io.hops.hopsworks.common.featurestore.storageconnectors.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreInputValidation;
import io.hops.hopsworks.common.featurestore.utils.FeaturestoreUtils;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.provenance.core.HopsFSProvenanceController;
import io.hops.hopsworks.common.security.QuotaEnforcementException;
import io.hops.hopsworks.common.security.QuotasEnforcement;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.exceptions.KafkaException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.exceptions.SchemaException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivityMeta;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.CachedFeaturegroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.hive.HivePartitions;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.ondemand.OnDemandFeaturegroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.stream.StreamFeatureGroup;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticColumn;
import io.hops.hopsworks.persistence.entity.featurestore.statistics.StatisticsConfig;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturegroupController {
    @EJB
    private FeaturegroupFacade featuregroupFacade;
    @EJB
    private CachedFeaturegroupController cachedFeaturegroupController;
    @EJB
    private StreamFeatureGroupController streamFeatureGroupController;
    @EJB
    private OnDemandFeaturegroupController onDemandFeaturegroupController;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private StatisticColumnController statisticColumnController;
    @EJB
    private FeaturestoreInputValidation featurestoreInputValidation;
    @EJB
    private CachedFeaturegroupFacade cachedFeaturegroupFacade;
    @EJB
    private StreamFeatureGroupFacade streamFeatureGroupFacade;
    @EJB
    private HopsFSProvenanceController fsController;
    @EJB
    private StatisticsController statisticsController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private Settings settings;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private InodeController inodeController;
    @EJB
    private OnlineFeaturegroupController onlineFeaturegroupController;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;
    @EJB
    private FeaturestoreStorageConnectorController connectorController;
    @EJB
    private FeatureGroupInputValidation featureGroupInputValidation;
    @EJB
    private FeaturestoreUtils featurestoreUtils;
    @EJB
    private ExpectationSuiteController expectationSuiteController;
    @EJB
    private ValidationReportController validationReportController;
    @EJB
    private QuotasEnforcement quotasEnforcement;
    @Inject
    private FsJobManagerController fsJobManagerController;

    public List<FeaturegroupDTO> getFeaturegroupsForFeaturestore(Featurestore featurestore, Project project, Users user) throws FeaturestoreException, ServiceException {
        List<Featuregroup> featuregroups = this.featuregroupFacade.findByFeaturestore(featurestore);
        ArrayList<FeaturegroupDTO> featuregroupDTOS = new ArrayList<FeaturegroupDTO>();
        for (Featuregroup featuregroup : featuregroups) {
            featuregroupDTOS.add(this.convertFeaturegrouptoDTO(featuregroup, project, user));
        }
        return featuregroupDTOS;
    }

    public FeaturegroupDTO clearFeaturegroup(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException, SQLException, ProvenanceException, IOException, ServiceException, KafkaException, SchemaException, ProjectException, UserException, HopsSecurityException, JobException {
        this.featurestoreUtils.verifyUserProjectEqualsFsProjectAndDataOwner(user, project, featuregroup.getFeaturestore(), FeaturestoreUtils.ActionMessage.CLEAR_FEATURE_GROUP);
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: 
            case STREAM_FEATURE_GROUP: {
                FeaturegroupDTO featuregroupDTO = this.convertFeaturegrouptoDTO(featuregroup, project, user);
                this.deleteFeaturegroup(featuregroup, project, user);
                return this.createFeaturegroupNoValidation(featuregroup.getFeaturestore(), featuregroupDTO, project, user);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CLEAR_OPERATION_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, "featuregroupId: " + featuregroup.getId());
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public FeaturegroupDTO createFeaturegroup(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Project project, Users user) throws FeaturestoreException, ServiceException, SQLException, ProvenanceException, IOException, KafkaException, SchemaException, ProjectException, UserException, HopsSecurityException, JobException {
        this.featurestoreUtils.verifyUserProjectEqualsFsProjectAndDataOwner(user, project, featurestore, FeaturestoreUtils.ActionMessage.CREATE_FEATURE_GROUP);
        this.enforceFeaturegroupQuotas(featurestore, featuregroupDTO);
        this.featureGroupInputValidation.verifySchemaProvided(featuregroupDTO);
        if (featuregroupDTO.getVersion() == null) {
            List<Featuregroup> fgPrevious = this.featuregroupFacade.findByNameAndFeaturestoreOrderedDescVersion(featuregroupDTO.getName(), featurestore);
            if (fgPrevious != null && !fgPrevious.isEmpty()) {
                featuregroupDTO.setVersion(fgPrevious.get(0).getVersion() + 1);
            } else {
                featuregroupDTO.setVersion(1);
            }
        }
        this.verifyFeatureGroupInput(featuregroupDTO);
        this.verifyFeaturesNoDefaultValue(featuregroupDTO.getFeatures());
        if (featuregroupDTO.getExpectationSuite() != null) {
            List<String> featureNames = featuregroupDTO.getFeatures().stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.toList());
            this.expectationSuiteController.verifyExpectationSuite(featuregroupDTO.getExpectationSuite(), featureNames);
        }
        return this.createFeaturegroupNoValidation(featurestore, featuregroupDTO, project, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeaturegroupDTO createFeaturegroupNoValidation(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Project project, Users user) throws FeaturestoreException, SQLException, ProvenanceException, ServiceException, KafkaException, SchemaException, ProjectException, UserException, IOException, HopsSecurityException, JobException {
        OnDemandFeaturegroup onDemandFeaturegroup = null;
        CachedFeaturegroup cachedFeaturegroup = null;
        StreamFeatureGroup streamFeatureGroup = null;
        ArrayList<FeatureGroupFeatureDTO> featuresNoHudi = null;
        if (featuregroupDTO instanceof CachedFeaturegroupDTO) {
            featuresNoHudi = new ArrayList<FeatureGroupFeatureDTO>(featuregroupDTO.getFeatures());
            cachedFeaturegroup = this.cachedFeaturegroupController.createCachedFeaturegroup(featurestore, (CachedFeaturegroupDTO)featuregroupDTO, project, user);
        } else if (featuregroupDTO instanceof StreamFeatureGroupDTO) {
            featuresNoHudi = new ArrayList<FeatureGroupFeatureDTO>(featuregroupDTO.getFeatures());
            streamFeatureGroup = this.streamFeatureGroupController.createStreamFeatureGroup(featurestore, (StreamFeatureGroupDTO)featuregroupDTO, project, user);
        } else {
            onDemandFeaturegroup = this.onDemandFeaturegroupController.createOnDemandFeaturegroup(featurestore, (OnDemandFeaturegroupDTO)featuregroupDTO, project, user);
        }
        Featuregroup featuregroup = this.persistFeaturegroupMetadata(featurestore, project, user, featuregroupDTO, cachedFeaturegroup, streamFeatureGroup, onDemandFeaturegroup);
        if (featuregroupDTO instanceof CachedFeaturegroupDTO && this.settings.isOnlineFeaturestore().booleanValue() && featuregroup.getCachedFeaturegroup().isOnlineEnabled()) {
            this.onlineFeaturegroupController.setupOnlineFeatureGroup(featurestore, featuregroup, featuresNoHudi, project, user);
        } else if (featuregroupDTO instanceof StreamFeatureGroupDTO) {
            if (this.settings.isOnlineFeaturestore().booleanValue() && featuregroup.getStreamFeatureGroup().isOnlineEnabled()) {
                this.onlineFeaturegroupController.setupOnlineFeatureGroup(featurestore, featuregroup, featuresNoHudi, project, user);
            } else {
                this.streamFeatureGroupController.setupOfflineStreamFeatureGroup(project, featuregroup, featuresNoHudi);
            }
        }
        FeaturegroupDTO completeFeaturegroupDTO = this.convertFeaturegrouptoDTO(featuregroup, project, user);
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            String fgPath = Utils.getFeaturestorePath(featurestore.getProject(), this.settings) + "/" + Utils.getFeaturegroupName(featuregroup);
            this.fsController.featuregroupAttachXAttrs(fgPath, completeFeaturegroupDTO, udfso);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
        this.fsActivityFacade.logMetadataActivity(user, featuregroup, FeaturestoreActivityMeta.FG_CREATED, null);
        if (featuregroup.getExpectationSuite() != null) {
            this.fsActivityFacade.logExpectationSuiteActivity(user, featuregroup, featuregroup.getExpectationSuite(), FeaturestoreActivityMeta.EXPECTATION_SUITE_ATTACHED_ON_FG_CREATION, "");
        }
        return completeFeaturegroupDTO;
    }

    public FeaturegroupDTO convertFeaturegrouptoDTO(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException, ServiceException {
        String featurestoreName = this.featurestoreFacade.getHiveDbName(featuregroup.getFeaturestore().getHiveDbId());
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                CachedFeaturegroupDTO cachedFeaturegroupDTO = this.cachedFeaturegroupController.convertCachedFeaturegroupToDTO(featuregroup, project, user);
                cachedFeaturegroupDTO.setFeaturestoreName(featurestoreName);
                return cachedFeaturegroupDTO;
            }
            case STREAM_FEATURE_GROUP: {
                StreamFeatureGroupDTO streamFeatureGroupDTO = this.streamFeatureGroupController.convertStreamFeatureGroupToDTO(featuregroup, project, user);
                streamFeatureGroupDTO.setFeaturestoreName(featurestoreName);
                return streamFeatureGroupDTO;
            }
            case ON_DEMAND_FEATURE_GROUP: {
                FeaturestoreStorageConnectorDTO storageConnectorDTO = this.connectorController.convertToConnectorDTO(user, project, featuregroup.getOnDemandFeaturegroup().getFeaturestoreConnector());
                OnDemandFeaturegroupDTO onDemandFeaturegroupDTO = new OnDemandFeaturegroupDTO(featurestoreName, featuregroup, storageConnectorDTO);
                try {
                    String path = this.getFeatureGroupLocation(featuregroup);
                    String location = this.featurestoreUtils.prependNameNode(path);
                    onDemandFeaturegroupDTO.setLocation(location);
                }
                catch (ServiceDiscoveryException e) {
                    throw new ServiceException(RESTCodes.ServiceErrorCode.SERVICE_NOT_FOUND, Level.SEVERE);
                }
                return onDemandFeaturegroupDTO;
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + "," + FeaturegroupType.STREAM_FEATURE_GROUP + ",  and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public List<FeaturegroupDTO> getFeaturegroupWithNameAndFeaturestore(Featurestore featurestore, String name, Project project, Users user) throws FeaturestoreException, ServiceException {
        List<Featuregroup> featuregroups = this.verifyFeaturegroupName(featurestore, name);
        ArrayList<FeaturegroupDTO> featuregroupDTOS = new ArrayList<FeaturegroupDTO>();
        for (Featuregroup featuregroup : featuregroups) {
            featuregroupDTOS.add(this.convertFeaturegrouptoDTO(featuregroup, project, user));
        }
        return featuregroupDTOS;
    }

    public FeaturegroupDTO getFeaturegroupWithNameVersionAndFeaturestore(Featurestore featurestore, String name, Integer version, Project project, Users user) throws FeaturestoreException, ServiceException {
        Featuregroup featuregroup = this.verifyFeaturegroupNameVersion(featurestore, name, version);
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    public FeaturegroupDTO getFeaturegroupWithIdAndFeaturestore(Featurestore featurestore, Integer id, Project project, Users user) throws FeaturestoreException, ServiceException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, id);
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeaturegroupDTO updateFeaturegroupMetadata(Project project, Users user, Featurestore featurestore, FeaturegroupDTO featuregroupDTO) throws FeaturestoreException, SQLException, ProvenanceException, ServiceException, SchemaException, KafkaException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        this.featurestoreUtils.verifyUserProjectEqualsFsProjectAndDataOwner(user, project, featuregroup.getFeaturestore(), FeaturestoreUtils.ActionMessage.UPDATE_FEATURE_GROUP_METADATA);
        this.featurestoreInputValidation.verifyDescription(featuregroupDTO);
        this.featureGroupInputValidation.verifyFeatureGroupFeatureList(featuregroupDTO.getFeatures());
        this.featureGroupInputValidation.verifyOnlineOfflineTypeMatch(featuregroupDTO);
        this.featureGroupInputValidation.verifyOnlineSchemaValid(featuregroupDTO);
        this.featureGroupInputValidation.verifyPrimaryKeySupported(featuregroupDTO);
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP) {
            this.cachedFeaturegroupController.updateMetadata(project, user, featuregroup, (CachedFeaturegroupDTO)featuregroupDTO);
        } else if (featuregroup.getFeaturegroupType() == FeaturegroupType.STREAM_FEATURE_GROUP) {
            this.streamFeatureGroupController.updateMetadata(project, user, featuregroup, (StreamFeatureGroupDTO)featuregroupDTO);
        } else if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            this.onDemandFeaturegroupController.updateOnDemandFeaturegroupMetadata(featuregroup.getOnDemandFeaturegroup(), (OnDemandFeaturegroupDTO)featuregroupDTO);
        }
        featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        featuregroupDTO = this.convertFeaturegrouptoDTO(featuregroup, project, user);
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
        DistributedFileSystemOps udfso = this.dfs.getDfsOps(hdfsUsername);
        try {
            String fgPath = Utils.getFeaturestorePath(featurestore.getProject(), this.settings) + "/" + Utils.getFeaturegroupName(featuregroup);
            this.fsController.featuregroupAttachXAttrs(fgPath, featuregroupDTO, udfso);
        }
        finally {
            this.dfs.closeDfsClient(udfso);
        }
        return featuregroupDTO;
    }

    public FeaturegroupDTO enableFeaturegroupOnline(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Project project, Users user) throws FeaturestoreException, SQLException, ServiceException, KafkaException, SchemaException, ProjectException, UserException, IOException, HopsSecurityException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featuregroupDTO.getId());
        this.featurestoreUtils.verifyUserProjectEqualsFsProjectAndDataOwner(user, project, featuregroup.getFeaturestore(), FeaturestoreUtils.ActionMessage.ENABLE_FEATURE_GROUP_ONLINE);
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ONLINE_FEATURE_SERVING_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, ", Online feature serving is only supported for featuregroups of type: " + FeaturegroupType.CACHED_FEATURE_GROUP + ", and the user requested to enable feature serving on a featuregroup with type:" + FeaturegroupType.ON_DEMAND_FEATURE_GROUP);
        }
        this.cachedFeaturegroupController.enableFeaturegroupOnline(featurestore, featuregroup, project, user);
        this.fsActivityFacade.logMetadataActivity(user, featuregroup, FeaturestoreActivityMeta.ONLINE_ENABLED, null);
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    public FeaturegroupDTO disableFeaturegroupOnline(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException, SQLException, ServiceException, SchemaException, KafkaException {
        this.featurestoreUtils.verifyUserProjectEqualsFsProjectAndDataOwner(user, project, featuregroup.getFeaturestore(), FeaturestoreUtils.ActionMessage.DISABLE_FEATURE_GROUP_ONLINE);
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ONLINE_FEATURE_SERVING_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, ", Online feature serving is only supported for featuregroups of type: " + FeaturegroupType.CACHED_FEATURE_GROUP + ", and the user requested to a feature serving operation on a featuregroup with type:" + FeaturegroupType.ON_DEMAND_FEATURE_GROUP);
        }
        this.cachedFeaturegroupController.disableFeaturegroupOnline(featuregroup, project, user);
        this.fsActivityFacade.logMetadataActivity(user, featuregroup, FeaturestoreActivityMeta.ONLINE_DISABLED, null);
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    public FeaturegroupDTO updateFeatureGroupStatsConfig(Featurestore featurestore, FeaturegroupDTO featureGroupDTO, Project project, Users user) throws FeaturestoreException, ServiceException {
        Featuregroup featuregroup = this.getFeaturegroupById(featurestore, featureGroupDTO.getId());
        this.featurestoreUtils.verifyUserProjectEqualsFsProjectAndDataOwner(user, project, featuregroup.getFeaturestore(), FeaturestoreUtils.ActionMessage.UPDATE_FEATURE_GROUP_STATS_CONFIG);
        if (featureGroupDTO.getStatisticsConfig().getEnabled() != null) {
            featuregroup.getStatisticsConfig().setDescriptive(featureGroupDTO.getStatisticsConfig().getEnabled().booleanValue());
        }
        if (featureGroupDTO.getStatisticsConfig().getHistograms() != null) {
            featuregroup.getStatisticsConfig().setHistograms(featureGroupDTO.getStatisticsConfig().getHistograms().booleanValue());
        }
        if (featureGroupDTO.getStatisticsConfig().getCorrelations() != null) {
            featuregroup.getStatisticsConfig().setCorrelations(featureGroupDTO.getStatisticsConfig().getCorrelations().booleanValue());
        }
        if (featureGroupDTO.getStatisticsConfig().getExactUniqueness() != null) {
            featuregroup.getStatisticsConfig().setExactUniqueness(featureGroupDTO.getStatisticsConfig().getExactUniqueness().booleanValue());
        }
        this.statisticColumnController.verifyStatisticColumnsExist(featureGroupDTO, featuregroup, this.getFeatures(featuregroup, project, user));
        this.featuregroupFacade.updateFeaturegroupMetadata(featuregroup);
        this.statisticColumnController.persistStatisticColumns(featuregroup, featureGroupDTO.getStatisticsConfig().getColumns());
        featuregroup = this.getFeaturegroupById(featurestore, featureGroupDTO.getId());
        return this.convertFeaturegrouptoDTO(featuregroup, project, user);
    }

    public boolean featuregroupExists(Featurestore featurestore, FeaturegroupDTO featuregroupDTO) {
        if (!Strings.isNullOrEmpty((String)featuregroupDTO.getName()) && featuregroupDTO.getVersion() != null) {
            return this.featuregroupFacade.findByNameVersionAndFeaturestore(featuregroupDTO.getName(), featuregroupDTO.getVersion(), featurestore).isPresent();
        }
        return false;
    }

    public void deleteFeaturegroup(Featuregroup featuregroup, Project project, Users user) throws SQLException, FeaturestoreException, ServiceException, IOException, SchemaException, KafkaException, JobException {
        this.featurestoreUtils.verifyUserProjectEqualsFsProjectAndDataOwner(user, project, featuregroup.getFeaturestore(), FeaturestoreUtils.ActionMessage.DELETE_FEATURE_GROUP);
        if (featuregroup.getOnDemandFeaturegroup() == null && featuregroup.getCachedFeaturegroup() == null && featuregroup.getStreamFeatureGroup() == null) {
            this.deleteFeatureGroupMeta(featuregroup);
            return;
        }
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                this.cachedFeaturegroupController.dropHiveFeaturegroup(featuregroup, project, user);
                if (!this.settings.isOnlineFeaturestore().booleanValue() || !featuregroup.getCachedFeaturegroup().isOnlineEnabled()) break;
                this.onlineFeaturegroupController.disableOnlineFeatureGroup(featuregroup, project, user);
                break;
            }
            case STREAM_FEATURE_GROUP: {
                this.cachedFeaturegroupController.dropHiveFeaturegroup(featuregroup, project, user);
                if (this.settings.isOnlineFeaturestore().booleanValue() && featuregroup.getStreamFeatureGroup().isOnlineEnabled()) {
                    this.onlineFeaturegroupController.disableOnlineFeatureGroup(featuregroup, project, user);
                    break;
                }
                this.streamFeatureGroupController.deleteOfflineStreamFeatureGroupTopic(project, featuregroup);
                break;
            }
            case ON_DEMAND_FEATURE_GROUP: {
                this.onDemandFeaturegroupController.removeOnDemandFeaturegroup(featuregroup.getFeaturestore(), featuregroup, project, user);
                break;
            }
            default: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
            }
        }
        this.fsJobManagerController.deleteJobs(project, user, featuregroup);
        this.validationReportController.deleteFeaturegroupDataValidationDir(user, featuregroup);
        this.statisticsController.deleteStatistics(project, user, featuregroup);
        this.deleteFeatureGroupMeta(featuregroup);
    }

    private void deleteFeatureGroupMeta(Featuregroup featuregroup) {
        if (this.featuregroupFacade.findByIdAndFeaturestore(featuregroup.getId(), featuregroup.getFeaturestore()).isPresent()) {
            this.featuregroupFacade.remove(featuregroup);
        }
    }

    public List<HivePartitions> getPartitions(Featuregroup featuregroup, Integer offset, Integer limit) throws FeaturestoreException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                return this.cachedFeaturegroupFacade.getHiveTablePartitions(featuregroup.getCachedFeaturegroup().getHiveTbls(), offset, limit);
            }
            case STREAM_FEATURE_GROUP: {
                return this.streamFeatureGroupFacade.getHiveTablePartitions(featuregroup.getStreamFeatureGroup().getHiveTbls(), offset, limit);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_ONDEMAND_NO_PARTS, Level.FINE, "featuregroupId: " + featuregroup.getId());
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + FeaturegroupType.ON_DEMAND_FEATURE_GROUP + ", and: " + FeaturegroupType.CACHED_FEATURE_GROUP + ". The provided feature group type was not recognized: " + featuregroup.getFeaturegroupType());
    }

    public Featuregroup getFeaturegroupById(Featurestore featurestore, Integer featuregroupId) throws FeaturestoreException {
        return this.featuregroupFacade.findByIdAndFeaturestore(featuregroupId, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.FINE, "Feature group id: " + featuregroupId));
    }

    private List<Featuregroup> verifyFeaturegroupName(Featurestore featurestore, String featureGroupName) {
        List<Featuregroup> featuregroup = this.featuregroupFacade.findByNameAndFeaturestore(featureGroupName, featurestore);
        if (featuregroup == null || featuregroup.isEmpty()) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND + " feature group name " + featureGroupName);
        }
        return featuregroup;
    }

    public Featuregroup verifyFeaturegroupNameVersion(Featurestore featurestore, String featureGroupName, Integer version) throws FeaturestoreException {
        return this.featuregroupFacade.findByNameVersionAndFeaturestore(featureGroupName, version, featurestore).orElseThrow(() -> new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.FINE, "feature group name: " + featureGroupName + " feature group version: " + version));
    }

    private Featuregroup persistFeaturegroupMetadata(Featurestore featurestore, Project project, Users user, FeaturegroupDTO featuregroupDTO, CachedFeaturegroup cachedFeaturegroup, StreamFeatureGroup streamFeatureGroup, OnDemandFeaturegroup onDemandFeaturegroup) throws FeaturestoreException, JobException {
        Featuregroup featuregroup = new Featuregroup();
        featuregroup.setName(featuregroupDTO.getName());
        featuregroup.setFeaturestore(featurestore);
        featuregroup.setCreated(new Date());
        featuregroup.setCreator(user);
        featuregroup.setVersion(featuregroupDTO.getVersion());
        if (featuregroupDTO instanceof CachedFeaturegroupDTO) {
            featuregroup.setFeaturegroupType(FeaturegroupType.CACHED_FEATURE_GROUP);
        } else if (featuregroupDTO instanceof StreamFeatureGroupDTO) {
            featuregroup.setFeaturegroupType(FeaturegroupType.STREAM_FEATURE_GROUP);
            StreamFeatureGroupDTO streamFeatureGroupDTO = (StreamFeatureGroupDTO)featuregroupDTO;
            this.fsJobManagerController.setupHudiDeltaStreamerJob(project, user, featuregroup, streamFeatureGroupDTO.getDeltaStreamerJobConf());
        } else {
            featuregroup.setFeaturegroupType(FeaturegroupType.ON_DEMAND_FEATURE_GROUP);
        }
        featuregroup.setCachedFeaturegroup(cachedFeaturegroup);
        featuregroup.setStreamFeatureGroup(streamFeatureGroup);
        featuregroup.setOnDemandFeaturegroup(onDemandFeaturegroup);
        featuregroup.setEventTime(featuregroupDTO.getEventTime());
        StatisticsConfig statisticsConfig = new StatisticsConfig(featuregroupDTO.getStatisticsConfig().getEnabled().booleanValue(), featuregroupDTO.getStatisticsConfig().getCorrelations().booleanValue(), featuregroupDTO.getStatisticsConfig().getHistograms().booleanValue(), featuregroupDTO.getStatisticsConfig().getExactUniqueness().booleanValue());
        statisticsConfig.setFeaturegroup(featuregroup);
        statisticsConfig.setStatisticColumns((Collection)featuregroupDTO.getStatisticsConfig().getColumns().stream().map(sc -> new StatisticColumn(statisticsConfig, sc)).collect(Collectors.toList()));
        featuregroup.setStatisticsConfig(statisticsConfig);
        if (featuregroupDTO.getExpectationSuite() != null) {
            featuregroup.setExpectationSuite(this.expectationSuiteController.convertExpectationSuiteDTOToPersistent(featuregroup, featuregroupDTO.getExpectationSuite()));
        }
        this.featuregroupFacade.persist(featuregroup);
        return featuregroup;
    }

    public List<FeatureGroupFeatureDTO> getFeatures(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException {
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                return this.cachedFeaturegroupController.getFeaturesDTO(featuregroup.getCachedFeaturegroup(), featuregroup.getId(), featuregroup.getFeaturestore(), project, user);
            }
            case STREAM_FEATURE_GROUP: {
                return this.cachedFeaturegroupController.getFeaturesDTO(featuregroup.getStreamFeatureGroup(), featuregroup.getId(), featuregroup.getFeaturestore(), project, user);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                return featuregroup.getOnDemandFeaturegroup().getFeatures().stream().map(f -> new FeatureGroupFeatureDTO(f.getName(), f.getType(), f.getPrimary(), null, featuregroup.getId())).collect(Collectors.toList());
            }
        }
        return new ArrayList<FeatureGroupFeatureDTO>();
    }

    public String getTblName(String featuregroupName, Integer version) {
        return featuregroupName + "_" + version.toString();
    }

    public List<String> getFeatureNames(Featuregroup featuregroup, Project project, Users user) throws FeaturestoreException {
        return this.getFeatures(featuregroup, project, user).stream().map(FeatureGroupFeatureDTO::getName).collect(Collectors.toList());
    }

    public String getFeatureGroupLocation(Featuregroup featureGroup) {
        if (featureGroup.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP) {
            return this.inodeController.getPath(featureGroup.getCachedFeaturegroup().getHiveTbls().getSdId().getInode());
        }
        if (featureGroup.getFeaturegroupType() == FeaturegroupType.STREAM_FEATURE_GROUP) {
            return this.inodeController.getPath(featureGroup.getStreamFeatureGroup().getHiveTbls().getSdId().getInode());
        }
        return this.inodeController.getPath(featureGroup.getOnDemandFeaturegroup().getInode());
    }

    private void verifyFeatureGroupInput(FeaturegroupDTO featureGroupDTO) throws FeaturestoreException {
        this.featureGroupInputValidation.verifyUserInput(featureGroupDTO);
        this.featureGroupInputValidation.verifyEventTimeFeature(featureGroupDTO.getEventTime(), featureGroupDTO.getFeatures());
        this.featureGroupInputValidation.verifyOnlineOfflineTypeMatch(featureGroupDTO);
        this.featureGroupInputValidation.verifyOnlineSchemaValid(featureGroupDTO);
        this.featureGroupInputValidation.verifyPrimaryKeySupported(featureGroupDTO);
        this.featureGroupInputValidation.verifyPartitionKeySupported(featureGroupDTO);
        this.verifyFeatureGroupVersion(featureGroupDTO.getVersion());
        this.statisticColumnController.verifyStatisticColumnsExist(featureGroupDTO);
    }

    private void verifyFeatureGroupVersion(Integer version) throws FeaturestoreException {
        if (version == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_VERSION_NOT_PROVIDED.getMessage());
        }
        if (version <= 0) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_VERSION, Level.FINE, "version cannot be negative or zero");
        }
    }

    void verifyFeaturesNoDefaultValue(List<FeatureGroupFeatureDTO> features) throws FeaturestoreException {
        if (features.stream().anyMatch(f -> f.getDefaultValue() != null)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATURE_GROUP_FEATURE_DEFAULT_VALUE, Level.FINE, "default values for features cannot be set during feature group creation, only allowed for appenedfeatures");
        }
    }

    private void enforceFeaturegroupQuotas(Featurestore featurestore, FeaturegroupDTO featuregroup) throws FeaturestoreException {
        try {
            boolean onlineEnabled = false;
            if (featuregroup instanceof CachedFeaturegroupDTO) {
                onlineEnabled = ((CachedFeaturegroupDTO)featuregroup).getOnlineEnabled();
            } else if (featuregroup instanceof StreamFeatureGroupDTO) {
                onlineEnabled = ((StreamFeatureGroupDTO)featuregroup).getOnlineEnabled();
            }
            this.quotasEnforcement.enforceFeaturegroupsQuota(featurestore, onlineEnabled);
        }
        catch (QuotaEnforcementException ex) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_CREATE_FEATUREGROUP, Level.SEVERE, ex.getMessage(), ex.getMessage(), (Throwable)ex);
        }
    }
}

