/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.project.service;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.service.ProjectServiceEnum;
import io.hops.hopsworks.persistence.entity.project.service.ProjectServicePK;
import io.hops.hopsworks.persistence.entity.project.service.ProjectServices;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class ProjectServiceFacade
extends AbstractFacade<ProjectServices> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public ProjectServiceFacade() {
        super(ProjectServices.class);
    }

    public List<ProjectServiceEnum> findEnabledServicesForProject(Project project) {
        TypedQuery q = this.em.createNamedQuery("ProjectServices.findServicesByProject", ProjectServiceEnum.class);
        q.setParameter("project", (Object)project);
        return q.getResultList();
    }

    public void persistServicesForProject(Project project, ProjectServiceEnum[] services) {
        ArrayList<ProjectServices> newSrvs = new ArrayList<ProjectServices>(services.length);
        ArrayList<ProjectServices> toPersist = new ArrayList<ProjectServices>(services.length);
        for (ProjectServiceEnum sse : services) {
            ProjectServices c = new ProjectServices(project, sse);
            newSrvs.add(c);
            toPersist.add(c);
        }
        List<ProjectServices> current = this.getAllProjectServicesForProject(project);
        toPersist.removeAll(current);
        current.removeAll(newSrvs);
        for (ProjectServices se : toPersist) {
            this.em.persist((Object)se);
        }
        for (ProjectServices se : current) {
            this.em.remove((Object)se);
        }
    }

    public void addServiceForProject(Project project, ProjectServiceEnum service) {
        if (!this.findEnabledServicesForProject(project).contains(service)) {
            ProjectServices ss = new ProjectServices(project, service);
            this.em.persist((Object)ss);
        }
    }

    public void removeServiceForProject(Project project, ProjectServiceEnum service) {
        ProjectServices c = (ProjectServices)this.em.find(ProjectServices.class, (Object)new ProjectServicePK(project.getId().intValue(), service));
        if (c != null) {
            this.em.remove((Object)c);
        }
    }

    public List<ProjectServices> getAllProjectServicesForProject(Project project) {
        TypedQuery q = this.em.createNamedQuery("ProjectServices.findByProject", ProjectServices.class);
        q.setParameter("project", (Object)project);
        return q.getResultList();
    }

    public boolean isServiceEnabledForProject(Project project, ProjectServiceEnum service) {
        TypedQuery q = this.em.createNamedQuery("ProjectServices.isServiceEnabledForProject", ProjectServices.class);
        q.setParameter("project", (Object)project);
        q.setParameter("service", (Object)service);
        return !q.getResultList().isEmpty();
    }
}

