/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2.expectations;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.expectations.ExpectationDTO;
import io.hops.hopsworks.common.featurestore.datavalidationv2.expectations.ExpectationFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.persistence.entity.featurestore.activity.FeaturestoreActivityMeta;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.Expectation;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ExpectationSuite;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ExpectationController {
    private static final Logger LOGGER = Logger.getLogger(ExpectationController.class.getName());
    @EJB
    ExpectationFacade expectationFacade;
    @EJB
    FeaturestoreActivityFacade fsActivityFacade;
    @EJB
    FeaturegroupController featuregroupController;

    public Expectation getExpectationById(Integer expectationId) throws FeaturestoreException {
        Optional<Expectation> expectation = this.expectationFacade.findById(expectationId);
        return expectation.orElse(null);
    }

    public void createExpectation(Expectation expectation) {
        this.expectationFacade.createExpectation(expectation);
    }

    public void updateExpectation(Expectation expectation) throws FeaturestoreException {
        Expectation oldExpectation = this.getExpectationById(expectation.getId());
        this.preserveTypeAndColumn(oldExpectation, expectation);
        this.expectationFacade.updateExpectation(expectation);
    }

    public Expectation createOrUpdateExpectation(Users user, ExpectationSuite expectationSuite, ExpectationDTO expectationDTO, boolean logActivity, boolean verifyInput) throws FeaturestoreException {
        if (verifyInput) {
            this.verifyExpectationFields(expectationDTO, this.featuregroupController.getFeatureNames(expectationSuite.getFeaturegroup(), expectationSuite.getFeaturegroup().getFeaturestore().getProject(), user));
        }
        Integer expectationId = null;
        expectationId = expectationDTO.getId() == null ? this.parseExpectationIdIfExist(expectationDTO) : expectationDTO.getId();
        expectationDTO.setId(expectationId);
        Expectation expectation = this.convertExpectationDTOToPersistent(expectationSuite, expectationDTO);
        String activityMessage = null;
        if (expectation.getId() == null) {
            this.createExpectation(expectation);
            activityMessage = String.format("Created expectation with id: %d.", expectation.getId());
        } else {
            this.updateExpectation(expectation);
            activityMessage = String.format("Updated expectation with id: %d.", expectation.getId());
        }
        if (logActivity) {
            FeaturestoreActivityMeta activityMeta = FeaturestoreActivityMeta.EXPECTATION_SUITE_UPDATED;
            this.fsActivityFacade.logExpectationSuiteActivity(user, expectationSuite.getFeaturegroup(), expectationSuite, activityMeta, activityMessage);
        }
        return expectation;
    }

    public void deleteExpectation(Users user, Integer expectationId, boolean logActivity) throws FeaturestoreException {
        Expectation expectation = this.expectationFacade.findById(expectationId).orElse(null);
        ExpectationSuite expectationSuite = null;
        String activityMessage = null;
        if (expectation != null) {
            expectationSuite = expectation.getExpectationSuite();
            activityMessage = String.format("Deleted expectation with id: %d.", expectation.getId());
        }
        this.expectationFacade.remove(expectation);
        if (expectation != null && logActivity) {
            FeaturestoreActivityMeta activityMeta = FeaturestoreActivityMeta.EXPECTATION_SUITE_UPDATED;
            this.fsActivityFacade.logExpectationSuiteActivity(user, expectationSuite.getFeaturegroup(), expectationSuite, activityMeta, activityMessage);
        }
    }

    public AbstractFacade.CollectionInfo<Expectation> getExpectationsByExpectationSuite(ExpectationSuite expectationSuite) {
        return this.expectationFacade.findByExpectationSuite(expectationSuite);
    }

    public Integer parseExpectationIdIfExist(ExpectationDTO expectationDTO) {
        Integer expectationId = null;
        try {
            JSONObject meta = new JSONObject(expectationDTO.getMeta());
            if (meta.has("expectationId")) {
                expectationId = meta.getInt("expectationId");
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return expectationId;
    }

    public Expectation convertExpectationDTOToPersistent(ExpectationSuite expectationSuite, ExpectationDTO dto) {
        Expectation persistentExpectation = new Expectation();
        persistentExpectation.setExpectationSuite(expectationSuite);
        persistentExpectation.setKwargs(dto.getKwargs());
        persistentExpectation.setMeta(dto.getMeta());
        persistentExpectation.setExpectationType(dto.getExpectationType());
        persistentExpectation.setId(dto.getId());
        return persistentExpectation;
    }

    public void verifyExpectationFields(ExpectationDTO dto, List<String> featureNames) throws FeaturestoreException {
        this.verifyExpectationExpectationType(dto);
        this.verifyExpectationKwargs(dto, featureNames);
        this.verifyExpectationMeta(dto);
    }

    private void verifyExpectationMeta(ExpectationDTO dto) throws FeaturestoreException {
        String meta = dto.getMeta();
        if (meta == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Expectation meta cannot be null. Pass a stringified JSON.");
        }
        if (meta.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Meta field %s exceeds the max allowed character length %d.", meta, 1000));
        }
        try {
            new JSONObject(meta);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Expectation Meta field %s is not a valid json.", meta), e.getMessage());
        }
    }

    private void verifyExpectationKwargs(ExpectationDTO dto, List<String> featureNames) throws FeaturestoreException {
        JSONObject jsonKwargs;
        String kwargs = dto.getKwargs();
        if (kwargs == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Expectation Kwargs cannot be null. Pass a stringified JSON.");
        }
        if (kwargs.length() > 5000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Kwargs field %s exceeds the max allowed character length %d.", kwargs, 5000));
        }
        try {
            jsonKwargs = new JSONObject(kwargs);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Expectation Kwargs field %s is not a valid json.", kwargs), e.getMessage());
        }
        this.verifyKwargsColumnExistence(featureNames, jsonKwargs);
    }

    private void verifyExpectationExpectationType(ExpectationDTO dto) throws FeaturestoreException {
        String expectationType = dto.getExpectationType();
        if (expectationType == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Expectation Expectation Type cannot be null. Pass a supported expectation type.");
        }
        if (expectationType.length() > 150) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Expectation Expectation Type field %s exceeds the max allowed character length %d.", expectationType, 150));
        }
    }

    private void verifyKwargsColumnExistence(List<String> featureNames, JSONObject jsonKwargs) throws FeaturestoreException {
        int index;
        JSONArray columns;
        ArrayList<String> possibleFeatureNames = new ArrayList<String>();
        if (jsonKwargs.has("column")) {
            possibleFeatureNames.add(jsonKwargs.getString("column"));
        } else if (jsonKwargs.has("columnA") && jsonKwargs.has("columnB")) {
            possibleFeatureNames.add(jsonKwargs.getString("columnA"));
            possibleFeatureNames.add(jsonKwargs.getString("columnB"));
        } else if (jsonKwargs.has("column_list")) {
            columns = jsonKwargs.getJSONArray("column_list");
            for (index = 0; index < columns.length(); ++index) {
                possibleFeatureNames.add(columns.getString(index));
            }
        } else if (jsonKwargs.has("column_set")) {
            columns = jsonKwargs.getJSONArray("column_set");
            for (index = 0; index < columns.length(); ++index) {
                possibleFeatureNames.add(columns.getString(index));
            }
        } else {
            return;
        }
        for (String name : possibleFeatureNames) {
            if (featureNames.contains(name)) continue;
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_NAME_NOT_FOUND, Level.SEVERE, String.format("Expectation Kwargs contains name %s which has not been found in this group's feature:\n%s.", name, featureNames));
        }
    }

    private void preserveTypeAndColumn(Expectation oldExpectation, Expectation newExpectation) throws FeaturestoreException {
        JSONObject newKwargs;
        JSONObject oldKwargs;
        if (!oldExpectation.getExpectationType().equals(newExpectation.getExpectationType())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_EXPECTATION_UPDATE, Level.SEVERE, String.format("The stored expectation has type %s but updated expectation has type %s.", oldExpectation.getExpectationType(), newExpectation.getExpectationType()));
        }
        try {
            oldKwargs = new JSONObject(oldExpectation.getKwargs());
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Expectation % Kwargs field %s is not a valid json.", oldExpectation.getId(), oldExpectation.getKwargs()), e.getMessage());
        }
        try {
            newKwargs = new JSONObject(newExpectation.getKwargs());
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Expectation %d Kwargs field %s is not a valid json.", newExpectation.getId(), newExpectation.getKwargs()), e.getMessage());
        }
        if (oldKwargs.has("column") && newKwargs.has("column") && !oldKwargs.getString("column").equals(newKwargs.getString("column"))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_EXPECTATION_UPDATE, Level.SEVERE, String.format("The stored expectation has kwarg column %s but updated expectation has kwarg column %s.", oldKwargs.getString("column"), newKwargs.getString("column")));
        }
        if (oldKwargs.has("columnA") && newKwargs.has("columnA") && oldKwargs.has("columnB") && newKwargs.has("columnB") && !oldKwargs.getString("columnA").equals(newKwargs.getString("columnA")) && !oldKwargs.getString("columnB").equals(newKwargs.getString("columnB"))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_EXPECTATION_UPDATE, Level.SEVERE, String.format("The stored expectation has kwarg column %s but updated expectation has kwarg column %s.", oldKwargs.getString("column"), newKwargs.getString("column")));
        }
    }

    public Expectation addExpectationIdToMetaField(Expectation expectation) throws FeaturestoreException {
        try {
            JSONObject meta = new JSONObject(expectation.getMeta());
            meta.put("expectationId", (Object)expectation.getId());
            expectation.setMeta(meta.toString());
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FAILED_TO_PARSE_EXPECTATION_META_FIELD, Level.SEVERE, String.format("Expectation meta field is not valid json : %s", expectation.getMeta()));
        }
        return expectation;
    }
}

