/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user;

import io.hops.hopsworks.common.dao.user.security.ua.UserAccountsEmailMessages;
import io.hops.hopsworks.common.integrations.UnmanagedStereotype;
import io.hops.hopsworks.common.security.utils.SecurityUtils;
import io.hops.hopsworks.common.user.AuthController;
import io.hops.hopsworks.common.user.PasswordRecovery;
import io.hops.hopsworks.common.util.EmailBean;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.mail.Message;
import javax.mail.MessagingException;

@UnmanagedStereotype
@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class UnmanagedPasswordRecovery
implements PasswordRecovery {
    private static final Logger LOG = Logger.getLogger(UnmanagedPasswordRecovery.class.getName());
    @EJB
    private SecurityUtils securityUtils;
    @EJB
    private EmailBean emailBean;

    @Override
    public void sendRecoveryNotification(Users user, String url, boolean isPassword, AuthController.CredentialsResetToken resetToken) throws MessagingException {
        String subject = "You have requested to recover a lost device";
        String encodedToken = this.securityUtils.urlEncode(resetToken.getToken());
        String msg = UserAccountsEmailMessages.buildQRRecoveryMessage(url, user.getUsername() + encodedToken, resetToken.getValidity());
        if (isPassword) {
            subject = "You have requested to recover your password";
            msg = UserAccountsEmailMessages.buildPasswordRecoveryMessage(url, user.getUsername() + encodedToken, resetToken.getValidity());
        }
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
    }
}

