/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.project.pia;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.project.pia.Pia;
import java.util.ArrayList;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class PiaFacade
extends AbstractFacade<Pia> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public PiaFacade() {
        super(Pia.class);
    }

    public Pia findByProject(int projectId) {
        TypedQuery q = this.em.createNamedQuery("Pia.findByProjectId", Pia.class);
        q.setParameter("projectId", (Object)projectId);
        ArrayList<Pia> allPias = q.getResultList();
        if (allPias == null || allPias.isEmpty()) {
            Pia p = new Pia();
            p.setProjectId(projectId);
            allPias = new ArrayList<Pia>();
            allPias.add(p);
        }
        return (Pia)allPias.iterator().next();
    }

    public Pia mergeUpdate(Pia pia, int projectId) {
        Pia piaManaged = this.findByProject(projectId);
        pia.setProjectId(projectId);
        piaManaged.deepCopy(pia);
        return this.update(piaManaged);
    }
}

