/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core.dto;

import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.Objects;
import java.util.logging.Level;
import javax.ws.rs.QueryParam;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ProvTypeDTO {
    @QueryParam(value="metaStatus")
    @XmlElement(name="meta_status")
    private Inode.MetaStatus metaStatus;
    @QueryParam(value="provStatus")
    @XmlElement(name="prov_status")
    private Provenance.OpStore provStatus;

    public ProvTypeDTO() {
    }

    public ProvTypeDTO(Inode.MetaStatus metaStatus, Provenance.OpStore provStatus) {
        this.metaStatus = metaStatus;
        this.provStatus = provStatus;
    }

    public Inode.MetaStatus getMetaStatus() {
        return this.metaStatus;
    }

    public void setMetaStatus(Inode.MetaStatus metaStatus) {
        this.metaStatus = metaStatus;
    }

    public Provenance.OpStore getProvStatus() {
        return this.provStatus;
    }

    public void setProvStatus(Provenance.OpStore provStatus) {
        this.provStatus = provStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProvTypeDTO that = (ProvTypeDTO)o;
        return this.metaStatus == that.metaStatus && this.provStatus == that.provStatus;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metaStatus, this.provStatus});
    }

    public static Provenance.Type provTypeFromString(String aux) throws ProvenanceException {
        try {
            return Provenance.Type.valueOf(aux.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.UNSUPPORTED, Level.INFO, "malformed type", "malformed type", (Throwable)e);
        }
    }
}

