/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.upload;

import io.hops.hopsworks.common.upload.ResumableInfo;
import java.util.HashMap;

public class ResumableInfoStorage {
    private static ResumableInfoStorage sInstance;
    private HashMap<String, ResumableInfo> mMap = new HashMap();

    private ResumableInfoStorage() {
    }

    public static synchronized ResumableInfoStorage getInstance() {
        if (sInstance == null) {
            sInstance = new ResumableInfoStorage();
        }
        return sInstance;
    }

    public synchronized ResumableInfo get(int resumableChunkSize, long resumableTotalSize, String resumableIdentifier, String resumableFilename, String resumableRelativePath, String resumableFilePath) {
        ResumableInfo info = this.mMap.get(resumableIdentifier);
        if (info == null) {
            info = new ResumableInfo();
            info.setResumableChunkSize(resumableChunkSize);
            info.setResumableTotalSize(resumableTotalSize);
            info.setResumableIdentifier(resumableIdentifier);
            info.setResumableFilename(resumableFilename);
            info.setResumableRelativePath(resumableRelativePath);
            info.setResumableFilePath(resumableFilePath);
            this.mMap.put(resumableIdentifier, info);
        }
        return info;
    }

    public void remove(ResumableInfo info) {
        this.mMap.remove(info.getResumableIdentifier());
    }
}

