/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import com.google.common.annotations.VisibleForTesting;
import io.hops.hopsworks.common.dao.jobhistory.ExecutionFacade;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.featurestore.trainingdatasets.TrainingDatasetFacade;
import io.hops.hopsworks.common.security.QuotaEnforcementException;
import io.hops.hopsworks.common.serving.ServingController;
import io.hops.hopsworks.common.serving.ServingStatusEnum;
import io.hops.hopsworks.common.serving.ServingWrapper;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import io.hops.hopsworks.exceptions.KafkaException;
import io.hops.hopsworks.exceptions.ServingException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.cached.CachedFeaturegroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.ondemand.OnDemandFeaturegroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.stream.StreamFeatureGroup;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class QuotasEnforcement {
    private static final Logger LOGGER = Logger.getLogger(QuotasEnforcement.class.getName());
    private static final long NO_QUOTA = -1L;
    @Inject
    private ServingController servingController;
    @EJB
    private Settings settings;
    @EJB
    private FeaturegroupFacade featuregroupFacade;
    @EJB
    private TrainingDatasetFacade trainingDatasetFacade;
    @EJB
    private ExecutionFacade executionFacade;
    private static final String FEATUREGROUPS_QUOTA_EXCEEDED = "Online %s feature groups quota reached for Project %s. Current: %d Max: %d";

    public void enforceFeaturegroupsQuota(Featurestore featurestore, boolean onlineEnabled) throws QuotaEnforcementException {
        LOGGER.log(Level.FINE, "Enforcing feature groups quota for Project " + featurestore.getProject().getName());
        if (onlineEnabled) {
            long maxFeaturegroups = this.getMaxNumberOfOnlineEnabledFeaturegroups();
            if (!this.shouldIgnoreQuota(maxFeaturegroups)) {
                List<Featuregroup> featuregroups = this.getFeaturegroups(featurestore);
                this.enforceFeaturegroupsQuotaInternal(featurestore, featuregroups, maxFeaturegroups, true);
            } else {
                LOGGER.log(Level.FINE, "Skip quotas enforcement for online enabled feature groups because configured quota is: -1");
            }
        } else {
            long maxFeaturegroups = this.getMaxNumberOfOnlineDisabledFeaturegroups();
            if (!this.shouldIgnoreQuota(maxFeaturegroups)) {
                List<Featuregroup> featuregroups = this.getFeaturegroups(featurestore);
                this.enforceFeaturegroupsQuotaInternal(featurestore, featuregroups, maxFeaturegroups, false);
            } else {
                LOGGER.log(Level.FINE, "Skip quotas enforcement for online disabled feature groups because configured quota is: -1");
            }
        }
    }

    private List<Featuregroup> getFeaturegroups(Featurestore featurestore) {
        return this.featuregroupFacade.findByFeaturestore(featurestore);
    }

    public void enforceTrainingDatasetsQuota(Featurestore featurestore) throws QuotaEnforcementException {
        LOGGER.log(Level.FINE, "Enforcing training dataset quota for Project " + featurestore.getProject().getName());
        long maxNumberOfTrainingDatasets = this.getMaxNumberOfTrainingDatasets();
        if (this.shouldIgnoreQuota(maxNumberOfTrainingDatasets)) {
            LOGGER.log(Level.FINE, "Skip quotas enforcement for training datasets because configured quota is -1");
            return;
        }
        List<TrainingDataset> trainingDatasets = this.getTrainingDatasets(featurestore);
        LOGGER.log(Level.FINE, "Enforcing quotas for training datasets. Current number of training datasets: " + trainingDatasets.size() + " Configured quota: " + maxNumberOfTrainingDatasets);
        if (this.quotaExceed(trainingDatasets.size(), maxNumberOfTrainingDatasets)) {
            String exceptionMsg = String.format("Training datasets quota reached for Project %s. Current: %d Max: %d", featurestore.getProject().getName(), trainingDatasets.size(), maxNumberOfTrainingDatasets);
            throw new QuotaEnforcementException(exceptionMsg);
        }
    }

    private List<TrainingDataset> getTrainingDatasets(Featurestore featurestore) {
        return this.trainingDatasetFacade.findByFeaturestore(featurestore);
    }

    public void enforceRunningModelDeploymentsQuota(Project project) throws QuotaEnforcementException {
        LOGGER.log(Level.FINE, "Enforcing Running Model Deployments quota for Project " + project.getName());
        long maxNumberOfRunningDeployments = this.getMaxNumberOfRunningModelDeployments();
        if (this.shouldIgnoreQuota(maxNumberOfRunningDeployments)) {
            LOGGER.log(Level.FINE, "Skip quotas enforcement for running model deployments because configured quota is -1");
            return;
        }
        try {
            long runningDeployments = this.getAllServings(project).stream().filter(this::isDeploymentRunning).count();
            if (this.quotaExceed(runningDeployments, maxNumberOfRunningDeployments)) {
                throw new QuotaEnforcementException(String.format("Running model deployments quota reached for Project: %s. Current: %s Max: %d", project.getName(), runningDeployments, maxNumberOfRunningDeployments));
            }
        }
        catch (CryptoPasswordNotFoundException | KafkaException | ServingException ex) {
            String msg = "Failed to enforce Running Model Deployments quotas for Project " + project.getName();
            LOGGER.log(Level.SEVERE, msg, ex);
            throw new QuotaEnforcementException(msg, ex);
        }
    }

    public void enforceModelDeploymentsQuota(Project project) throws QuotaEnforcementException {
        LOGGER.log(Level.FINE, "Enforcing Model Deployments quota for Project: " + project.getName());
        long maxNumberOfModelDeployments = this.getMaxNumberOfModelDeployments();
        if (this.shouldIgnoreQuota(maxNumberOfModelDeployments)) {
            LOGGER.log(Level.FINE, "Skip quotas enforcement for model deployments because configured quota is -1");
            return;
        }
        try {
            List<ServingWrapper> deployments = this.getAllServings(project);
            if (this.quotaExceed(deployments.size(), maxNumberOfModelDeployments)) {
                throw new QuotaEnforcementException(String.format("Model deployments quota reached for Project: %s. Current: %d Max: %d", project.getName(), deployments.size(), maxNumberOfModelDeployments));
            }
        }
        catch (CryptoPasswordNotFoundException | KafkaException | ServingException ex) {
            String msg = "Failed to enforce Model Deployments quotas for Project " + project.getName();
            LOGGER.log(Level.SEVERE, msg, ex);
            throw new QuotaEnforcementException(msg, ex);
        }
    }

    public void enforceParallelExecutionsQuota(Project project) throws QuotaEnforcementException {
        LOGGER.log(Level.FINE, "Enforcing Max parallel executions quota for Project: " + project.getName());
        long maxParallelExecutions = this.getMaxParallelExecutions();
        if (this.shouldIgnoreQuota(maxParallelExecutions)) {
            LOGGER.log(Level.FINE, "Skip quotas enforcement for parallel executions because configured quota is -1");
            return;
        }
        long nonFinishedExecutions = this.getNonFinishedExecutions(project).size();
        if (this.quotaExceed(nonFinishedExecutions, maxParallelExecutions)) {
            throw new QuotaEnforcementException(String.format("Parallel executions quota reached for Project: %s Current %d Max: %d", project.getName(), nonFinishedExecutions, maxParallelExecutions));
        }
    }

    private List<Execution> getNonFinishedExecutions(Project project) {
        return this.executionFacade.findByProjectAndNotFinished(project);
    }

    private List<ServingWrapper> getAllServings(Project project) throws ServingException, KafkaException, CryptoPasswordNotFoundException {
        return this.servingController.getAll(project, null, null, null);
    }

    private boolean isDeploymentRunning(ServingWrapper serving) {
        return serving.getStatus().equals((Object)ServingStatusEnum.STARTING) || serving.getStatus().equals((Object)ServingStatusEnum.FAILED) || serving.getStatus().equals((Object)ServingStatusEnum.RUNNING) || serving.getStatus().equals((Object)ServingStatusEnum.IDLE) || serving.getStatus().equals((Object)ServingStatusEnum.UPDATING);
    }

    private void enforceFeaturegroupsQuotaInternal(Featurestore featurestore, List<Featuregroup> featuregroups, long maxFeaturegroups, boolean online) throws QuotaEnforcementException {
        String typeForException = online ? "enabled" : "disabled";
        long numFeaturegroups = featuregroups.stream().filter(fg -> {
            CachedFeaturegroup cfg = fg.getCachedFeaturegroup();
            if (cfg != null) {
                return cfg.isOnlineEnabled() == online;
            }
            StreamFeatureGroup sfg = fg.getStreamFeatureGroup();
            if (sfg != null) {
                return sfg.isOnlineEnabled() == online;
            }
            OnDemandFeaturegroup dfg = fg.getOnDemandFeaturegroup();
            return dfg == null;
        }).count();
        LOGGER.log(Level.FINE, "Enforcing quotas for online " + typeForException + " feature groups. Current number of feature groups:" + numFeaturegroups + " Configured quota: " + maxFeaturegroups);
        if (this.quotaExceed(numFeaturegroups, maxFeaturegroups)) {
            throw new QuotaEnforcementException(String.format(FEATUREGROUPS_QUOTA_EXCEEDED, typeForException, featurestore.getProject().getName(), numFeaturegroups, maxFeaturegroups));
        }
    }

    private boolean quotaExceed(long current, long max) {
        return current + 1L > max;
    }

    private boolean shouldIgnoreQuota(long quota) {
        return quota == -1L;
    }

    private long getMaxNumberOfOnlineEnabledFeaturegroups() {
        return this.settings.getQuotasOnlineEnabledFeaturegroups();
    }

    private long getMaxNumberOfOnlineDisabledFeaturegroups() {
        return this.settings.getQuotasOnlineDisabledFeaturegroups();
    }

    private long getMaxNumberOfTrainingDatasets() {
        return this.settings.getQuotasTrainingDatasets();
    }

    private long getMaxNumberOfRunningModelDeployments() {
        return this.settings.getQuotasRunningModelDeployments();
    }

    private long getMaxNumberOfModelDeployments() {
        return this.settings.getQuotasTotalModelDeployments();
    }

    private long getMaxParallelExecutions() {
        return this.settings.getQuotasMaxParallelExecutions();
    }

    @VisibleForTesting
    public void setFeaturegroupFacade(FeaturegroupFacade featuregroupFacade) {
        this.featuregroupFacade = featuregroupFacade;
    }

    @VisibleForTesting
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @VisibleForTesting
    public void setTrainingDatasetFacade(TrainingDatasetFacade trainingDatasetFacade) {
        this.trainingDatasetFacade = trainingDatasetFacade;
    }

    @VisibleForTesting
    public void setServingController(ServingController servingController) {
        this.servingController = servingController;
    }

    @VisibleForTesting
    public void setExecutionFacade(ExecutionFacade executionFacade) {
        this.executionFacade = executionFacade;
    }
}

