/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.proxies.client.HttpRetryableAction;
import io.hops.hopsworks.common.proxies.client.NotRetryableClientProtocolException;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.util.ExponentialBackOff;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NEVER)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@DependsOn(value={"Settings"})
public class PrometheusClient {
    @EJB
    private Settings settings;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    private PoolingHttpClientConnectionManager connectionManager;
    private CloseableHttpClient client;
    private ExponentialBackOff.Builder backOffPolicy;
    private String prometheusIP = "";

    @PostConstruct
    public void init() throws RuntimeException {
        block2: {
            try {
                Service prometheusService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.PROMETHEUS);
                this.prometheusIP = prometheusService.getAddress();
                this.connectionManager = this.createConnectionManager();
                this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
            }
            catch (ServiceDiscoveryException | IOException | GeneralSecurityException ex) {
                if (ex instanceof ServiceDiscoveryException) break block2;
                throw new RuntimeException(ex);
            }
        }
        this.backOffPolicy = new ExponentialBackOff.Builder().setMaximumRetries(10).setInitialIntervalMillis(500L).setMaximumIntervalMillis(3000L).setMultiplier(1.5);
    }

    @PreDestroy
    public void destroy() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }

    private PoolingHttpClientConnectionManager createConnectionManager() throws IOException, GeneralSecurityException {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(10);
        connectionManager.setDefaultMaxPerRoute(10);
        return connectionManager;
    }

    public JSONObject execute(String query) throws ServiceException {
        try {
            if (Strings.isNullOrEmpty((String)this.prometheusIP)) {
                Service prometheusService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.PROMETHEUS);
                this.prometheusIP = prometheusService.getAddress();
            }
            HttpGet httpRequest = new HttpGet(this.getUri(query));
            httpRequest.setHeader("Content-Type", "application/json");
            HttpRetryableAction<JSONObject> retryableAction = new HttpRetryableAction<JSONObject>(this.backOffPolicy, (HttpUriRequest)httpRequest){
                final /* synthetic */ HttpUriRequest val$httpRequest;
                {
                    this.val$httpRequest = httpUriRequest;
                    super(backoffBuilder);
                }

                @Override
                public JSONObject performAction() throws ClientProtocolException, IOException {
                    return (JSONObject)PrometheusClient.this.client.execute(this.val$httpRequest, httpResponse -> {
                        int statusCode = httpResponse.getStatusLine().getStatusCode();
                        if (statusCode / 100 == 2) {
                            String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                            return Strings.isNullOrEmpty((String)response) ? new JSONObject() : new JSONObject(response);
                        }
                        if (statusCode / 100 == 4) {
                            if (statusCode == 404) {
                                throw new ClientProtocolException();
                            }
                            throw new NotRetryableClientProtocolException(httpResponse.toString());
                        }
                        throw new ClientProtocolException();
                    });
                }
            };
            return (JSONObject)retryableAction.tryAction();
        }
        catch (ServiceDiscoveryException | IOException | URISyntaxException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.PROMETHEUS_QUERY_ERROR, Level.FINE, "Failed to execute prometheus query " + query, e.getMessage());
        }
    }

    private String getUri(String query) throws MalformedURLException, URISyntaxException {
        HttpHost rmHost = new HttpHost(this.prometheusIP, this.settings.getPrometheusPort().intValue(), "http");
        URL url = new URL(rmHost.toURI() + "/api/v1/query?query=" + query);
        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        return uri.toASCIIString();
    }
}

