/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.hops.hopsworks.common.featurestore.FeaturestoreController;
import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupController;
import io.hops.hopsworks.common.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.featurestore.query.Feature;
import io.hops.hopsworks.common.featurestore.query.Query;
import io.hops.hopsworks.common.featurestore.query.QueryDTO;
import io.hops.hopsworks.common.featurestore.query.filter.Filter;
import io.hops.hopsworks.common.featurestore.query.filter.FilterDTO;
import io.hops.hopsworks.common.featurestore.query.filter.FilterLogic;
import io.hops.hopsworks.common.featurestore.query.filter.FilterLogicDTO;
import io.hops.hopsworks.common.featurestore.query.join.Join;
import io.hops.hopsworks.common.featurestore.query.join.JoinDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.SqlCondition;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class QueryBuilder {
    @EJB
    private FeaturegroupController featuregroupController;
    @EJB
    private FeaturestoreController featurestoreController;

    public QueryDTO build(Query query, Featurestore featurestore, Project project, Users user) throws FeaturestoreException, ServiceException {
        if (query.getDeletedFeatureGroups() != null && !query.getDeletedFeatureGroups().isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND, Level.SEVERE, String.format("Cannot construct the query. Parent feature groups of the following features are not available anymore: %s", String.join((CharSequence)", ", query.getDeletedFeatureGroups())));
        }
        Map<FeatureSignature, FeatureGroupFeatureDTO> featureToDTO = this.makeFeatureToFeatureDTOMap(query, project, user);
        ArrayList allJoinedFeatures = Lists.newArrayList();
        for (Feature feature : query.getFeatures()) {
            allJoinedFeatures.add(this.convertToFeatureDTO(feature, featureToDTO));
        }
        return this.build(query, featurestore, project, user, featureToDTO, allJoinedFeatures);
    }

    private QueryDTO build(Query query, Featurestore featurestore, Project project, Users user, Map<FeatureSignature, FeatureGroupFeatureDTO> featureToDTO, List<FeatureGroupFeatureDTO> allJoinedFeatures) throws FeaturestoreException, ServiceException {
        QueryDTO queryDTO = new QueryDTO();
        String featureStoreName = query.getFeatureStore();
        try {
            Integer featureStoreId = this.featurestoreController.getFeaturestoreForProjectWithName(project, featureStoreName).getFeaturestoreId();
            queryDTO.setFeatureStoreId(featureStoreId);
        }
        catch (FeaturestoreException e) {
            if (RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND.equals((Object)e.getErrorCode())) {
                queryDTO.setFeatureStoreId(null);
            }
            throw e;
        }
        FeaturegroupDTO leftFeatureGroup = this.featuregroupController.convertFeaturegrouptoDTO(query.getFeaturegroup(), project, user);
        leftFeatureGroup.setFeatures(this.featuregroupController.getFeatures(query.getFeaturegroup(), project, user));
        Long leftFeatureGroupStartTime = query.getLeftFeatureGroupStartTimestamp();
        Long leftFeatureGroupEndTime = query.getLeftFeatureGroupEndTimestamp();
        FilterLogicDTO filter = this.convertToFilterLogicDTO(query.getFilter(), featureToDTO);
        Boolean hiveEngine = query.getHiveEngine();
        List<JoinDTO> joins = this.convertToJoinDTOs(query.getJoins(), featurestore, project, user, featureToDTO, allJoinedFeatures);
        queryDTO.setFeatureStoreName(featureStoreName);
        queryDTO.setLeftFeatureGroup(leftFeatureGroup);
        queryDTO.setLeftFeatures(allJoinedFeatures.stream().filter(feature -> feature.getFeatureGroupId().equals(query.getFeaturegroup().getId())).collect(Collectors.toList()));
        queryDTO.setLeftFeatureGroupStartTime(leftFeatureGroupStartTime);
        queryDTO.setLeftFeatureGroupEndTime(leftFeatureGroupEndTime);
        queryDTO.setFilter(filter);
        queryDTO.setHiveEngine(hiveEngine);
        queryDTO.setJoins(joins);
        return queryDTO;
    }

    Map<FeatureSignature, FeatureGroupFeatureDTO> makeFeatureToFeatureDTOMap(Query query, Project project, Users user) throws FeaturestoreException {
        HashMap featureToDTO = Maps.newHashMap();
        Map<Integer, Featuregroup> featuregroups = query.getJoins().stream().map(join -> join.getRightQuery().getFeaturegroup()).collect(Collectors.toMap(Featuregroup::getId, fg -> fg, (f1, f2) -> f1));
        featuregroups.put(query.getFeaturegroup().getId(), query.getFeaturegroup());
        for (Featuregroup featuregroup : featuregroups.values()) {
            this.featuregroupController.getFeatures(featuregroup, project, user).forEach(featureDto -> featureToDTO.put(new FeatureSignature((FeatureGroupFeatureDTO)featureDto, featuregroup.getVersion()), featureDto));
        }
        return featureToDTO;
    }

    FilterLogicDTO convertToFilterLogicDTO(FilterLogic filterLogic, Map<FeatureSignature, FeatureGroupFeatureDTO> featureToDTO) throws FeaturestoreException {
        if (filterLogic == null) {
            return null;
        }
        FilterLogicDTO filterLogicDTO = new FilterLogicDTO(filterLogic.getType());
        filterLogicDTO.setLeftFilter(this.convertToFilterDTO(filterLogic.getLeftFilter(), featureToDTO));
        filterLogicDTO.setRightFilter(this.convertToFilterDTO(filterLogic.getRightFilter(), featureToDTO));
        filterLogicDTO.setLeftLogic(this.convertToFilterLogicDTO(filterLogic.getLeftLogic(), featureToDTO));
        filterLogicDTO.setRightLogic(this.convertToFilterLogicDTO(filterLogic.getRightLogic(), featureToDTO));
        return filterLogicDTO;
    }

    FilterDTO convertToFilterDTO(Filter filter, Map<FeatureSignature, FeatureGroupFeatureDTO> featureToDTO) throws FeaturestoreException {
        if (filter == null) {
            return null;
        }
        FeatureGroupFeatureDTO feature = this.convertToFeatureDTO(filter.getFeatures().get(0), featureToDTO);
        SqlCondition condition = filter.getCondition();
        String value = filter.getValue().getValue();
        return new FilterDTO(feature, condition, value);
    }

    FeatureGroupFeatureDTO convertToFeatureDTO(Feature feature, Map<FeatureSignature, FeatureGroupFeatureDTO> featureToDTO) throws FeaturestoreException {
        FeatureGroupFeatureDTO featureDTO = featureToDTO.get(new FeatureSignature(feature));
        if (featureDTO == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURE_NOT_FOUND, Level.SEVERE, feature.getName() + " is not found");
        }
        return featureDTO;
    }

    List<JoinDTO> convertToJoinDTOs(List<Join> joins, Featurestore featurestore, Project project, Users user, Map<FeatureSignature, FeatureGroupFeatureDTO> featureToDTO, List<FeatureGroupFeatureDTO> allJoinedFeatures) throws FeaturestoreException, ServiceException {
        if (joins == null || joins.isEmpty()) {
            return null;
        }
        ArrayList joinDTOS = Lists.newArrayList();
        for (Join join : joins) {
            joinDTOS.add(this.convertToJoinDTO(join, featurestore, project, user, featureToDTO, allJoinedFeatures));
        }
        return joinDTOS;
    }

    JoinDTO convertToJoinDTO(Join join, Featurestore featurestore, Project project, Users user, Map<FeatureSignature, FeatureGroupFeatureDTO> featureToDTO, List<FeatureGroupFeatureDTO> allJoinedFeatures) throws FeaturestoreException, ServiceException {
        JoinDTO joinDTO = new JoinDTO();
        QueryDTO queryDTO = this.build(join.getRightQuery(), featurestore, project, user, featureToDTO, allJoinedFeatures);
        List<FeatureGroupFeatureDTO> rightOn = join.getRightOn().stream().map(feature -> {
            FeatureGroupFeatureDTO featureDTO = new FeatureGroupFeatureDTO();
            featureDTO.setName(feature.getName());
            return featureDTO;
        }).collect(Collectors.toList());
        List<FeatureGroupFeatureDTO> leftOn = join.getLeftOn().stream().map(feature -> {
            FeatureGroupFeatureDTO featureDTO = new FeatureGroupFeatureDTO();
            featureDTO.setName(feature.getName());
            return featureDTO;
        }).collect(Collectors.toList());
        joinDTO.setQuery(queryDTO);
        joinDTO.setRightOn(rightOn);
        joinDTO.setLeftOn(leftOn);
        joinDTO.setType(join.getJoinType());
        joinDTO.setPrefix(join.getPrefix());
        return joinDTO;
    }

    private static class FeatureSignature {
        public String featureName;
        public Integer featureGroupId;
        public Integer featureGroupVersion;

        public FeatureSignature(Feature feature) {
            this.featureName = feature.getName();
            this.featureGroupId = feature.getFeatureGroup().getId();
            this.featureGroupVersion = feature.getFeatureGroup().getVersion();
        }

        public FeatureSignature(FeatureGroupFeatureDTO feature, Integer version) {
            this.featureName = feature.getName();
            this.featureGroupId = feature.getFeatureGroupId();
            this.featureGroupVersion = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureSignature that = (FeatureSignature)o;
            return this.featureName.equals(that.featureName) && this.featureGroupId.equals(that.featureGroupId) && this.featureGroupVersion.equals(that.featureGroupVersion);
        }

        public int hashCode() {
            return Objects.hash(this.featureName, this.featureGroupId, this.featureGroupVersion);
        }
    }
}

