/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.datavalidationv2.reports;

import io.hops.hopsworks.alerting.api.alert.dto.PostableAlert;
import io.hops.hopsworks.common.alert.AlertController;
import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.featurestore.activity.FeaturestoreActivityFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.expectations.ExpectationFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.reports.ValidationReportDTO;
import io.hops.hopsworks.common.featurestore.datavalidationv2.reports.ValidationReportFacade;
import io.hops.hopsworks.common.featurestore.datavalidationv2.results.ValidationResultController;
import io.hops.hopsworks.common.featurestore.datavalidationv2.results.ValidationResultDTO;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.DatasetException;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetAccessPermission;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.alert.FeatureGroupAlert;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.alert.ValidationRuleAlertStatus;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.IngestionResult;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ValidationReport;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidationv2.ValidationResult;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlert;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlertStatus;
import io.hops.hopsworks.persistence.entity.project.service.ProjectServiceEnum;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.hadoop.fs.Path;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ValidationReportController {
    private static final Logger LOGGER = Logger.getLogger(ValidationReportController.class.getName());
    @EJB
    private ValidationReportFacade validationReportFacade;
    @EJB
    private ExpectationFacade expectationFacade;
    @EJB
    private InodeController inodeController;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private DatasetController datasetController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private AlertController alertController;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeaturestoreActivityFacade fsActivityFacade;
    @EJB
    private ValidationResultController validationResultController;

    public ValidationReport getValidationReportById(Integer validationReportId) throws FeaturestoreException {
        Optional<ValidationReport> validationReport = this.validationReportFacade.findById(validationReportId);
        if (!validationReport.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.VALIDATION_REPORT_NOT_FOUND, Level.FINE, String.format("No Validation report was found with id : %d.", validationReportId));
        }
        return validationReport.get();
    }

    public AbstractFacade.CollectionInfo<ValidationReport> getAllValidationReportByFeatureGroup(Integer offset, Integer limit, Set<? extends AbstractFacade.SortBy> sorts, Set<? extends AbstractFacade.FilterBy> filters, Featuregroup featuregroup) {
        return this.validationReportFacade.findByFeaturegroup(offset, limit, sorts, filters, featuregroup);
    }

    public ValidationReport createValidationReport(Users user, Featuregroup featuregroup, ValidationReportDTO reportDTO) throws FeaturestoreException {
        ValidationReport validationReport = this.convertReportDTOToPersistent(user, featuregroup, reportDTO);
        this.validationReportFacade.persist(validationReport);
        this.fsActivityFacade.logValidationReportActivity(user, validationReport);
        this.triggerAlerts(featuregroup, validationReport);
        return validationReport;
    }

    private void triggerAlerts(Featuregroup featureGroup, ValidationReport validationReport) {
        List<PostableAlert> postableAlerts = this.getPostableAlerts(featureGroup, validationReport);
        this.alertController.sendFgAlert(postableAlerts, featureGroup.getFeaturestore().getProject(), featureGroup.getName());
    }

    private List<PostableAlert> getPostableAlerts(Featuregroup featureGroup, ValidationReport validationReport) {
        String name;
        ArrayList<PostableAlert> postableAlerts = new ArrayList<PostableAlert>();
        if (featureGroup.getFeatureGroupAlerts() != null && !featureGroup.getFeatureGroupAlerts().isEmpty()) {
            name = this.featurestoreFacade.getHiveDbName(featureGroup.getFeaturestore().getHiveDbId());
            for (FeatureGroupAlert alert : featureGroup.getFeatureGroupAlerts()) {
                if (alert.getStatus() == ValidationRuleAlertStatus.FAILURE && validationReport.getIngestionResult() == IngestionResult.REJECTED) {
                    postableAlerts.add(this.getPostableAlert(alert, name, featureGroup, validationReport));
                    continue;
                }
                if (alert.getStatus() != ValidationRuleAlertStatus.SUCCESS || validationReport.getIngestionResult() != IngestionResult.INGESTED) continue;
                postableAlerts.add(this.getPostableAlert(alert, name, featureGroup, validationReport));
            }
        }
        if (featureGroup.getFeaturestore().getProject().getProjectServiceAlerts() != null && !featureGroup.getFeaturestore().getProject().getProjectServiceAlerts().isEmpty()) {
            name = this.featurestoreFacade.getHiveDbName(featureGroup.getFeaturestore().getHiveDbId());
            for (FeatureGroupAlert alert : featureGroup.getFeaturestore().getProject().getProjectServiceAlerts()) {
                if (ProjectServiceEnum.FEATURESTORE.equals((Object)alert.getService()) && alert.getStatus() == ProjectServiceAlertStatus.VALIDATION_FAILURE && validationReport.getIngestionResult() == IngestionResult.REJECTED) {
                    postableAlerts.add(this.getPostableAlert((ProjectServiceAlert)alert, name, featureGroup, validationReport));
                    continue;
                }
                if (!ProjectServiceEnum.FEATURESTORE.equals((Object)alert.getService()) || alert.getStatus() != ProjectServiceAlertStatus.VALIDATION_SUCCESS || validationReport.getIngestionResult() != IngestionResult.INGESTED) continue;
                postableAlerts.add(this.getPostableAlert((ProjectServiceAlert)alert, name, featureGroup, validationReport));
            }
        }
        return postableAlerts;
    }

    private PostableAlert getPostableAlert(FeatureGroupAlert alert, String featureStoreName, Featuregroup featureGroup, ValidationReport validationReport) {
        return this.alertController.getPostableFgAlert(featureGroup.getFeaturestore().getProject().getName(), alert.getAlertType(), alert.getSeverity(), validationReport.getIngestionResult().toString(), this.constructAlertSummary(featureGroup, validationReport), this.constructAlertDescription(validationReport), featureGroup.getId(), featureStoreName, featureGroup.getName(), featureGroup.getVersion());
    }

    private PostableAlert getPostableAlert(ProjectServiceAlert alert, String featureStoreName, Featuregroup featureGroup, ValidationReport validationReport) {
        return this.alertController.getPostableFgAlert(featureGroup.getFeaturestore().getProject().getName(), alert.getAlertType(), alert.getSeverity(), validationReport.getIngestionResult().toString(), this.constructAlertSummary(featureGroup, validationReport), this.constructAlertDescription(validationReport), featureGroup.getId(), featureStoreName, featureGroup.getName(), featureGroup.getVersion());
    }

    public String constructAlertSummary(Featuregroup featureGroup, ValidationReport validationReport) {
        return String.format("Feature Group: %s, version: %s, expectation suite: %s, success: %s", featureGroup.getName(), featureGroup.getVersion(), featureGroup.getExpectationSuite().getName(), validationReport.getSuccess(), validationReport.getStatistics());
    }

    public String constructAlertDescription(ValidationReport validationReport) {
        return String.format("Statistics: %s", validationReport.getStatistics());
    }

    public void deleteValidationReportById(Users user, Integer validationReportId) throws FeaturestoreException {
        Optional<ValidationReport> validationReport = this.validationReportFacade.findById(validationReportId);
        if (!validationReport.isPresent()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.VALIDATION_REPORT_NOT_FOUND, Level.WARNING, String.format("ValidationReport with id : %d was not found causing delete to fail", validationReportId));
        }
        this.deleteSingleReportInode(user, validationReport.get());
    }

    private void deleteSingleReportInode(Users user, ValidationReport validationReport) throws FeaturestoreException {
        Featuregroup featuregroup = validationReport.getFeaturegroup();
        Project project = featuregroup.getFeaturestore().getProject();
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            udfso.rm(this.inodeController.getPath(validationReport.getInode()), false);
            this.dfs.closeDfsClient(udfso);
        }
        catch (IOException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_ON_DISK_VALIDATION_REPORT, Level.WARNING, "", e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(udfso);
                throw throwable;
            }
        }
    }

    public void deleteFeaturegroupDataValidationDir(Users user, Featuregroup featuregroup) throws FeaturestoreException {
        Project project = featuregroup.getFeaturestore().getProject();
        DistributedFileSystemOps udfso = null;
        try {
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            Dataset dataValidationDir = this.getOrCreateDataValidationDataset(project, user);
            Path targetDir = new Path(this.datasetController.getDatasetPath(dataValidationDir), featuregroup.getName());
            udfso.rm(targetDir, true);
            this.dfs.closeDfsClient(udfso);
        }
        catch (DatasetException | HopsSecurityException | IOException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_ON_DISK_VALIDATION_REPORT, Level.WARNING, "", e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(udfso);
                throw throwable;
            }
        }
    }

    public ValidationReport convertReportDTOToPersistent(Users user, Featuregroup featuregroup, ValidationReportDTO reportDTO) throws FeaturestoreException {
        Date validationTime;
        this.verifyValidationReportDTOFields(reportDTO);
        ValidationReport report = new ValidationReport();
        report.setFeaturegroup(featuregroup);
        report.setMeta(reportDTO.getMeta());
        report.setSuccess(reportDTO.getSuccess());
        report.setStatistics(reportDTO.getStatistics());
        report.setEvaluationParameters(reportDTO.getEvaluationParameters());
        report.setIngestionResult(reportDTO.getIngestionResult());
        try {
            JSONObject reportMeta = new JSONObject(reportDTO.getMeta());
            String validationTimeString = reportMeta.getString("validation_time");
            String formatDateString = "yyyyMMdd'T'HHmmss.SSS";
            validationTime = new SimpleDateFormat(formatDateString).parse(validationTimeString.substring(0, validationTimeString.length() - 4));
        }
        catch (ParseException | JSONException exception) {
            validationTime = new Date();
        }
        report.setValidationTime(validationTime);
        Inode reportInode = this.registerValidationReportToDisk(user, featuregroup, reportDTO, validationTime);
        report.setInode(reportInode);
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (ValidationResultDTO dto : reportDTO.getResults()) {
            results.add(this.validationResultController.convertResultDTOToPersistent(report, dto));
        }
        report.setValidationResults(results);
        return report;
    }

    private Inode registerValidationReportToDisk(Users user, Featuregroup featuregroup, ValidationReportDTO reportDTO, Date validationTime) throws FeaturestoreException {
        DistributedFileSystemOps udfso = null;
        Project project = featuregroup.getFeaturestore().getProject();
        JSONObject reportJSON = this.convertValidationReportDTOToJson(reportDTO);
        try {
            Inode inode;
            udfso = this.dfs.getDfsOps(this.hdfsUsersController.getHdfsUserName(project, user));
            Dataset dataValidationDir = this.getOrCreateDataValidationDataset(project, user);
            Path reportDirPath = new Path(this.datasetController.getDatasetPath(dataValidationDir), featuregroup.getName());
            if (!udfso.isDir(reportDirPath.toString())) {
                udfso.mkdir(reportDirPath.toString());
            }
            if (!udfso.isDir((reportDirPath = new Path(reportDirPath, featuregroup.getVersion().toString())).toString())) {
                udfso.mkdir(reportDirPath.toString());
            }
            if (!udfso.isDir((reportDirPath = new Path(reportDirPath, "ValidationReports")).toString())) {
                udfso.mkdir(reportDirPath.toString());
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HHmmss");
            String fileName = String.format("validation_report_%s.json", formatter.format(validationTime));
            Path reportPath = new Path(reportDirPath, fileName);
            if (udfso.exists(reportPath)) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_SAVING_ON_DISK_VALIDATION_REPORT, Level.SEVERE, String.format("Validation report with file name %s already exists.", fileName));
            }
            udfso.create(reportPath, reportJSON.toString());
            Inode inode2 = inode = this.inodeController.getInodeAtPath(reportPath.toString());
            this.dfs.closeDfsClient(udfso);
            return inode2;
        }
        catch (DatasetException | HopsSecurityException | IOException e) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_SAVING_ON_DISK_VALIDATION_REPORT, Level.WARNING, e.getMessage());
            }
            catch (Throwable throwable) {
                this.dfs.closeDfsClient(udfso);
                throw throwable;
            }
        }
    }

    private Dataset getOrCreateDataValidationDataset(Project project, Users user) throws DatasetException, HopsSecurityException {
        Optional<Dataset> dataValidationDataset = project.getDatasetCollection().stream().filter(d -> d.getName().equals(Settings.ServiceDataset.DATAVALIDATION.getName())).findFirst();
        if (dataValidationDataset.isPresent()) {
            return dataValidationDataset.get();
        }
        return this.createDataValidationDataset(project, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset createDataValidationDataset(Project project, Users user) throws DatasetException, HopsSecurityException {
        DistributedFileSystemOps dfso = null;
        try {
            dfso = this.dfs.getDfsOps();
            Dataset dataset = this.datasetController.createDataset(user, project, Settings.ServiceDataset.DATAVALIDATION.getName(), Settings.ServiceDataset.DATAVALIDATION.getDescription(), Provenance.Type.DISABLED.dto, false, DatasetAccessPermission.EDITABLE, dfso);
            return dataset;
        }
        finally {
            this.dfs.closeDfsClient(dfso);
        }
    }

    private JSONObject convertValidationReportDTOToJson(ValidationReportDTO reportDTO) throws FeaturestoreException {
        JSONObject reportJSON = new JSONObject();
        try {
            if (reportDTO.getFullJson() != null) {
                reportJSON = new JSONObject(reportDTO.getFullJson());
            } else {
                reportJSON.put("evaluation_parameters", (Object)new JSONObject(reportDTO.getEvaluationParameters()));
                reportJSON.put("statistics", (Object)new JSONObject(reportDTO.getStatistics()));
                reportJSON.put("success", (Object)reportDTO.getSuccess());
                reportJSON.put("meta", (Object)new JSONObject(reportDTO.getMeta()));
                JSONArray resultsJsonArray = new JSONArray();
                for (ValidationResultDTO resultDTO : reportDTO.getResults()) {
                    resultsJsonArray.put((Object)this.validationResultController.convertValidationResultDTOToJson(resultDTO));
                }
                reportJSON.put("results", (Object)resultsJsonArray);
            }
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.VALIDATION_REPORT_IS_NOT_VALID_JSON, Level.WARNING, e.getMessage());
        }
        return reportJSON;
    }

    public void verifyValidationReportDTOFields(ValidationReportDTO dto) throws FeaturestoreException {
        this.verifyValidationReportEvaluationParameters(dto.getEvaluationParameters());
        this.verifyValidationReportMeta(dto.getMeta());
        this.verifyValidationReportStatistics(dto.getStatistics());
    }

    public void verifyValidationReportStatistics(String statistics) throws FeaturestoreException {
        if (statistics == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Validation report statistics field cannot be null. Pass an empty stringified JSON.");
        }
        if (statistics.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Validation report statistics field %s exceeds the max allowed character length %d.", statistics, 1000));
        }
        try {
            new JSONObject(statistics);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Validation report statistics field %s is not a valid json.", statistics), e.getMessage());
        }
    }

    public void verifyValidationReportEvaluationParameters(String evaluationParameters) throws FeaturestoreException {
        if (evaluationParameters == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Validation report evaluation_parameters field cannot be null. Pass an empty stringified JSON.");
        }
        if (evaluationParameters.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Validation report evaluation_parameters field %s exceeds the max allowed character length %d.", evaluationParameters, 1000));
        }
        try {
            new JSONObject(evaluationParameters);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Validation report evaluation_parameters field %s is not a valid json.", evaluationParameters), e.getMessage());
        }
    }

    public void verifyValidationReportMeta(String meta) throws FeaturestoreException {
        if (meta == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_NULLABLE, Level.SEVERE, "Validation report meta field cannot be null. Pass an empty stringified JSON.");
        }
        if (meta.length() > 2000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_EXCEEDS_MAX_ALLOWED_CHARACTER, Level.SEVERE, String.format("Validation report meta field %s exceeds the max allowed character length %d.", meta, 2000));
        }
        try {
            new JSONObject(meta);
        }
        catch (JSONException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.INPUT_FIELD_IS_NOT_VALID_JSON, Level.SEVERE, String.format("Validation report meta field %s is not a valid json.", meta), e.getMessage());
        }
    }
}

