/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import com.google.common.collect.ImmutableSet;
import io.hops.hopsworks.common.jupyter.JupyterJWT;
import io.hops.hopsworks.common.util.Settings;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public interface JupyterJWTTokenWriter {
    public static final Set<PosixFilePermission> TOKEN_FILE_PERMISSIONS = ImmutableSet.of((Object)((Object)PosixFilePermission.OWNER_READ), (Object)((Object)PosixFilePermission.OWNER_WRITE), (Object)((Object)PosixFilePermission.OWNER_EXECUTE), (Object)((Object)PosixFilePermission.GROUP_READ), (Object)((Object)PosixFilePermission.GROUP_WRITE), (Object)((Object)PosixFilePermission.GROUP_EXECUTE), (Object[])new PosixFilePermission[0]);

    default public void writeToken(Settings settings, JupyterJWT jupyterJWT) throws IOException {
        FileUtils.writeStringToFile((File)jupyterJWT.tokenFile.toFile(), (String)jupyterJWT.token);
        String groupName = settings.getJupyterGroup();
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        GroupPrincipal group = lookupService.lookupPrincipalByGroupName(groupName);
        Files.getFileAttributeView(jupyterJWT.tokenFile, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(group);
        Files.setPosixFilePermissions(jupyterJWT.tokenFile, TOKEN_FILE_PERMISSIONS);
    }

    default public void deleteToken(JupyterJWT jupyterJWT) {
        FileUtils.deleteQuietly((File)jupyterJWT.tokenFile.toFile());
    }
}

