/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.explicit;

import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.provenance.ProvExplicitNode;

public class ProvArtifact {
    private String id;
    private String project;
    private String name;
    private Integer version;

    public ProvArtifact() {
    }

    public ProvArtifact(String artifactId, String projectName, String artifactName, Integer artifactVersion) {
        this.project = projectName;
        this.name = artifactName;
        this.version = artifactVersion;
        this.id = artifactId;
    }

    public static ProvArtifact fromLinkAsParent(ProvExplicitNode link) {
        return new ProvArtifact(String.valueOf(link.parentId()), link.parentProject(), link.parentName(), link.parentVersion());
    }

    public static ProvArtifact fromFeatureGroup(Featuregroup fg) {
        return new ProvArtifact(String.valueOf(fg.getId()), fg.getFeaturestore().getProject().getName(), fg.getName(), fg.getVersion());
    }

    public static ProvArtifact fromFeatureView(FeatureView fv) {
        return new ProvArtifact(String.valueOf(fv.getId()), fv.getFeaturestore().getProject().getName(), fv.getName(), fv.getVersion());
    }

    public static ProvArtifact fromTrainingDataset(TrainingDataset td) {
        return new ProvArtifact(String.valueOf(td.getId()), td.getFeaturestore().getProject().getName(), td.getName(), td.getVersion());
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

