/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.host;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.host.Hosts;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class HostsFacade
extends AbstractFacade<Hosts> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public HostsFacade() {
        super(Hosts.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public void save(Hosts entity) {
        super.save(entity);
        this.getEntityManager().flush();
    }

    public AbstractFacade.CollectionInfo findHosts(Integer offset, Integer limit, Set<? extends AbstractFacade.FilterBy> filters, Set<? extends AbstractFacade.SortBy> sorts) {
        String queryStr = this.buildQuery("SELECT h FROM Hosts h ", filters, sorts, "");
        String queryCountStr = this.buildQuery("SELECT COUNT(DISTINCT(h.id)) FROM Hosts h ", filters, sorts, "");
        TypedQuery query = this.em.createQuery(queryStr, Hosts.class);
        TypedQuery queryCount = this.em.createQuery(queryCountStr, Hosts.class);
        this.setFilter(filters, (Query)query);
        this.setFilter(filters, (Query)queryCount);
        this.setOffsetAndLim(offset, limit, (Query)query);
        return new AbstractFacade.CollectionInfo((Long)queryCount.getSingleResult(), query.getResultList());
    }

    private void setFilter(Set<? extends AbstractFacade.FilterBy> filter, Query q) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        for (AbstractFacade.FilterBy filterBy : filter) {
            this.setFilterQuery(filterBy, q);
        }
    }

    private void setFilterQuery(AbstractFacade.FilterBy filterBy, Query q) {
        switch (Filters.valueOf(filterBy.getValue())) {
            case HOSTNAME: 
            case HOST_IP: 
            case PUBLIC_IP: 
            case PRIVATE_IP: {
                q.setParameter(filterBy.getField(), (Object)filterBy.getParam());
                break;
            }
            case REGISTERED: {
                q.setParameter(filterBy.getField(), (Object)Boolean.valueOf(filterBy.getParam()));
                break;
            }
        }
    }

    public Optional<Hosts> findByHostIp(String hostIp) {
        try {
            return Optional.of(this.em.createNamedQuery("Hosts.findByHostIp", Hosts.class).setParameter("hostIp", (Object)hostIp).getSingleResult());
        }
        catch (NoResultException ex) {
            return Optional.empty();
        }
    }

    public Optional<Hosts> findByHostname(String hostname) {
        try {
            return Optional.of(this.em.createNamedQuery("Hosts.findByHostname", Hosts.class).setParameter("hostname", (Object)hostname).getSingleResult());
        }
        catch (NoResultException ex) {
            return Optional.empty();
        }
    }

    public Long countHosts() {
        TypedQuery query = this.em.createNamedQuery("Host.Count", Long.class);
        return (Long)query.getSingleResult();
    }

    public Long totalCores() {
        TypedQuery query = this.em.createNamedQuery("Host.TotalCores", Long.class);
        return (Long)query.getSingleResult();
    }

    public Long totalGPUs() {
        TypedQuery query = this.em.createNamedQuery("Host.TotalGPUs", Long.class);
        return (Long)query.getSingleResult();
    }

    public Long totalMemoryCapacity() {
        TypedQuery query = this.em.createNamedQuery("Host.TotalMemoryCapacity", Long.class);
        return (Long)query.getSingleResult();
    }

    public long countUnregistered() {
        TypedQuery query = this.em.createNamedQuery("Host.CountUnregistered", Long.class);
        return (Long)query.getSingleResult();
    }

    public static enum Filters {
        HOSTNAME("HOSTNAME", " h.hostname = :hostname", "hostname", ""),
        HOST_IP("HOST_IP", " h.hostIp = :hostIp", "hostIp", ""),
        PUBLIC_IP("PUBLIC_IP", " h.publicIp = :publicIp", "publicIp", ""),
        PRIVATE_IP("PRIVATE_IP", " h.privateIp = :privateIp", "privateIp", ""),
        REGISTERED("REGISTERED", " h.registered = :registered", "registered", "false");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private Filters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Sorts {
        ID("ID", " h.id ", "ASC"),
        HOSTNAME("HOSTNAME", " LOWER(h.hostname) ", "ASC"),
        HOST_IP("HOST_IP", " LOWER(h.hostIp) ", "ASC"),
        PUBLIC_IP("PUBLIC_IP", " LOWER(h.publicIp) ", "ASC"),
        PRIVATE_IP("PRIVATE_IP", " LOWER(h.privateIp) ", "ASC"),
        CORES("CORES", " h.cores ", "ASC"),
        NUM_GPUS("NUM_GPUS", " h.numGpus ", "ASC"),
        MEMORY_CAPACITY("MEMORY_CAPACITY", " h.memoryCapacity ", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private Sorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

