/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.git;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.config.GitCommandConfiguration;
import io.hops.hopsworks.persistence.entity.git.config.GitOpExecutionState;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class GitOpExecutionFacade
extends AbstractFacade<GitOpExecutionFacade> {
    private static final Logger LOGGER = Logger.getLogger(GitOpExecutionFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public GitOpExecutionFacade() {
        super(GitOpExecutionFacade.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<GitOpExecution> findByIdAndRepository(GitRepository repository, Integer executionId) {
        try {
            TypedQuery query = this.em.createNamedQuery("GitOpExecution.findByIdAndRepository", GitOpExecution.class);
            query.setParameter("repository", (Object)repository);
            query.setParameter("id", (Object)executionId);
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<GitOpExecution> findRunningInRepository(GitRepository repository) {
        try {
            TypedQuery query = this.em.createNamedQuery("GitOpExecution.findRunningInRepository", GitOpExecution.class);
            query.setParameter("repository", (Object)repository);
            query.setParameter("finalStates", (Object)GitOpExecutionState.getFinalStates());
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public AbstractFacade.CollectionInfo<GitOpExecution> getAllForRepository(GitRepository repository, Integer limit, Integer offset) {
        TypedQuery query = this.em.createNamedQuery("GitOpExecution.findAllInRepository", GitOpExecution.class);
        query.setParameter("repository", (Object)repository);
        this.setOffsetAndLim(offset, limit, (Query)query);
        TypedQuery countQuery = this.em.createQuery("SELECT COUNT(e.id) FROM GitOpExecution e WHERE e.repository = :repository", GitOpExecution.class);
        countQuery.setParameter("repository", (Object)repository);
        return new AbstractFacade.CollectionInfo<GitOpExecution>((Long)countQuery.getSingleResult(), query.getResultList());
    }

    public GitOpExecution create(GitCommandConfiguration gitCommandConfiguration, Users user, GitRepository repository, String secret) {
        GitOpExecution gitOpExecution = new GitOpExecution(gitCommandConfiguration, new Date(), user, repository, GitOpExecutionState.INITIALIZING, secret);
        gitOpExecution.setExecutionStart(System.currentTimeMillis());
        this.em.persist((Object)gitOpExecution);
        this.em.flush();
        return gitOpExecution;
    }

    public GitOpExecution updateState(GitOpExecution exec, GitOpExecutionState newState, String message) {
        exec = (GitOpExecution)this.em.find(GitOpExecution.class, (Object)exec.getId());
        exec.setState(newState);
        exec.setCommandResultMessage(message);
        if (newState.isFinalState()) {
            exec.setExecutionStop(System.currentTimeMillis());
        }
        this.em.merge((Object)exec);
        return exec;
    }
}

