/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.kafka.ProjectTopics;
import io.hops.hopsworks.persistence.entity.kafka.schemas.Subjects;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class ProjectTopicsFacade
extends AbstractFacade<ProjectTopics> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;
    private static final Logger LOGGER = Logger.getLogger(ProjectTopicsFacade.class.getName());

    public ProjectTopicsFacade() {
        super(ProjectTopics.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public List<ProjectTopics> findTopicsByProject(Project project) {
        return this.em.createNamedQuery("ProjectTopics.findByProject", ProjectTopics.class).setParameter("project", (Object)project).getResultList();
    }

    public int countTopicsByProject(Project project) {
        return ((Long)this.em.createNamedQuery("ProjectTopics.countByProject", Long.class).setParameter("project", (Object)project).getSingleResult()).intValue();
    }

    public Optional<ProjectTopics> findTopicByNameAndProject(Project project, String topicName) {
        try {
            return Optional.of(this.em.createNamedQuery("ProjectTopics.findByProjectAndTopicName", ProjectTopics.class).setParameter("project", (Object)project).setParameter("topicName", (Object)topicName).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<ProjectTopics> findTopicByName(String topicName) {
        try {
            return Optional.of(this.em.createNamedQuery("ProjectTopics.findByTopicName", ProjectTopics.class).setParameter("topicName", (Object)topicName).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<ProjectTopics> findTopiscBySubjectAndVersion(Project project, String subject, Integer version) {
        return this.em.createNamedQuery("ProjectTopics.findBySubjectAndVersion", ProjectTopics.class).setParameter("project", (Object)project).setParameter("subject", (Object)subject).setParameter("version", (Object)version).getResultList();
    }

    public List<ProjectTopics> findTopicsBySubject(Project project, String subject) {
        return this.em.createNamedQuery("ProjectTopics.findBySubject", ProjectTopics.class).setParameter("project", (Object)project).setParameter("subject", (Object)subject).getResultList();
    }

    public void updateTopicSchemaVersion(ProjectTopics pt, Subjects st) {
        pt.setSubjects(st);
        this.update(pt);
    }

    public static enum TopicsFilters {
        SHARED("SHARED", "t.isShared = :shared", "shared", "false");

        private final String value;
        private final String sql;
        private final String field;
        private final String defaultParam;

        private TopicsFilters(String value, String sql, String field, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.field = field;
            this.defaultParam = defaultParam;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getField() {
            return this.field;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum TopicsSorts {
        NAME("NAME", "LOWER(t.name)", "ASC"),
        SCHEMA_NAME("SCHEMA_NAME", "LOWER(t.schemaName)", "ASC");

        private final String value;
        private final String sql;
        private final String defaultParam;

        private TopicsSorts(String value, String sql, String defaultParam) {
            this.value = value;
            this.sql = sql;
            this.defaultParam = defaultParam;
        }

        public String getValue() {
            return this.value;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDefaultParam() {
            return this.defaultParam;
        }

        public String getJoin() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }
}

