/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.ops.dto;

import io.hops.hopsworks.common.api.RestDTO;
import io.hops.hopsworks.common.provenance.ops.dto.ProvOpsDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ProvLinksDTO
extends RestDTO<ProvLinksDTO> {
    String appId;
    Map<String, ProvOpsDTO> in = new HashMap<String, ProvOpsDTO>();
    Map<String, ProvOpsDTO> out = new HashMap<String, ProvOpsDTO>();
    ProvOpsDTO root = null;
    List<ProvLinksDTO> upstreamLinks = new ArrayList<ProvLinksDTO>();
    List<ProvLinksDTO> downstreamLinks = new ArrayList<ProvLinksDTO>();
    boolean maxProvenanceGraphSizeReached = false;

    public ProvLinksDTO() {
    }

    public ProvLinksDTO(String appId, Map<String, ProvOpsDTO> in, Map<String, ProvOpsDTO> out) {
        this.in = in;
        this.out = out;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Map<String, ProvOpsDTO> getIn() {
        return this.in;
    }

    public void setIn(Map<String, ProvOpsDTO> in) {
        this.in = in;
    }

    public Map<String, ProvOpsDTO> getOut() {
        return this.out;
    }

    public void setOut(Map<String, ProvOpsDTO> out) {
        this.out = out;
    }

    public ProvOpsDTO getRoot() {
        return this.root;
    }

    public void setRoot(ProvOpsDTO root) {
        this.root = root;
    }

    public List<ProvLinksDTO> getUpstreamLinks() {
        return this.upstreamLinks;
    }

    public void setUpstreamLinks(List<ProvLinksDTO> upstreamLinks) {
        this.upstreamLinks = upstreamLinks;
    }

    public void addUpstreamLink(ProvLinksDTO link) {
        this.upstreamLinks.add(link);
    }

    public List<ProvLinksDTO> getDownstreamLinks() {
        return this.downstreamLinks;
    }

    public void setDownstreamLinks(List<ProvLinksDTO> downstreamLinks) {
        this.downstreamLinks = downstreamLinks;
    }

    public void addDownstreamLink(ProvLinksDTO link) {
        this.downstreamLinks.add(link);
    }

    public void setMaxProvenanceGraphSizeReached(boolean maxProvenanceGraphSizeReached) {
        this.maxProvenanceGraphSizeReached = maxProvenanceGraphSizeReached;
    }

    public boolean isMaxProvenanceGraphSizeReached() {
        return this.maxProvenanceGraphSizeReached;
    }

    public static class Builder {
        Map<String, ProvLinksDTO> appLinks = new HashMap<String, ProvLinksDTO>();

        public void addOutArtifacts(String appId, Map<String, ProvOpsDTO> artifacts) {
            this.addArtifacts(appId, Collections.emptyMap(), artifacts);
        }

        public void addInArtifacts(String appId, Map<String, ProvOpsDTO> artifacts) {
            this.addArtifacts(appId, artifacts, Collections.emptyMap());
        }

        public void addArtifacts(String appId, Map<String, ProvOpsDTO> in, Map<String, ProvOpsDTO> out) {
            ProvLinksDTO appArtifacts = this.appLinks.get(appId);
            if (appArtifacts == null) {
                appArtifacts = new ProvLinksDTO();
                this.appLinks.put(appId, appArtifacts);
            }
            appArtifacts.in.putAll(in);
            appArtifacts.out.putAll(out);
        }

        public Map<String, ProvLinksDTO> getAppLinks() {
            return this.appLinks;
        }

        public ProvLinksDTO build() {
            ProvLinksDTO result = new ProvLinksDTO();
            result.setItems(new ArrayList<ProvLinksDTO>(this.appLinks.values()));
            result.setCount(Long.valueOf(this.appLinks.size()));
            return result;
        }
    }
}

