/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.project;

import io.hops.hopsworks.common.dao.hdfs.HdfsDirectoryWithQuotaFeatureFacade;
import io.hops.hopsworks.common.dao.jobs.quota.YarnProjectsQuotaFacade;
import io.hops.hopsworks.common.dao.kafka.ProjectTopicsFacade;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.project.service.ProjectServiceFacade;
import io.hops.hopsworks.common.featurestore.FeaturestoreController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.Utils;
import io.hops.hopsworks.common.hive.HiveController;
import io.hops.hopsworks.common.project.Quotas;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.hdfs.HdfsDirectoryWithQuotaFeature;
import io.hops.hopsworks.persistence.entity.jobs.quota.YarnProjectsQuota;
import io.hops.hopsworks.persistence.entity.project.PaymentType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.service.ProjectServiceEnum;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class ProjectQuotasController {
    @Inject
    private HdfsDirectoryWithQuotaFeatureFacade hdfsDirectoryWithQuotaFeatureFacade;
    @Inject
    private YarnProjectsQuotaFacade yarnProjectsQuotaFacade;
    @Inject
    private HiveController hiveController;
    @Inject
    private ProjectTopicsFacade projectTopicsFacade;
    @Inject
    private ProjectFacade projectFacade;
    @Inject
    private ProjectServiceFacade projectServiceFacade;
    @Inject
    private FeaturestoreController featurestoreController;
    @Inject
    private DistributedFsService dfs;

    public Quotas getQuotas(Project project) {
        Optional<HdfsDirectoryWithQuotaFeature> projectInodeAttrsOptional;
        Quotas quotas = new Quotas();
        Optional<YarnProjectsQuota> yarnQuotaOpt = this.yarnProjectsQuotaFacade.findByProjectName(project.getName());
        if (yarnQuotaOpt.isPresent()) {
            quotas.setYarnQuotaInSecs(Float.valueOf(yarnQuotaOpt.get().getQuotaRemaining()));
            quotas.setYarnUsedQuotaInSecs(Float.valueOf(yarnQuotaOpt.get().getTotal()));
        }
        if ((projectInodeAttrsOptional = this.hdfsDirectoryWithQuotaFeatureFacade.getByInodeId(project.getInode().getId())).isPresent()) {
            Long storageQuota = projectInodeAttrsOptional.get().getSsquota().longValue();
            quotas.setHdfsQuota(this.convertToTeraBytes(storageQuota));
            quotas.setHdfsUsage(this.convertToTeraBytes(projectInodeAttrsOptional.get().getStorageSpace().longValue()));
            Long nsQuota = projectInodeAttrsOptional.get().getNsquota().longValue();
            quotas.setHdfsNsQuota(nsQuota);
            quotas.setHdfsNsCount(projectInodeAttrsOptional.get().getNscount().longValue());
        } else {
            quotas.setHdfsQuota(Float.valueOf(-1.0f));
            quotas.setHdfsNsQuota(-1L);
        }
        List datasets = (List)project.getDatasetCollection();
        for (Dataset ds : datasets) {
            if (ds.getDsType() == DatasetType.HIVEDB) {
                Optional<HdfsDirectoryWithQuotaFeature> dbInodeAttrsOptional = this.hdfsDirectoryWithQuotaFeatureFacade.getByInodeId(ds.getInodeId());
                if (dbInodeAttrsOptional.isPresent()) {
                    quotas.setHiveQuota(this.convertToTeraBytes(dbInodeAttrsOptional.get().getSsquota().longValue()));
                    quotas.setHiveUsage(this.convertToTeraBytes(dbInodeAttrsOptional.get().getStorageSpace().longValue()));
                    quotas.setHiveNsQuota(dbInodeAttrsOptional.get().getNsquota().longValue());
                    quotas.setHiveNsCount(dbInodeAttrsOptional.get().getNscount().longValue());
                    continue;
                }
                quotas.setHiveQuota(Float.valueOf(-1.0f));
                quotas.setHiveNsQuota(-1L);
                continue;
            }
            if (ds.getDsType() != DatasetType.FEATURESTORE) continue;
            Optional<HdfsDirectoryWithQuotaFeature> fsInodeAttrsOptional = this.hdfsDirectoryWithQuotaFeatureFacade.getByInodeId(ds.getInodeId());
            if (fsInodeAttrsOptional.isPresent()) {
                quotas.setFeaturestoreQuota(this.convertToTeraBytes(fsInodeAttrsOptional.get().getSsquota().longValue()));
                quotas.setFeaturestoreUsage(this.convertToTeraBytes(fsInodeAttrsOptional.get().getStorageSpace().longValue()));
                quotas.setFeaturestoreNsQuota(fsInodeAttrsOptional.get().getNsquota().longValue());
                quotas.setFeaturestoreNsCount(fsInodeAttrsOptional.get().getNscount().longValue());
                continue;
            }
            quotas.setFeaturestoreQuota(Float.valueOf(-1.0f));
            quotas.setFeaturestoreNsQuota(-1L);
        }
        quotas.setKafkaNumTopics(this.projectTopicsFacade.countTopicsByProject(project));
        quotas.setKafkaMaxNumTopics(project.getKafkaMaxNumTopics());
        return quotas;
    }

    public Project updateQuotas(Project project, Quotas quotas, PaymentType newPaymentType) throws ProjectException {
        if (quotas != null) {
            try (DistributedFileSystemOps dfso = this.dfs.getDfsOps();){
                dfso.setHdfsQuotaBytes(new Path(Utils.getProjectPath(project.getName())), quotas.getHdfsNsQuota(), this.convertToBytes(quotas.getHdfsQuota()));
                if (this.projectServiceFacade.isServiceEnabledForProject(project, ProjectServiceEnum.HIVE)) {
                    dfso.setHdfsQuotaBytes(this.hiveController.getDbPath(project.getName()), quotas.getHiveNsQuota(), this.convertToBytes(quotas.getHiveQuota()));
                }
                if (this.projectServiceFacade.isServiceEnabledForProject(project, ProjectServiceEnum.FEATURESTORE)) {
                    dfso.setHdfsQuotaBytes(this.hiveController.getDbPath(this.featurestoreController.getOfflineFeaturestoreDbName(project)), quotas.getFeaturestoreNsQuota(), this.convertToBytes(quotas.getFeaturestoreQuota()));
                }
            }
            this.yarnProjectsQuotaFacade.changeYarnQuota(project.getName(), quotas.getYarnQuotaInSecs().floatValue());
            this.projectFacade.changeKafkaQuota(project, quotas.getKafkaMaxNumTopics());
            project.setPaymentType(newPaymentType);
            project.setLastQuotaUpdate(new Date());
            this.projectFacade.mergeProject(project);
        }
        return project;
    }

    public Float convertToTeraBytes(Long storage) {
        if (storage == -1L) {
            return Float.valueOf(storage.longValue());
        }
        return Float.valueOf((float)storage.longValue() / 1.0737418E9f);
    }

    public Long convertToBytes(Float storage) {
        if (storage.longValue() == -1L) {
            return -1L;
        }
        return (long)(storage.floatValue() * 1.0737418E9f);
    }
}

