/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jobs.quota;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.jobs.quota.YarnPriceMultiplicator;
import io.hops.hopsworks.persistence.entity.jobs.quota.YarnProjectsQuota;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class YarnProjectsQuotaFacade
extends AbstractFacade<YarnProjectsQuota> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public void persistYarnProjectsQuota(YarnProjectsQuota yarnProjectsQuota) {
        this.em.persist((Object)yarnProjectsQuota);
    }

    public YarnProjectsQuotaFacade() {
        super(YarnProjectsQuota.class);
    }

    public Optional<YarnProjectsQuota> findByProjectName(String projectname) {
        try {
            return Optional.of(this.em.createNamedQuery("YarnProjectsQuota.findByProjectname", YarnProjectsQuota.class).setParameter("projectname", (Object)projectname).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public void flushEm() {
        this.em.flush();
    }

    @Override
    public List<YarnProjectsQuota> findAll() {
        TypedQuery query = this.em.createNamedQuery("YarnProjectsQuota.findAll", YarnProjectsQuota.class);
        return query.getResultList();
    }

    public void changeYarnQuota(String projectName, float quota) {
        YarnProjectsQuota projectQuota = this.findByProjectName(projectName).orElse(new YarnProjectsQuota(projectName));
        projectQuota.setQuotaRemaining(quota);
        this.em.merge((Object)projectQuota);
    }

    public void removeQuota(String projectName) {
        this.findByProjectName(projectName).ifPresent(this::remove);
    }

    public List<YarnPriceMultiplicator> getMultiplicators() {
        try {
            TypedQuery query = this.em.createNamedQuery("YarnPriceMultiplicator.findAll", YarnPriceMultiplicator.class);
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<YarnPriceMultiplicator>();
        }
    }
}

