/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnectorType;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class FeaturestoreConnectorFacade
extends AbstractFacade<FeaturestoreConnector> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeaturestoreConnectorFacade() {
        super(FeaturestoreConnector.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public Optional<FeaturestoreConnector> findById(Integer id) {
        try {
            return Optional.of(this.em.createNamedQuery("FeaturestoreConnector.findById", FeaturestoreConnector.class).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<FeaturestoreConnector> findByIdType(Integer id, FeaturestoreConnectorType type) {
        try {
            return Optional.of(this.em.createNamedQuery("FeaturestoreConnector.findByIdType", FeaturestoreConnector.class).setParameter("id", (Object)id).setParameter("type", (Object)type).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<FeaturestoreConnector> findByFeaturestore(Featurestore featurestore) {
        return this.em.createNamedQuery("FeaturestoreConnector.findByFeaturestore", FeaturestoreConnector.class).setParameter("featurestore", (Object)featurestore).getResultList();
    }

    public Optional<FeaturestoreConnector> findByFeaturestoreId(Featurestore featurestore, Integer id) {
        try {
            return Optional.of(this.em.createNamedQuery("FeaturestoreConnector.findByFeaturestoreId", FeaturestoreConnector.class).setParameter("featurestore", (Object)featurestore).setParameter("id", (Object)id).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<FeaturestoreConnector> findByFeaturestoreName(Featurestore featurestore, String name) {
        try {
            return Optional.of(this.em.createNamedQuery("FeaturestoreConnector.findByFeaturestoreName", FeaturestoreConnector.class).setParameter("featurestore", (Object)featurestore).setParameter("name", (Object)name).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<FeaturestoreConnector> findByType(Featurestore featurestore, Set<FeaturestoreConnectorType> types) {
        return this.em.createNamedQuery("FeaturestoreConnector.findByType", FeaturestoreConnector.class).setParameter("featurestore", (Object)featurestore).setParameter("types", types).getResultList();
    }

    public void deleteByFeaturestoreName(Featurestore featurestore, String name) {
        this.findByFeaturestoreName(featurestore, name).ifPresent(this::remove);
    }

    public Long countByFeaturestore(Featurestore featurestore) {
        return (Long)this.em.createNamedQuery("FeaturestoreConnector.countByFeaturestore", Long.class).setParameter("featurestore", (Object)featurestore).getSingleResult();
    }
}

