/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.state;

import com.lambdista.util.Try;
import io.hops.hopsworks.common.opensearch.OpenSearchClientController;
import io.hops.hopsworks.common.provenance.app.ProvAppController;
import io.hops.hopsworks.common.provenance.app.ProvAppHelper;
import io.hops.hopsworks.common.provenance.app.dto.ProvAppStateDTO;
import io.hops.hopsworks.common.provenance.app.dto.ProvAppStateOpenSearch;
import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.opensearch.BasicOpenSearchHit;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchCache;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchHelper;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchHits;
import io.hops.hopsworks.common.provenance.state.ProvStateParamBuilder;
import io.hops.hopsworks.common.provenance.state.ProvStateParser;
import io.hops.hopsworks.common.provenance.state.dto.ProvStateDTO;
import io.hops.hopsworks.common.provenance.util.ProvHelper;
import io.hops.hopsworks.common.provenance.util.functional.CheckedFunction;
import io.hops.hopsworks.common.provenance.util.functional.CheckedSupplier;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.javatuples.Pair;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.sort.SortOrder;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProvStateController {
    private static final Logger LOGGER = Logger.getLogger(ProvStateController.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private OpenSearchClientController client;
    @EJB
    private ProvAppController appCtrl;
    @EJB
    private OpenSearchCache cache;

    public ProvStateController(Settings settings, OpenSearchClientController client, OpenSearchCache cache) {
        this.settings = settings;
        this.client = client;
        this.cache = cache;
    }

    public ProvStateController() {
    }

    public ProvStateDTO provFileStateList(Project project, ProvStateParamBuilder params) throws ProvenanceException {
        if (params.base.pagination != null && !params.extensions.appStateFilter.isEmpty()) {
            String msg = "cannot use pagination with app state filtering";
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.UNSUPPORTED, Level.INFO, msg);
        }
        ProvStateDTO fileStates = this.provFileState(project, params.base, new HandlerFactory.BaseList(), Provenance.getProjectIndex(project));
        if (params.extensions.hasAppExpansion()) {
            for (ProvStateDTO fileState : fileStates.getItems()) {
                Optional<String> appId = this.getAppId(fileState);
                if (!appId.isPresent()) continue;
                params.withAppExpansion(appId.get());
            }
            Map<String, Map<Provenance.AppState, ProvAppStateOpenSearch>> appExps = this.appCtrl.provAppState(params.extensions.appStateFilter);
            for (ProvStateDTO fileState : fileStates.getItems()) {
                Optional<String> appId = this.getAppId(fileState);
                if (appId.isPresent() && appExps.containsKey(appId.get())) {
                    Map<Provenance.AppState, ProvAppStateOpenSearch> appExp = appExps.get(appId.get());
                    fileState.setAppState(ProvAppHelper.buildAppState(appExp));
                    continue;
                }
                fileState.setAppState(ProvAppStateDTO.unknown());
            }
        }
        return fileStates;
    }

    public <R, S1, S2> S2 provFileState(Project project, ProvStateParamBuilder.Base base, HandlerFactory<R, S1, S2> handlerFactory, String index) throws ProvenanceException {
        this.checkMapping(base, index);
        return this.provFileState(project.getInode().getId(), base.fileStateFilter, base.fileStateSortBy, base.exactXAttrFilter, base.likeXAttrFilter, base.hasXAttrFilter, base.xAttrSortBy, (Integer)base.pagination.getValue0(), (Integer)base.pagination.getValue1(), handlerFactory);
    }

    public ProvStateDTO provFileStateCount(Project project, ProvStateParamBuilder params) throws ProvenanceException {
        if (params.extensions.hasAppExpansion()) {
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.UNSUPPORTED, Level.INFO, "provenance file state count does not currently work with app state expansion");
        }
        return this.provFileStateCount(project.getInode().getId(), params.base.fileStateFilter, params.base.exactXAttrFilter, params.base.likeXAttrFilter, params.base.hasXAttrFilter);
    }

    private void checkMapping(ProvStateParamBuilder.Base base, String index) throws ProvenanceException {
        try {
            Map<String, String> mapping = this.cache.mngIndexGetMapping(index, false);
            try {
                base.fixSortBy(index, mapping);
            }
            catch (ProvenanceException e) {
                mapping = this.cache.mngIndexGetMapping(index, true);
                if (mapping.isEmpty()) {
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, "provenance file state - no index");
                }
                base.fixSortBy(index, mapping);
            }
        }
        catch (OpenSearchException e) {
            String msg = "provenance - opensearch query problem";
            throw ProvHelper.fromOpenSearch(e, msg, msg + " - file state mapping");
        }
    }

    private Optional<String> getAppId(ProvStateDTO fileState) {
        if (fileState.getAppId().equals("none")) {
            if (fileState.getXattrs().containsKey("appId")) {
                return Optional.of(fileState.getXattrs().get("appId"));
            }
            return Optional.empty();
        }
        return Optional.of(fileState.getAppId());
    }

    private <R, S1, S2> S2 provFileState(Long projectIId, Map<ProvParser.Field, ProvParser.FilterVal> fileStateFilters, List<Pair<ProvParser.Field, SortOrder>> fileStateSortBy, Map<String, String> xAttrsFilters, Map<String, String> likeXAttrsFilters, Set<String> hasXAttrsFilters, List<ProvStateParamBuilder.SortE> xattrSortBy, Integer offset, Integer limit, HandlerFactory<R, S1, S2> handlerFactory) throws ProvenanceException {
        Pair<Long, Try<S1>> searchResult;
        CheckedSupplier<SearchRequest, ProvenanceException> srF = OpenSearchHelper.baseSearchRequest(this.settings.getProvFileIndex(projectIId), this.settings.getOpenSearchDefaultScrollPageSize()).andThen(this.filterByStateParams(fileStateFilters, xAttrsFilters, likeXAttrsFilters, hasXAttrsFilters)).andThen(OpenSearchHelper.withFileStateOrder(fileStateSortBy, xattrSortBy)).andThen(OpenSearchHelper.withPagination(offset, limit, this.settings.getOpenSearchMaxScrollPageSize().intValue()));
        SearchRequest request = srF.get();
        try {
            searchResult = this.client.search(request, handlerFactory.getHandler());
        }
        catch (OpenSearchException e) {
            String msg = "provenance - opensearch query problem";
            throw ProvHelper.fromOpenSearch(e, msg, msg + " - file state");
        }
        return handlerFactory.checkedResult(searchResult);
    }

    private ProvStateDTO provFileStateCount(Long projectIId, Map<ProvParser.Field, ProvParser.FilterVal> fileStateFilters, Map<String, String> xAttrsFilters, Map<String, String> likeXAttrsFilters, Set<String> hasXAttrsFilters) throws ProvenanceException {
        Long searchResult;
        CheckedSupplier<SearchRequest, ProvenanceException> srF = OpenSearchHelper.countSearchRequest(this.settings.getProvFileIndex(projectIId)).andThen(this.filterByStateParams(fileStateFilters, xAttrsFilters, likeXAttrsFilters, hasXAttrsFilters));
        SearchRequest request = srF.get();
        try {
            searchResult = this.client.searchCount(request);
        }
        catch (OpenSearchException e) {
            String msg = "provenance - opensearch query problem";
            throw ProvHelper.fromOpenSearch(e, msg, msg + " - file state count");
        }
        ProvStateDTO container = new ProvStateDTO();
        container.setCount(searchResult);
        return container;
    }

    private CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> filterByStateParams(Map<ProvParser.Field, ProvParser.FilterVal> fileStateFilters, Map<String, String> xAttrsFilters, Map<String, String> likeXAttrsFilters, Set<String> hasXAttrsFilters) {
        return sr -> {
            BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)ProvParser.Fields.ENTRY_TYPE.toString().toLowerCase(), (String)ProvParser.EntryType.STATE.toString().toLowerCase()));
            query = OpenSearchHelper.filterByBasicFields(query, fileStateFilters);
            for (Map.Entry filter : xAttrsFilters.entrySet()) {
                query = query.must(this.getXAttrQB((String)filter.getKey(), (String)filter.getValue()));
            }
            for (Map.Entry filter : likeXAttrsFilters.entrySet()) {
                query = query.must(this.getLikeXAttrQB((String)filter.getKey(), (String)filter.getValue()));
            }
            for (String xattrKey : hasXAttrsFilters) {
                query = query.must(this.hasXAttrQB(xattrKey));
            }
            sr.source().query((QueryBuilder)query);
            return sr;
        };
    }

    public QueryBuilder hasXAttrQB(String xattrAdjustedKey) {
        return QueryBuilders.existsQuery((String)xattrAdjustedKey);
    }

    public QueryBuilder getXAttrQB(String xattrAdjustedKey, String xattrVal) {
        return QueryBuilders.termQuery((String)xattrAdjustedKey, (String)xattrVal.toLowerCase());
    }

    public QueryBuilder getLikeXAttrQB(String xattrAdjustedKey, String xattrVal) {
        return OpenSearchHelper.fullTextSearch(xattrAdjustedKey, xattrVal);
    }

    public static interface HandlerFactory<R, S1, S2> {
        public OpenSearchHits.Handler<R, S1> getHandler();

        public S2 checkedResult(Pair<Long, Try<S1>> var1) throws ProvenanceException;

        public static class MLIdSet
        implements HandlerFactory<ProvStateDTO, Set<ProvStateDTO>, Pair<Long, Set<ProvStateDTO>>> {
            @Override
            public OpenSearchHits.Handler<ProvStateDTO, Set<ProvStateDTO>> getHandler() {
                OpenSearchHits.Parser mlIdParser = hit -> ProvStateParser.tryInstance(BasicOpenSearchHit.instance(hit));
                return OpenSearchHits.handlerAddToSet(mlIdParser);
            }

            @Override
            public Pair<Long, Set<ProvStateDTO>> checkedResult(Pair<Long, Try<Set<ProvStateDTO>>> result) throws ProvenanceException {
                try {
                    return Pair.with((Object)result.getValue0(), (Object)((Try)result.getValue1()).checkedGet());
                }
                catch (Throwable t) {
                    if (t instanceof ProvenanceException) {
                        throw (ProvenanceException)t;
                    }
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.INFO, "unhandled error", "unhandled error", t);
                }
            }
        }

        public static class BaseList
        implements HandlerFactory<ProvStateDTO, List<ProvStateDTO>, ProvStateDTO> {
            @Override
            public OpenSearchHits.Handler<ProvStateDTO, List<ProvStateDTO>> getHandler() {
                OpenSearchHits.Parser parser = hit -> ProvStateParser.tryInstance(BasicOpenSearchHit.instance(hit));
                return OpenSearchHits.handlerAddToList(parser);
            }

            @Override
            public ProvStateDTO checkedResult(Pair<Long, Try<List<ProvStateDTO>>> result) throws ProvenanceException {
                try {
                    ProvStateDTO container = new ProvStateDTO();
                    container.setItems((List)((Try)result.getValue1()).checkedGet());
                    container.setCount((Long)result.getValue0());
                    return container;
                }
                catch (Throwable t) {
                    if (t instanceof ProvenanceException) {
                        throw (ProvenanceException)t;
                    }
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.INFO, "unhandled error", "unhandled error", t);
                }
            }
        }
    }
}

