/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka.schemas;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.kafka.schemas.Schemas;
import io.hops.hopsworks.persistence.entity.kafka.schemas.Subjects;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.util.List;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;

@Stateless
public class SubjectsFacade
extends AbstractFacade<Subjects> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public SubjectsFacade() {
        super(Subjects.class);
    }

    public List<String> getListOfSubjects(Project project) {
        return this.em.createNamedQuery("Subjects.findSetOfSubjects", String.class).setParameter("project", (Object)project).getResultList();
    }

    public Optional<Subjects> findSubjectByNameAndVersion(Project project, String subject, Integer version) {
        try {
            return Optional.of(this.em.createNamedQuery("Subjects.findBySubjectAndVersion", Subjects.class).setParameter("subject", (Object)subject).setParameter("version", (Object)version).setParameter("project", (Object)project).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<Subjects> findSubjectByNameAndSchema(Project project, String subject, String schema) {
        try {
            return Optional.of(this.em.createNamedQuery("Subjects.findBySubjectNameAndSchema", Subjects.class).setParameter("project", (Object)project).setParameter("subject", (Object)subject).setParameter("schema", (Object)schema).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public void removeBySubjectAndVersion(Project project, String subject, Integer version) {
        this.em.createNamedQuery("Subjects.deleteBySubjectAndVersion", Subjects.class).setParameter("project", (Object)project).setParameter("subject", (Object)subject).setParameter("version", (Object)version).executeUpdate();
    }

    public List<Subjects> findSubjectByName(Project project, String subject) {
        return this.em.createNamedQuery("Subjects.findBySubject", Subjects.class).setParameter("project", (Object)project).setParameter("subject", (Object)subject).getResultList();
    }

    public Integer insertNewSubject(Project project, String subjectName, Schemas schema, Integer version) {
        Subjects subject = new Subjects(subjectName, version.intValue(), schema, project);
        this.save(subject);
        this.em.flush();
        return schema.getId();
    }

    public Integer deleteSubject(Project project, String subject) {
        return this.em.createNamedQuery("Subjects.deleteSubject").setParameter("project", (Object)project).setParameter("subject", (Object)subject).executeUpdate();
    }

    public Optional<Subjects> findSubjectLatestVersion(Project project, String subject) {
        try {
            return Optional.of(this.em.createNamedQuery("Subjects.findLatestVersionOfSubject", Subjects.class).setParameter("project", (Object)project).setParameter("subject", (Object)subject).setMaxResults(1).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }
}

