/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user;

import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.user.security.ua.UserAccountStatus;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import javax.ejb.Stateless;

@Stateless
public class UserStatusValidator {
    public boolean checkStatus(UserAccountStatus status) throws UserException {
        if (status.equals((Object)UserAccountStatus.NEW_MOBILE_ACCOUNT)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_INACTIVE, Level.FINE);
        }
        if (status.equals((Object)UserAccountStatus.BLOCKED_ACCOUNT) || status.equals((Object)UserAccountStatus.SPAM_ACCOUNT)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_BLOCKED, Level.FINE);
        }
        if (status.equals((Object)UserAccountStatus.DEACTIVATED_ACCOUNT)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_DEACTIVATED, Level.FINE);
        }
        if (status.equals((Object)UserAccountStatus.LOST_MOBILE)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_LOST_DEVICE, Level.FINE);
        }
        if (status.equals((Object)UserAccountStatus.VERIFIED_ACCOUNT)) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_NOT_APPROVED, Level.FINE);
        }
        return true;
    }

    public void checkNewUserStatus(UserAccountStatus status) throws UserException {
        switch (status) {
            case NEW_MOBILE_ACCOUNT: {
                return;
            }
            case VERIFIED_ACCOUNT: 
            case ACTIVATED_ACCOUNT: {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_ALREADY_VERIFIED, Level.FINE);
            }
            case LOST_MOBILE: {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_LOST_DEVICE, Level.FINE);
            }
            case DEACTIVATED_ACCOUNT: {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_DEACTIVATED, Level.FINE);
            }
        }
        throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_BLOCKED, Level.FINE);
    }
}

