/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ServingStatusEnum {
    CREATED("Created"),
    STARTING("Starting"),
    FAILED("Failed"),
    RUNNING("Running"),
    IDLE("Idle"),
    UPDATING("Updating"),
    STOPPING("Stopping"),
    STOPPED("Stopped");

    private final String readable;

    private ServingStatusEnum(String readable) {
        this.readable = readable;
    }

    @JsonValue
    public String getReadable() {
        return this.readable;
    }

    @JsonCreator
    public static ServingStatusEnum fromString(String status) {
        if (status != null) {
            status = status.toLowerCase();
            for (ServingStatusEnum value : ServingStatusEnum.values()) {
                if (!value.toString().toLowerCase().equals(status)) continue;
                return value;
            }
            throw new IllegalArgumentException("Unknown status '" + status + "'");
        }
        return null;
    }

    public String toString() {
        return this.readable;
    }
}

