/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.state;

import io.hops.hopsworks.common.provenance.app.ProvAParser;
import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.state.ProvStateParser;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.javatuples.Pair;
import org.opensearch.search.sort.SortOrder;

public class ProvStateParamBuilder {
    public Base base = new Base();
    public Extensions extensions = new Extensions();

    public ProvStateParamBuilder paginate(Integer offset, Integer limit) {
        this.base.pagination = Pair.with((Object)offset, (Object)limit);
        return this;
    }

    public ProvStateParamBuilder filterByFields(Set<String> params) throws ProvenanceException {
        for (String param : params) {
            Pair<ProvStateParser.Field, Object> filter = ProvStateParser.extractFilter(param);
            ProvParser.addToFilters(this.base.fileStateFilter, (ProvParser.Field)filter.getValue0(), filter.getValue1());
        }
        return this;
    }

    public ProvStateParamBuilder filterByField(ProvStateParser.Field field, Object val) throws ProvenanceException {
        Object checkedVal = field.filterValParser().apply(val);
        ProvParser.addToFilters(this.base.fileStateFilter, field, checkedVal);
        return this;
    }

    public ProvStateParamBuilder filterByXAttrs(Set<String> params) throws ProvenanceException {
        for (String param : params) {
            Pair<String, String> p = ProvParser.extractXAttrParam(param);
            this.base.exactXAttrFilter.put((String)p.getValue0(), (String)p.getValue1());
        }
        return this;
    }

    public ProvStateParamBuilder filterByXAttrs(Map<String, String> xAttrs) {
        for (Map.Entry<String, String> xAttr : xAttrs.entrySet()) {
            this.filterByXAttr(xAttr.getKey(), xAttr.getValue());
        }
        return this;
    }

    public ProvStateParamBuilder filterByXAttr(String key, String val) {
        String xattrKey = ProvParser.processXAttrKey(key);
        this.base.exactXAttrFilter.put(xattrKey, val);
        return this;
    }

    public ProvStateParamBuilder filterLikeXAttrs(Set<String> params) throws ProvenanceException {
        for (String param : params) {
            Pair<String, String> p = ProvParser.extractXAttrParam(param);
            this.base.likeXAttrFilter.put((String)p.getValue0(), (String)p.getValue1());
        }
        return this;
    }

    public ProvStateParamBuilder filterLikeXAttrs(Map<String, String> xAttrs) {
        for (Map.Entry<String, String> xAttr : xAttrs.entrySet()) {
            this.filterLikeXAttr(xAttr.getKey(), xAttr.getValue());
        }
        return this;
    }

    public ProvStateParamBuilder filterLikeXAttr(String key, String val) {
        String xattrKey = ProvParser.processXAttrKey(key);
        this.base.likeXAttrFilter.put(xattrKey, val);
        return this;
    }

    public ProvStateParamBuilder sortByFields(List<String> params) throws ProvenanceException {
        for (String param : params) {
            Pair<ProvParser.Field, SortOrder> field = ProvStateParser.extractSort(param);
            this.base.fileStateSortBy.add(field);
        }
        return this;
    }

    public ProvStateParamBuilder sortByField(ProvStateParser.Field field, SortOrder order) {
        this.base.fileStateSortBy.add((Pair<ProvParser.Field, SortOrder>)Pair.with((Object)field, (Object)order));
        return this;
    }

    public ProvStateParamBuilder sortByXAttrs(List<String> params) throws ProvenanceException {
        for (String param : params) {
            Pair<String, String> xattr = ProvParser.extractXAttrParam(param);
            SortOrder order = ProvParser.extractSortOrder((String)xattr.getValue1());
            this.base.xAttrSortBy.add(new SortE((String)xattr.getValue0(), order));
        }
        return this;
    }

    public ProvStateParamBuilder sortByXAttr(String field, SortOrder order) {
        String xattrKey = ProvParser.processXAttrKey(field);
        this.base.xAttrSortBy.add(new SortE(xattrKey, order));
        return this;
    }

    public ProvStateParamBuilder hasXAttr(String key) {
        String xattrKey = ProvParser.processXAttrKey(key);
        this.base.hasXAttrFilter.add(xattrKey);
        return this;
    }

    public ProvStateParamBuilder hasXAttrs(Set<String> keys) {
        for (String key : keys) {
            this.hasXAttr(key);
        }
        return this;
    }

    public ProvStateParamBuilder withAppExpansion() {
        this.extensions.expansions.add(ProvParser.OpenSearchExpansions.APP);
        return this;
    }

    public ProvStateParamBuilder withAppExpansion(String appId) throws ProvenanceException {
        this.withAppExpansion();
        ProvParser.addToFilters(this.extensions.appStateFilter, (Pair<ProvParser.Field, Object>)Pair.with((Object)ProvAParser.Field.APP_ID, (Object)appId));
        return this;
    }

    public ProvStateParamBuilder withAppExpansionFilter(Set<String> params) throws ProvenanceException {
        for (String param : params) {
            ProvParser.addToFilters(this.extensions.appStateFilter, ProvAParser.extractFilter(param));
        }
        return this;
    }

    public ProvStateParamBuilder withExpansions(Set<String> params) throws ProvenanceException {
        ProvParser.withExpansions(this.extensions.expansions, params);
        return this;
    }

    public static class SortE {
        public String key;
        public SortOrder order;

        public SortE(String key, SortOrder order) {
            this.key = key;
            this.order = order;
        }
    }

    public static class Extensions {
        Set<ProvParser.OpenSearchExpansions> expansions = new HashSet<ProvParser.OpenSearchExpansions>();
        Map<ProvParser.Field, ProvParser.FilterVal> appStateFilter = new HashMap<ProvParser.Field, ProvParser.FilterVal>();

        public boolean hasAppExpansion() {
            return this.expansions.contains((Object)ProvParser.OpenSearchExpansions.APP);
        }
    }

    public static class Base {
        Map<ProvParser.Field, ProvParser.FilterVal> fileStateFilter = new HashMap<ProvParser.Field, ProvParser.FilterVal>();
        List<Pair<ProvParser.Field, SortOrder>> fileStateSortBy = new ArrayList<Pair<ProvParser.Field, SortOrder>>();
        Map<String, String> exactXAttrFilter = new HashMap<String, String>();
        Map<String, String> likeXAttrFilter = new HashMap<String, String>();
        Set<String> hasXAttrFilter = new HashSet<String>();
        List<SortE> xAttrSortBy = new ArrayList<SortE>();
        Pair<Integer, Integer> pagination = null;

        public void fixSortBy(String index, Map<String, String> mapping) throws ProvenanceException {
            for (SortE s : this.xAttrSortBy) {
                String type = mapping.get(s.key);
                if (type == null) {
                    String devMsg = "missing mapping for field[" + s.key + "] - index[" + index + "] - ";
                    String usrMsg = "bad field[" + s.key + "]";
                    ProvenanceException ex = new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, usrMsg, devMsg);
                    throw ex;
                }
                if (!type.equals("text")) continue;
                s.key = s.key + ".keyword";
            }
        }
    }
}

