/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.proxies.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.proxies.client.HttpConnectionManagerBuilder;
import io.hops.hopsworks.common.proxies.client.NotRetryableClientProtocolException;
import io.hops.hopsworks.common.util.Settings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class HttpClient {
    private static final String AUTH_HEADER_CONTENT = "Bearer %s";
    @EJB
    private Settings settings;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    private PoolingHttpClientConnectionManager connectionManager;
    private CloseableHttpClient client;
    private HttpHost host;
    private ObjectMapper objectMapper;

    @PostConstruct
    public void init() throws RuntimeException {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            HttpConnectionManagerBuilder connectionManagerBuilder = new HttpConnectionManagerBuilder().withTrustStore(Paths.get(this.settings.getHopsworksDomainDir(), "config", "cacerts.jks"), this.settings.getHopsworksMasterPasswordSsl().toCharArray());
            this.connectionManager = this.createConnectionManager(connectionManagerBuilder);
            this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setKeepAliveStrategy((httpResponse, httpContext) -> this.settings.getConnectionKeepAliveTimeout() * 1000).build();
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }

    private PoolingHttpClientConnectionManager createConnectionManager(HttpConnectionManagerBuilder connectionManagerBuilder) throws IOException, GeneralSecurityException {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(connectionManagerBuilder.build());
        connectionManager.setMaxTotal(10);
        connectionManager.setDefaultMaxPerRoute(10);
        return connectionManager;
    }

    public void setAuthorizationHeader(HttpRequest httpRequest) {
        httpRequest.setHeader("Authorization", String.format(AUTH_HEADER_CONTENT, this.settings.getServiceMasterJWT()));
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public <T> T execute(HttpRequest request, ResponseHandler<T> handler) throws IOException {
        if (this.host == null) {
            try {
                Service hopsworksService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.HOPSWORKS_APP);
                this.host = new HttpHost(hopsworksService.getName(), hopsworksService.getPort().intValue(), "HTTPS");
            }
            catch (ServiceDiscoveryException ex) {
                throw new IOException(ex);
            }
        }
        return (T)this.client.execute(this.host, request, handler);
    }

    public <T> T execute(HttpHost host, HttpRequest request, ResponseHandler<T> handler) throws IOException {
        return (T)this.client.execute(host, request, handler);
    }

    public static class NoBodyResponseHandler<T>
    implements ResponseHandler<T> {
        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            String responseJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            if (response.getStatusLine().getStatusCode() / 100 == 5) {
                throw new IOException(responseJson);
            }
            if (response.getStatusLine().getStatusCode() / 100 == 4) {
                throw new NotRetryableClientProtocolException(responseJson);
            }
            return null;
        }
    }

    public static class ByteResponseHandler
    implements ResponseHandler<byte[]> {
        public byte[] handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            byte[] responseByte = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() / 100 == 2) {
                return responseByte;
            }
            if (response.getStatusLine().getStatusCode() / 100 == 5) {
                String responseJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
                throw new IOException(responseJson);
            }
            String responseJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            throw new NotRetryableClientProtocolException(responseJson);
        }
    }

    public static class StringResponseHandler
    implements ResponseHandler<String> {
        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            String responseJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            if (response.getStatusLine().getStatusCode() / 100 == 2) {
                return responseJson;
            }
            if (response.getStatusLine().getStatusCode() / 100 == 5) {
                throw new IOException(responseJson);
            }
            throw new NotRetryableClientProtocolException(responseJson);
        }
    }

    public static class ObjectResponseHandler<T>
    implements ResponseHandler<T> {
        private Class<T> cls;
        private ObjectMapper objectMapper;

        public ObjectResponseHandler(Class<T> cls, ObjectMapper objectMapper) {
            this.cls = cls;
            this.objectMapper = objectMapper;
        }

        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            String responseJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            if (response.getStatusLine().getStatusCode() / 100 == 2) {
                return (T)this.objectMapper.readValue(responseJson, this.cls);
            }
            if (response.getStatusLine().getStatusCode() / 100 == 5) {
                throw new IOException(responseJson);
            }
            throw new NotRetryableClientProtocolException(responseJson);
        }
    }
}

