/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jupyter.config;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import freemarker.template.TemplateException;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterPaths;
import io.hops.hopsworks.common.hive.HiveController;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.jobs.JobController;
import io.hops.hopsworks.common.jupyter.JupyterContentsManager;
import io.hops.hopsworks.common.kafka.KafkaBrokers;
import io.hops.hopsworks.common.serving.ServingConfig;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.SparkConfigurationUtil;
import io.hops.hopsworks.common.util.TemplateEngine;
import io.hops.hopsworks.common.util.templates.jupyter.JupyterNotebookConfigTemplate;
import io.hops.hopsworks.common.util.templates.jupyter.JupyterNotebookConfigTemplateBuilder;
import io.hops.hopsworks.common.util.templates.jupyter.KernelTemplate;
import io.hops.hopsworks.common.util.templates.jupyter.KernelTemplateBuilder;
import io.hops.hopsworks.common.util.templates.jupyter.SparkMagicConfigTemplateBuilder;
import io.hops.hopsworks.exceptions.ApiKeyException;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.jobs.configuration.DockerJobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.jobs.configuration.spark.SparkJobConfiguration;
import io.hops.hopsworks.persistence.entity.jupyter.JupyterSettings;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class JupyterConfigFilesGenerator {
    private static final Logger LOGGER = Logger.getLogger(JupyterConfigFilesGenerator.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private TemplateEngine templateEngine;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private KafkaBrokers kafkaBrokers;
    @EJB
    private HiveController hiveController;
    @EJB
    private JobController jobController;
    @Inject
    private ServingConfig servingConfig;

    public JupyterPaths generateJupyterPaths(Project project, String hdfsUser, String secretConfig) {
        return new JupyterPaths(this.settings.getJupyterDir(), project.getName(), hdfsUser, secretConfig);
    }

    public JupyterPaths generateConfiguration(Project project, String secretConfig, String hdfsUser, Users hopsworksUser, JupyterSettings js, Integer port, String allowOrigin) throws ServiceException, JobException {
        boolean newDir = false;
        JupyterPaths jp = this.generateJupyterPaths(project, hdfsUser, secretConfig);
        try {
            newDir = this.createJupyterDirs(jp);
            this.createConfigFiles(jp, hdfsUser, hopsworksUser, project, port, js, allowOrigin);
        }
        catch (ServiceDiscoveryException | ApiKeyException | ServiceException | IOException e) {
            if (newDir) {
                this.removeProjectUserDirRecursive(jp);
            }
            LOGGER.log(Level.SEVERE, "Error in initializing JupyterConfig for project: {0}. {1}", new Object[]{project.getName(), e});
            throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_ADD_FAILURE, Level.SEVERE, null, e.getMessage(), e);
        }
        return jp;
    }

    private boolean createJupyterDirs(JupyterPaths jp) throws IOException {
        File projectDir = new File(jp.getProjectUserPath());
        projectDir.mkdirs();
        File baseDir = new File(jp.getNotebookPath());
        baseDir.mkdirs();
        HashSet<PosixFilePermission> xOnly = new HashSet<PosixFilePermission>();
        xOnly.add(PosixFilePermission.OWNER_WRITE);
        xOnly.add(PosixFilePermission.OWNER_READ);
        xOnly.add(PosixFilePermission.OWNER_EXECUTE);
        xOnly.add(PosixFilePermission.GROUP_WRITE);
        xOnly.add(PosixFilePermission.GROUP_EXECUTE);
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(Paths.get(jp.getNotebookPath(), new String[0]), perms);
        Files.setPosixFilePermissions(Paths.get(jp.getProjectUserPath(), new String[0]), xOnly);
        new File(jp.getConfDirPath()).mkdirs();
        new File(jp.getRunDirPath()).mkdirs();
        new File(jp.getLogDirPath()).mkdirs();
        new File(jp.getCertificatesDir()).mkdirs();
        new File(jp.getKernelsDir()).mkdirs();
        return true;
    }

    public String pythonKernelName(String pythonVersion) {
        return "python" + pythonVersion.charAt(0);
    }

    public String pythonKernelPath(String kernelsDir, String pythonKernelName) {
        return kernelsDir + File.separator + pythonKernelName;
    }

    public void createJupyterKernelConfig(Writer out, Project project, JupyterSettings js, String hdfsUser) throws IOException {
        try {
            KernelTemplate kernelTemplate = KernelTemplateBuilder.newBuilder().setHdfsUser(hdfsUser).setHadoopHome(this.settings.getHadoopSymbolicLinkDir()).setHadoopVersion(this.settings.getHadoopVersion()).setAnacondaHome(this.settings.getAnacondaProjectDir()).setSecretDirectory(this.settings.getStagingDir() + "/private_dirs/" + js.getSecret()).setProject(project).setHiveEndpoints(this.hiveController.getHiveServerInternalEndpoint()).setLibHdfsOpts("-Xmx512m").build();
            HashMap<String, Object> dataModel = new HashMap<String, Object>(1);
            dataModel.put("kernel", kernelTemplate);
            this.templateEngine.template("kernel_template.json", dataModel, out);
        }
        catch (ServiceDiscoveryException | TemplateException ex) {
            throw new IOException(ex);
        }
    }

    public void createJupyterNotebookConfig(Writer out, Project project, int port, JupyterSettings js, String hdfsUser, String certsDir, String allowOrigin) throws IOException, ServiceException, ServiceDiscoveryException {
        Service namenode = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.RPC_NAMENODE);
        String hopsworksRestEndpoint = "https://" + this.serviceDiscoveryController.constructServiceFQDNWithPort(ServiceDiscoveryController.HopsworksService.HOPSWORKS_APP);
        DockerJobConfiguration dockerJobConfiguration = (DockerJobConfiguration)js.getDockerConfig();
        JupyterContentsManager jcm = JupyterContentsManager.HDFS_CONTENTS_MANAGER;
        JupyterNotebookConfigTemplateBuilder builder = JupyterNotebookConfigTemplateBuilder.newBuilder().setProject(project).setNamenodeIp(namenode.getAddress()).setNamenodePort(String.valueOf(namenode.getPort())).setContentsManager(jcm.getClassName()).setHopsworksEndpoint(hopsworksRestEndpoint).setElasticEndpoint(this.settings.getOpenSearchEndpoint()).setPort(port).setBaseDirectory(js.getBaseDir()).setHdfsUser(hdfsUser).setHadoopHome(this.settings.getHadoopSymbolicLinkDir()).setJupyterCertsDirectory(certsDir).setSecretDirectory(this.settings.getStagingDir() + "/private_dirs/" + js.getSecret()).setAllowOrigin(allowOrigin).setWsPingInterval(this.settings.getJupyterWSPingInterval()).setHadoopClasspathGlob(this.settings.getHadoopClasspathGlob().trim()).setRequestsVerify(this.settings.getRequestsVerify()).setDomainCATruststore(Paths.get(certsDir, hdfsUser + "__tstore.jks").toString()).setServiceDiscoveryDomain(this.settings.getServiceDiscoveryDomain()).setKafkaBrokers(this.kafkaBrokers.getKafkaBrokersString()).setHopsworksPublicHost(this.settings.getHopsworksPublicHost()).setAllocatedNotebookMBs(dockerJobConfiguration.getResourceConfig().getMemory()).setAllocatedNotebookCores(dockerJobConfiguration.getResourceConfig().getCores());
        if (this.settings.isPythonKernelEnabled()) {
            builder.setWhiteListedKernels("'" + this.pythonKernelName(project.getPythonEnvironment().getPythonVersion()) + "', 'pysparkkernel', 'sparkkernel', 'sparkrkernel'");
        } else {
            builder.setWhiteListedKernels("'pysparkkernel', 'sparkkernel', 'sparkrkernel'");
        }
        JupyterNotebookConfigTemplate template = builder.build();
        HashMap<String, Object> dataModel = new HashMap<String, Object>(1);
        dataModel.put("conf", template);
        try {
            this.templateEngine.template("jupyter_notebook_config_template.py", dataModel, out);
        }
        catch (TemplateException ex) {
            throw new IOException(ex);
        }
    }

    public void createSparkMagicConfig(Writer out, Project project, JupyterSettings js, String hdfsUser, Users hopsworksUser, String confDirPath) throws IOException, ServiceDiscoveryException, JobException, ApiKeyException {
        SparkJobConfiguration sparkJobConfiguration = (SparkJobConfiguration)js.getJobConfig();
        if (js.isPythonKernel()) {
            sparkJobConfiguration = (SparkJobConfiguration)this.jobController.getConfiguration(project, JobType.SPARK, true);
        }
        SparkConfigurationUtil sparkConfigurationUtil = new SparkConfigurationUtil();
        HashMap<String, String> extraJavaOptions = new HashMap<String, String>();
        extraJavaOptions.put("hopsworks.logstash.job.info", project.getName().toLowerCase() + ",jupyter,notebook,?");
        HashMap<String, String> finalSparkConfiguration = new HashMap<String, String>();
        finalSparkConfiguration.put("spark.yarn.stagingDir", "hdfs:///Projects/" + project.getName() + "/Resources/.sparkStaging");
        String hopsworksRestEndpoint = "https://" + this.serviceDiscoveryController.constructServiceFQDNWithPort(ServiceDiscoveryController.HopsworksService.HOPSWORKS_APP);
        finalSparkConfiguration.putAll(sparkConfigurationUtil.setFrameworkProperties(project, (JobConfiguration)sparkJobConfiguration, this.settings, hdfsUser, hopsworksUser, extraJavaOptions, this.kafkaBrokers.getKafkaBrokersString(), hopsworksRestEndpoint, this.servingConfig, this.serviceDiscoveryController));
        StringBuilder sparkConfBuilder = new StringBuilder();
        ArrayList keys = new ArrayList(finalSparkConfiguration.keySet());
        Collections.sort(keys);
        for (String configKey : keys) {
            sparkConfBuilder.append("\t\"" + configKey + "\":\"" + (String)finalSparkConfiguration.get(configKey) + "\",\n");
        }
        sparkConfBuilder.deleteCharAt(sparkConfBuilder.lastIndexOf(","));
        try {
            Service livyService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(ServiceDiscoveryController.HopsworksService.LIVY);
            SparkMagicConfigTemplateBuilder templateBuilder = SparkMagicConfigTemplateBuilder.newBuilder().setLivyIp(livyService.getAddress()).setJupyterHome(confDirPath).setDriverCores(Integer.parseInt((String)finalSparkConfiguration.get("spark.driver.cores"))).setDriverMemory((String)finalSparkConfiguration.get("spark.driver.memory")).setLivyStartupTimeout(this.settings.getLivyStartupTimeout());
            if (sparkJobConfiguration.isDynamicAllocationEnabled() || sparkJobConfiguration.getExperimentType() != null) {
                templateBuilder.setNumExecutors(1);
            } else {
                templateBuilder.setNumExecutors(Integer.parseInt((String)finalSparkConfiguration.get("spark.executor.instances")));
            }
            templateBuilder.setExecutorCores(Integer.parseInt((String)finalSparkConfiguration.get("spark.executor.cores"))).setExecutorMemory((String)finalSparkConfiguration.get("spark.executor.memory")).setHdfsUser(hdfsUser).setYarnQueue(sparkJobConfiguration.getAmQueue()).setHadoopHome(this.settings.getHadoopSymbolicLinkDir()).setHadoopVersion(this.settings.getHadoopVersion()).setSparkConfiguration(sparkConfBuilder.toString());
            HashMap<String, Object> dataModel = new HashMap<String, Object>(1);
            dataModel.put("conf", templateBuilder.build());
            this.templateEngine.template("config_template.json", dataModel, out);
        }
        catch (ServiceDiscoveryException | TemplateException ex) {
            throw new IOException(ex);
        }
    }

    private void createConfigFiles(JupyterPaths jp, String hdfsUser, Users hopsworksUser, Project project, Integer port, JupyterSettings js, String allowOrigin) throws IOException, ServiceException, ServiceDiscoveryException, JobException, ApiKeyException {
        String confDirPath = jp.getConfDirPath();
        String kernelsDir = jp.getKernelsDir();
        String certsDir = jp.getCertificatesDir();
        File jupyter_config_file = new File(confDirPath, "jupyter_notebook_config.py");
        File sparkmagic_config_file = new File(confDirPath, "config.json");
        if (!jupyter_config_file.exists()) {
            String pythonKernelName = this.pythonKernelName(project.getPythonEnvironment().getPythonVersion());
            String pythonKernelPath = this.pythonKernelPath(kernelsDir, pythonKernelName);
            File pythonKernelFile = new File(pythonKernelPath, "kernel.json");
            new File(pythonKernelPath).mkdir();
            try (FileWriter out = new FileWriter(pythonKernelFile, false);){
                this.createJupyterKernelConfig(out, project, js, hdfsUser);
            }
            out = new FileWriter(jupyter_config_file, false);
            var17_19 = null;
            try {
                this.createJupyterNotebookConfig(out, project, port, js, hdfsUser, certsDir, allowOrigin);
            }
            catch (Throwable throwable) {
                var17_19 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var17_19 != null) {
                        try {
                            ((Writer)out).close();
                        }
                        catch (Throwable throwable) {
                            var17_19.addSuppressed(throwable);
                        }
                    } else {
                        ((Writer)out).close();
                    }
                }
            }
        }
        if (!sparkmagic_config_file.exists()) {
            try (FileWriter out = new FileWriter(sparkmagic_config_file, false);){
                this.createSparkMagicConfig(out, project, js, hdfsUser, hopsworksUser, confDirPath);
            }
        }
    }

    private void removeProjectUserDirRecursive(JupyterPaths jp) {
        try {
            FileUtils.deleteDirectory((File)new File(jp.getProjectUserPath()));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not delete Jupyter directory: " + jp.getProjectUserPath(), e);
        }
    }
}

