/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.serving.inference;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class InferencePort {
    private InferencePortName name;
    private Integer number;

    public InferencePort() {
    }

    public InferencePort(InferencePortName name, Integer number) {
        this.name = name;
        this.number = number;
    }

    public InferencePortName getName() {
        return this.name;
    }

    public void setName(InferencePortName name) {
        this.name = name;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InferencePort) {
            InferencePort port = (InferencePort)obj;
            return this.name.equals((Object)port.name) && this.number.equals(port.number);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)((Object)this.name) + this.number.toString()).hashCode();
    }

    public static enum InferencePortName {
        HTTP("http"),
        HTTPS("https"),
        STATUS("status-port"),
        TLS("tls");

        private final String value;

        private InferencePortName(String value) {
            this.value = value;
        }

        public static InferencePortName of(String value) {
            switch (value) {
                case "http2": 
                case "http": {
                    return HTTP;
                }
                case "https": {
                    return HTTPS;
                }
                case "status-port": {
                    return STATUS;
                }
                case "tls": {
                    return TLS;
                }
            }
            throw new IllegalArgumentException("Port name '" + value + "' not known");
        }

        public String toString() {
            return this.value;
        }
    }
}

