/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.hdfs.command;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.persistence.entity.hdfs.command.HdfsCommandExecution;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.jobs.history.Execution;
import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class HdfsCommandExecutionFacade
extends AbstractFacade<HdfsCommandExecution> {
    private static final Logger LOGGER = Logger.getLogger(HdfsCommandExecutionFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager entityManager;

    public HdfsCommandExecutionFacade() {
        super(HdfsCommandExecution.class);
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    public Optional<HdfsCommandExecution> findBySrc(Inode srcInode) {
        TypedQuery query = this.entityManager.createNamedQuery("HdfsCommandExecution.findBySrcInode", HdfsCommandExecution.class).setParameter("srcInode", (Object)srcInode);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<HdfsCommandExecution> findByExecution(Execution execution) {
        TypedQuery query = this.entityManager.createNamedQuery("HdfsCommandExecution.findByExecution", HdfsCommandExecution.class).setParameter("execution", (Object)execution);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }
}

