/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.ops;

import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.EnumSet;
import java.util.logging.Level;
import org.javatuples.Pair;
import org.opensearch.search.sort.SortOrder;

public class ProvOps {
    private static <R> R onlyAllowed() throws ProvenanceException {
        String msg = "allowed fields:" + EnumSet.allOf(FieldsP.class) + " or " + EnumSet.allOf(FieldsPF.class);
        throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
    }

    public static Field extractField(String val) throws ProvenanceException {
        try {
            return FieldsP.valueOf(val.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            try {
                return FieldsPF.valueOf(val.toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException2) {
                return (Field)ProvOps.onlyAllowed();
            }
        }
    }

    public static Pair<Field, Object> extractFilter(String param) throws ProvenanceException {
        String rawVal;
        String rawFilter;
        if (param.contains(":")) {
            int aux = param.indexOf(58);
            rawFilter = param.substring(0, aux);
            rawVal = param.substring(aux + 1);
        } else {
            rawFilter = param;
            rawVal = "true";
        }
        Field field = ProvOps.extractField(rawFilter);
        Object val = field.filterValParser().apply(rawVal);
        return Pair.with((Object)field, val);
    }

    public static Pair<ProvParser.Field, SortOrder> extractSort(String param) throws ProvenanceException {
        String rawSortOrder;
        String rawSortField;
        if (param.contains(":")) {
            int aux = param.indexOf(58);
            rawSortField = param.substring(0, aux);
            rawSortOrder = param.substring(aux + 1);
        } else {
            rawSortField = param;
            rawSortOrder = "ASC";
        }
        Field field = ProvOps.extractField(rawSortField);
        SortOrder sortOrder = ProvParser.extractSortOrder(rawSortOrder);
        return Pair.with((Object)field, (Object)sortOrder);
    }

    public static class DocTypeValParser
    implements ProvParser.ValParser<ProvParser.DocSubType> {
        @Override
        public ProvParser.DocSubType apply(Object o) throws ProvenanceException {
            try {
                if (o instanceof String) {
                    return ProvParser.DocSubType.valueOf((String)o);
                }
                String msg = "expected string-ified version of DocSubType found " + o.getClass();
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String msg = "expected string-ified version of DocSubType found " + o.getClass();
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg, msg, (Throwable)e);
            }
        }
    }

    public static class FileOpValParser
    implements ProvParser.ValParser<Provenance.FileOps> {
        @Override
        public Provenance.FileOps apply(Object o) throws ProvenanceException {
            if (o instanceof String) {
                try {
                    return Provenance.FileOps.valueOf((String)o);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    String msg = "expected string-ified version of File Ops found " + o.getClass();
                    throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg, msg, (Throwable)e);
                }
            }
            if (o instanceof Provenance.FileOps) {
                return (Provenance.FileOps)((Object)o);
            }
            String msg = "expected string-ified version of File Ops found " + o.getClass();
            throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.BAD_REQUEST, Level.INFO, msg);
        }
    }

    public static enum FieldsPF implements Field
    {
        FILE_NAME_LIKE(FieldsP.FILE_NAME, ProvParser.FilterType.LIKE),
        TIMESTAMP_LT(FieldsP.TIMESTAMP, ProvParser.FilterType.RANGE_LT),
        TIMESTAMP_LTE(FieldsP.TIMESTAMP, ProvParser.FilterType.RANGE_LTE),
        TIMESTAMP_GT(FieldsP.TIMESTAMP, ProvParser.FilterType.RANGE_GT),
        TIMESTAMP_GTE(FieldsP.TIMESTAMP, ProvParser.FilterType.RANGE_GTE);

        FieldsP base;
        ProvParser.FilterType filterType;

        private FieldsPF(FieldsP base, ProvParser.FilterType filterType) {
            this.base = base;
            this.filterType = filterType;
        }

        @Override
        public String openSearchFieldName() {
            return this.base.openSearchFieldName();
        }

        @Override
        public String queryFieldName() {
            return this.base.openSearchFieldName();
        }

        @Override
        public ProvParser.FilterType filterType() {
            return this.filterType;
        }

        public ProvParser.ValParser filterValParser() {
            return this.base.filterValParser();
        }
    }

    public static enum FieldsP implements Field
    {
        PROJECT_I_ID(ProvParser.Fields.PROJECT_I_ID, new ProvParser.LongValParser()),
        DATASET_I_ID(ProvParser.Fields.DATASET_I_ID, new ProvParser.LongValParser()),
        PARENT_I_ID(ProvParser.Fields.PARENT_I_ID, new ProvParser.LongValParser()),
        FILE_I_ID(ProvParser.Fields.INODE_ID, new ProvParser.LongValParser()),
        FILE_NAME(ProvParser.Fields.INODE_NAME, new ProvParser.StringValParser()),
        PROJECT_NAME(ProvParser.AuxField.PROJECT_NAME, new ProvParser.StringValParser()),
        USER_ID(ProvParser.Fields.USER_ID, new ProvParser.IntValParser()),
        APP_ID(ProvParser.Fields.APP_ID, new ProvParser.StringValParser()),
        ML_TYPE(ProvParser.Fields.ML_TYPE, new DocTypeValParser()),
        ML_ID(ProvParser.Fields.ML_ID, new ProvParser.StringValParser()),
        FILE_OPERATION(Fields.INODE_OPERATION, new FileOpValParser()),
        PARTITION_ID(ProvParser.AuxField.PARTITION_ID, new ProvParser.LongValParser()),
        TIMESTAMP(Fields.TIMESTAMP, new ProvParser.LongValParser()),
        LOGICAL_TIME(Fields.LOGICAL_TIME, new ProvParser.IntValParser()),
        R_TIMESTAMP(Fields.R_TIMESTAMP, new ProvParser.StringValParser()),
        ENTRY_TYPE(ProvParser.Fields.ENTRY_TYPE, new ProvParser.StringValParser());

        ProvParser.OpenSearchField openSearchField;
        ProvParser.ValParser valParser;

        private FieldsP(ProvParser.OpenSearchField openSearchField, ProvParser.ValParser valParser) {
            this.openSearchField = openSearchField;
            this.valParser = valParser;
        }

        @Override
        public String openSearchFieldName() {
            return this.openSearchField.toString().toLowerCase();
        }

        @Override
        public String queryFieldName() {
            return this.name().toLowerCase();
        }

        @Override
        public ProvParser.FilterType filterType() {
            return ProvParser.FilterType.EXACT;
        }

        public ProvParser.ValParser filterValParser() {
            return this.valParser;
        }
    }

    public static enum Fields implements ProvParser.OpenSearchField
    {
        INODE_OPERATION,
        TIMESTAMP,
        R_TIMESTAMP,
        LOGICAL_TIME;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static interface Field
    extends ProvParser.Field {
    }
}

