/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user;

import com.google.common.base.Strings;
import com.google.zxing.WriterException;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.BbcGroupFacade;
import io.hops.hopsworks.common.dao.user.UserDTO;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.security.audit.AccountAuditFacade;
import io.hops.hopsworks.common.dao.user.security.audit.RolesAuditFacade;
import io.hops.hopsworks.common.dao.user.security.ua.UserAccountsEmailMessages;
import io.hops.hopsworks.common.security.utils.Secret;
import io.hops.hopsworks.common.security.utils.SecurityUtils;
import io.hops.hopsworks.common.user.AuthController;
import io.hops.hopsworks.common.user.QrCode;
import io.hops.hopsworks.common.user.UserAccountHandler;
import io.hops.hopsworks.common.user.UserStatusValidator;
import io.hops.hopsworks.common.user.UserValidator;
import io.hops.hopsworks.common.util.EmailBean;
import io.hops.hopsworks.common.util.QRCodeGenerator;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.BbcGroup;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.audit.AccountAudit;
import io.hops.hopsworks.persistence.entity.user.security.audit.RolesAudit;
import io.hops.hopsworks.persistence.entity.user.security.ua.UserAccountStatus;
import io.hops.hopsworks.persistence.entity.user.security.ua.UserAccountType;
import io.hops.hopsworks.persistence.entity.user.security.ua.ValidationKeyType;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class UsersController {
    private static final Logger LOGGER = Logger.getLogger(UsersController.class.getName());
    @EJB
    private UserFacade userFacade;
    @EJB
    private AccountAuditFacade accountAuditFacade;
    @EJB
    private RolesAuditFacade rolesAuditFacade;
    @EJB
    private BbcGroupFacade bbcGroupFacade;
    @EJB
    private UserValidator userValidator;
    @EJB
    private EmailBean emailBean;
    @EJB
    private Settings settings;
    @EJB
    private AuthController authController;
    @EJB
    private SecurityUtils securityUtils;
    @EJB
    private UserStatusValidator userStatusValidator;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @Inject
    @Any
    private Instance<UserAccountHandler> userAccountHandlers;

    public QrCode registerUser(UserDTO newUser, String validationKeyUrl) throws UserException {
        QrCode qrCode;
        if (newUser.getEmail() != null && !newUser.getEmail().isEmpty()) {
            newUser.setEmail(newUser.getEmail().toLowerCase());
        }
        this.userValidator.isValidNewUser(newUser);
        if (!Strings.isNullOrEmpty((String)this.settings.getTwoFactorAuth()) && Settings.TwoFactorMode.MANDATORY.getName().equals(this.settings.getTwoFactorAuth())) {
            newUser.setTwoFactor(true);
        }
        newUser.setMaxNumProjects(0);
        Users user = this.createNewUser(newUser, UserAccountStatus.NEW_MOBILE_ACCOUNT, UserAccountType.M_ACCOUNT_TYPE);
        try {
            if (!newUser.isTestUser()) {
                this.authController.sendEmailValidationKey(user, user.getValidationKey(), validationKeyUrl);
            }
            this.userFacade.persist(user);
            UserAccountHandler.runUserAccountCreateHandlers(this.userAccountHandlers, user);
            qrCode = this.getQRCode(user);
        }
        catch (MessagingException ex) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_REGISTRATION_ERROR, Level.SEVERE, "user: " + newUser.getUsername(), ex.getMessage(), (Throwable)ex);
        }
        return qrCode;
    }

    public Users registerUser(UserDTO newUser, String role, UserAccountStatus accountStatus, UserAccountType accountType) throws UserException {
        if (!Strings.isNullOrEmpty((String)newUser.getEmail())) {
            newUser.setEmail(newUser.getEmail().toLowerCase());
        }
        this.userValidator.isValidEmail(newUser.getEmail());
        if (this.userFacade.findByEmail(newUser.getEmail()) != null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_EXISTS, Level.FINE);
        }
        Users user = this.createNewUser(newUser, accountStatus, accountType);
        BbcGroup group = this.bbcGroupFacade.findByGroupName(role);
        if (group != null) {
            user.getBbcGroupCollection().add(group);
        }
        this.userFacade.persist(user);
        UserAccountHandler.runUserAccountCreateHandlers(this.userAccountHandlers, user);
        return user;
    }

    public void addRole(String role, Integer id) throws UserException {
        Users p = (Users)this.userFacade.find(id);
        BbcGroup bbcGroup = this.bbcGroupFacade.findByGroupName(role);
        if (bbcGroup == null) {
            throw new UserException(RESTCodes.UserErrorCode.ROLE_NOT_FOUND, Level.FINE, "Role could not be granted.");
        }
        this.registerGroup(p, bbcGroup.getGid());
        UserAccountHandler.runUserAccountUpdateHandlers(this.userAccountHandlers, p);
    }

    public void removeRole(String role, Integer id) throws UserException {
        Users p = (Users)this.userFacade.find(id);
        BbcGroup bbcGroup = this.bbcGroupFacade.findByGroupName(role);
        if (bbcGroup != null && p.getBbcGroupCollection().contains(bbcGroup)) {
            this.userFacade.removeGroup(p.getEmail(), bbcGroup.getGid());
            p.getBbcGroupCollection().remove(bbcGroup);
        } else if (bbcGroup != null) {
            throw new UserException(RESTCodes.UserErrorCode.ROLE_NOT_FOUND, Level.FINE, "Role could not be granted.");
        }
        UserAccountHandler.runUserAccountUpdateHandlers(this.userAccountHandlers, p);
    }

    public void sendConfirmationMail(Users user) throws ServiceException {
        try {
            this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, "Welcome to Hopsworks!", UserAccountsEmailMessages.accountActivatedMessage(user.getEmail()));
        }
        catch (MessagingException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.EMAIL_SENDING_FAILURE, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
    }

    public void sendRejectionEmail(Users user) throws ServiceException {
        try {
            this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, "Your Hopsworks account request has been rejected", UserAccountsEmailMessages.accountRejectedMessage());
        }
        catch (MessagingException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.EMAIL_SENDING_FAILURE, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
    }

    public Users resendAccountVerificationEmail(Users user, String linkUrl) throws ServiceException {
        try {
            this.authController.sendNewValidationKey(user, linkUrl);
            return user;
        }
        catch (MessagingException e) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.EMAIL_SENDING_FAILURE, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
    }

    public Users createNewUser(UserDTO newUser, UserAccountStatus accountStatus, UserAccountType accountType) {
        String otpSecret = this.securityUtils.calculateSecretKey();
        String activationKey = this.securityUtils.generateSecureRandomString();
        String uname = this.generateUsername(newUser.getEmail());
        ArrayList groups = new ArrayList();
        Secret secret = this.securityUtils.generateSecret(newUser.getChosenPassword());
        Timestamp now = new Timestamp(new Date().getTime());
        int maxNumProjects = newUser.getMaxNumProjects() > 0 ? newUser.getMaxNumProjects() : this.settings.getMaxNumProjPerUser().intValue();
        Users user = new Users(uname, secret.getSha256HexDigest(), newUser.getEmail(), newUser.getFirstName(), newUser.getLastName(), (Date)now, "-", accountStatus, otpSecret, activationKey, (Date)now, ValidationKeyType.EMAIL, accountType, (Date)now, Integer.valueOf(maxNumProjects), newUser.isTwoFactor(), secret.getSalt(), newUser.getToursState());
        user.setBbcGroupCollection(groups);
        return user;
    }

    public Users createNewRemoteUser(String email, String fname, String lname, String pwd, UserAccountStatus accStatus) {
        String uname = this.generateUsername(email);
        ArrayList groups = new ArrayList();
        Secret secret = this.securityUtils.generateSecret(pwd);
        Users user = new Users(uname, secret.getSha256HexDigest(), email, fname, lname, (Date)new Timestamp(new Date().getTime()), "-", accStatus, UserAccountType.REMOTE_ACCOUNT_TYPE, (Date)new Timestamp(new Date().getTime()), this.settings.getMaxNumProjPerUser(), secret.getSalt());
        user.setBbcGroupCollection(groups);
        return user;
    }

    public void sendQRRecoveryEmail(String email, String password, String reqUrl) throws UserException, MessagingException {
        Users user = this.userFacade.findByEmail(email);
        if (!this.authController.checkUserPasswordAndStatus(user, password)) {
            throw new UserException(RESTCodes.UserErrorCode.INCORRECT_CREDENTIALS, Level.FINE);
        }
        if (!this.authController.isTwoFactorEnabled(user)) {
            throw new UserException(RESTCodes.UserErrorCode.TWO_FA_DISABLED, Level.FINE);
        }
        this.authController.sendNewRecoveryValidationKey(user, reqUrl, false);
    }

    public void sendPasswordRecoveryEmail(String email, String reqUrl) throws UserException, MessagingException {
        Users user = this.userFacade.findByEmail(email);
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        try {
            this.userStatusValidator.checkStatus(user.getStatus());
        }
        catch (UserException e) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_NOT_ACTIVE, Level.FINE, e.getErrorCode().getMessage());
        }
        this.authController.sendNewRecoveryValidationKey(user, reqUrl, true);
    }

    public byte[] recoverQRCodeByte(String key) throws UserException, MessagingException {
        Users user = this.sendQRCodeRecoverEmail(key);
        return this.resetQRCodeByte(user);
    }

    public QrCode recoverQRCode(String key) throws UserException, MessagingException {
        Users user = this.sendQRCodeRecoverEmail(key);
        return this.resetQRCode(user);
    }

    private Users sendQRCodeRecoverEmail(String key) throws UserException, MessagingException {
        Users user = this.authController.validateRecoveryKey(key, ValidationKeyType.QR_RESET);
        if (!this.authController.isTwoFactorEnabled(user)) {
            throw new UserException(RESTCodes.UserErrorCode.TWO_FA_DISABLED, Level.FINE);
        }
        this.authController.resetValidationKey(user);
        String subject = "Your QR code has been reset";
        String msg = UserAccountsEmailMessages.buildQRResetMessage();
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
        return user;
    }

    public QrCode resetQRCode(Users user, String password) throws UserException {
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_DOES_NOT_EXIST, Level.FINE);
        }
        if (!this.authController.validatePassword(user, password)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        if (!this.authController.isTwoFactorEnabled(user)) {
            throw new UserException(RESTCodes.UserErrorCode.TWO_FA_DISABLED, Level.FINE);
        }
        return this.resetQRCode(user);
    }

    private QrCode resetQRCode(Users user) throws UserException {
        this.updateUserSecret(user);
        return this.getQRCode(user);
    }

    private byte[] resetQRCodeByte(Users user) throws UserException {
        this.updateUserSecret(user);
        try {
            return QRCodeGenerator.getQRCodeBytes(user.getEmail(), "hops.io", user.getSecret());
        }
        catch (WriterException | IOException e) {
            throw new UserException(RESTCodes.UserErrorCode.FAILED_TO_GENERATE_QR_CODE, Level.FINE);
        }
    }

    private void updateUserSecret(Users user) {
        String random = this.securityUtils.calculateSecretKey();
        this.updateSecret(user, random);
    }

    public void changePassword(Users user, String oldPassword, String newPassword, String confirmedPassword) throws UserException {
        if (!this.authController.validatePassword(user, oldPassword)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        if (UserAccountStatus.TEMP_PASSWORD.equals((Object)user.getStatus())) {
            user.setStatus(UserAccountStatus.ACTIVATED_ACCOUNT);
        }
        this.changePassword(user, newPassword, confirmedPassword);
    }

    public void checkRecoveryKey(String key) throws UserException {
        this.authController.checkRecoveryKey(key);
    }

    public void validateKey(String key) throws UserException {
        this.authController.validateEmail(key);
    }

    public String resetPassword(Integer id, String initiator) throws UserException, MessagingException {
        Users user = (Users)this.userFacade.find(id);
        if (!user.getMode().equals((Object)UserAccountType.M_ACCOUNT_TYPE)) {
            throw new UserException(RESTCodes.UserErrorCode.OPERATION_NOT_ALLOWED, Level.FINE, "Can not reset password of a remote user");
        }
        String randomPwd = this.securityUtils.generateRandomString(8);
        user.setStatus(UserAccountStatus.TEMP_PASSWORD);
        this.changePasswordAsAdmin(user, randomPwd);
        String subject = "Your password has been reset";
        String msg = UserAccountsEmailMessages.buildResetByAdminMessage(initiator);
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
        return randomPwd;
    }

    public void changePassword(String key, String newPassword, String confirmedPassword) throws UserException, MessagingException {
        this.userValidator.isValidPassword(newPassword, confirmedPassword);
        Users user = this.authController.validateRecoveryKey(key, ValidationKeyType.PASSWORD_RESET);
        this.changePassword(user, newPassword, confirmedPassword);
        this.authController.resetValidationKey(user);
        String subject = "Your password has been reset";
        String msg = UserAccountsEmailMessages.buildResetMessage();
        this.emailBean.sendEmail(user.getEmail(), Message.RecipientType.TO, subject, msg);
    }

    private void changePassword(Users user, String newPassword, String confirmedPassword) throws UserException {
        if (this.userValidator.isValidPassword(newPassword, confirmedPassword)) {
            try {
                Secret secret = this.securityUtils.generateSecret(newPassword);
                this.authController.changePassword(user, secret);
            }
            catch (Exception ex) {
                throw new UserException(RESTCodes.UserErrorCode.PASSWORD_RESET_UNSUCCESSFUL, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void changePasswordAsAdmin(Users user, String newPassword) throws UserException {
        try {
            Secret secret = this.securityUtils.generateSecret(newPassword);
            this.authController.changeUserPasswordAsAdmin(user, secret);
        }
        catch (Exception ex) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_RESET_UNSUCCESSFUL, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
        }
    }

    public Users updateProfile(Users user, String firstName, String lastName, Integer toursState) throws UserException {
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        if (firstName != null) {
            user.setFname(firstName);
        }
        if (lastName != null) {
            user.setLname(lastName);
        }
        if (toursState != null) {
            user.setToursState(toursState.intValue());
        }
        this.userFacade.update(user);
        return user;
    }

    public String generateUsername(String email) {
        int count;
        if (email == null) {
            throw new IllegalArgumentException("Email is null");
        }
        String emailUsername = email.substring(0, email.lastIndexOf("@")).toLowerCase();
        String baseUsername = emailUsername.replaceAll("[^a-z0-9]", "");
        baseUsername = baseUsername.length() <= 8 ? baseUsername + StringUtils.repeat((String)"0", (int)(8 - baseUsername.length())) : baseUsername.substring(0, 8);
        Users user = this.userFacade.findByUsername(baseUsername);
        if (user == null) {
            return baseUsername;
        }
        String testUname = "";
        String suffix = "";
        for (count = 1; user != null && count < 1000; ++count) {
            suffix = String.valueOf(count);
            testUname = baseUsername.substring(0, 8 - suffix.length());
            user = this.userFacade.findByUsername(testUname + suffix);
        }
        if (count == 1000) {
            throw new IllegalStateException("You cannot register with this email address. Pick another.");
        }
        return testUname + suffix;
    }

    public Optional<Users> findByUsername(String username) {
        Users user = this.userFacade.findByUsername(username);
        if (user != null) {
            return Optional.of(user);
        }
        return Optional.empty();
    }

    public QrCode changeTwoFactor(Users user, String password) throws UserException {
        if (user == null) {
            throw new IllegalArgumentException("User was not provided.");
        }
        if (!this.authController.validatePassword(user, password)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        if (!user.getTwoFactor()) {
            user.setTwoFactor(true);
            this.userFacade.update(user);
            return this.getQRCode(user);
        }
        user.setTwoFactor(false);
        this.userFacade.update(user);
        return null;
    }

    public QrCode getQRCode(Users user, String password) throws UserException {
        if (user == null) {
            throw new IllegalArgumentException("User was not provided");
        }
        if (!this.authController.validatePassword(user, password)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_INCORRECT, Level.FINE);
        }
        if (!this.authController.isTwoFactorEnabled(user)) {
            throw new UserException(RESTCodes.UserErrorCode.TWO_FA_DISABLED, Level.FINE);
        }
        return this.getQRCode(user);
    }

    private QrCode getQRCode(Users user) throws UserException {
        try {
            byte[] img = QRCodeGenerator.getQRCodeBytes(user.getEmail(), "hops.io", user.getSecret());
            return new QrCode(img, user.getSecret(), "hops.io", user.getEmail());
        }
        catch (WriterException | IOException e) {
            throw new UserException(RESTCodes.UserErrorCode.FAILED_TO_GENERATE_QR_CODE, Level.FINE);
        }
    }

    public void registerGroup(Users uid, int gidNumber) {
        BbcGroup bbcGroup = (BbcGroup)this.bbcGroupFacade.find(gidNumber);
        uid.getBbcGroupCollection().add(bbcGroup);
        this.userFacade.update(uid);
    }

    public void changeAccountStatus(int id, String note, UserAccountStatus status) throws UserException {
        Users p = (Users)this.userFacade.find(id);
        if (p != null) {
            if (UserAccountStatus.ACTIVATED_ACCOUNT.equals((Object)status)) {
                p.setFalseLogin(0);
                if (p.getBbcGroupCollection() == null || p.getBbcGroupCollection().isEmpty()) {
                    BbcGroup group = this.bbcGroupFacade.findByGroupName("HOPS_USER");
                    ArrayList<BbcGroup> groups = new ArrayList<BbcGroup>();
                    groups.add(group);
                    p.setBbcGroupCollection(groups);
                }
            }
            p.setNotes(note);
            p.setStatus(status);
            this.userFacade.update(p);
            UserAccountHandler.runUserAccountUpdateHandlers(this.userAccountHandlers, p);
            try {
                this.emailBean.sendEmail(p.getEmail(), Message.RecipientType.TO, "Your Hopsworks account status was changed", UserAccountsEmailMessages.accountStatusChangeMessage(status.getUserStatus()));
            }
            catch (MessagingException messagingException) {}
        } else {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
    }

    public void updateSecret(Users user, String sec) {
        user.setSecret(sec);
        this.userFacade.update(user);
    }

    public void increaseNumCreatedProjects(int id) {
        Users u = (Users)this.userFacade.find(id);
        u.setNumCreatedProjects(Integer.valueOf(u.getNumCreatedProjects() + 1));
        this.userFacade.update(u);
    }

    public void decrementNumProjectsCreated(int id) {
        Users u = (Users)this.userFacade.find(id);
        int n = u.getNumCreatedProjects();
        if (n > 0) {
            u.setNumCreatedProjects(Integer.valueOf(n - 1));
            this.userFacade.update(u);
        }
    }

    public void updateNumActiveProjects(Integer id) {
        Users u;
        List<Project> projects = this.projectFacade.findByUser(u = (Users)this.userFacade.find(id));
        u.setNumActiveProjects(Integer.valueOf(projects != null ? projects.size() : 0));
        this.userFacade.update(u);
    }

    public boolean isUsernameTaken(String username) {
        return this.userFacade.findByEmail(username) != null;
    }

    public boolean isUserInRole(Users user, String groupName) {
        if (user == null || groupName == null) {
            return false;
        }
        BbcGroup group = this.bbcGroupFacade.findByGroupName(groupName);
        if (group == null) {
            return false;
        }
        return user.getBbcGroupCollection().contains(group);
    }

    public List<String> getUserRoles(Users p) {
        Collection groupList = p.getBbcGroupCollection();
        ArrayList<String> list = new ArrayList<String>();
        for (BbcGroup g : groupList) {
            list.add(g.getGroupName());
        }
        return list;
    }

    public void updateMaxNumProjs(Integer id, int maxNumProjs) {
        Users user = (Users)this.userFacade.find(id);
        user.setMaxNumProjects(Integer.valueOf(maxNumProjs));
        this.userFacade.update(user);
    }

    public void deleteUser(Users u) throws UserException {
        if (u != null) {
            List<AccountAudit> resultsAA;
            List<RolesAudit> rolesAuditInitiator = this.rolesAuditFacade.findByInitiatorNotTarget(u);
            if (rolesAuditInitiator != null && rolesAuditInitiator.size() > 0) {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_DELETION_ERROR, Level.FINE, "User that initiated roles audit log on another account can not be deleted.");
            }
            List<AccountAudit> accountAuditInitiator = this.accountAuditFacade.findByInitiatorNotTarget(u);
            if (accountAuditInitiator != null && accountAuditInitiator.size() > 0) {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_DELETION_ERROR, Level.FINE, "User that initiated account audit log on another account can not be deleted.");
            }
            List<RolesAudit> results = this.rolesAuditFacade.findByTarget(u);
            if (results != null) {
                for (RolesAudit rolesAudit : results) {
                    this.rolesAuditFacade.remove(rolesAudit);
                }
            }
            if ((resultsAA = this.accountAuditFacade.findByTarget(u)) != null) {
                for (AccountAudit next : resultsAA) {
                    this.accountAuditFacade.remove(next);
                }
            }
            UserAccountHandler.runUserAccountDeleteHandlers(this.userAccountHandlers, u);
            try {
                this.userFacade.removeByEmail(u.getEmail());
            }
            catch (ConstraintViolationException constraintViolationException) {
                throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_DELETION_ERROR, Level.FINE, "User that initiated audit log on another account can not be deleted.", constraintViolationException.getMessage());
            }
        }
    }

    public void deleteUser(Integer id) throws UserException {
        Users user = this.getUserById(id);
        List<Project> projects = this.projectFacade.findByUser(user);
        if (projects != null && !projects.isEmpty()) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_DELETION_ERROR, Level.FINE, "Can not delete a user that owns a project. Delete the project first and try again.");
        }
        if (this.projectTeamFacade.countByMember(user) > 0) {
            throw new UserException(RESTCodes.UserErrorCode.ACCOUNT_DELETION_ERROR, Level.FINE, "Can not delete a user that is a member of a project. Remove the user from all projects and try again.");
        }
        this.deleteUser(user);
    }

    public Users getUserById(Integer id) throws UserException {
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        Users user = (Users)this.userFacade.find(id);
        if (user == null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_WAS_NOT_FOUND, Level.FINE);
        }
        return user;
    }
}

