/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.util;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.persistence.entity.jobs.configuration.DockerJobConfiguration;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.serving.DockerResourcesConfiguration;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProjectUtils {
    @EJB
    private Settings settings;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    private static final Logger LOGGER = Logger.getLogger(ProjectUtils.class.getName());

    public boolean isReservedProjectName(String projectName) {
        for (String name : this.settings.getReservedProjectNames()) {
            if (!name.equalsIgnoreCase(projectName)) continue;
            return true;
        }
        return false;
    }

    public boolean isOldDockerImage(String dockerImage) throws ProjectException {
        Pattern versionPattern = Pattern.compile("(\\d+[.]\\d+[.]\\d+)");
        Matcher projectDockerImageMatcher = versionPattern.matcher(dockerImage);
        String hopsworksVersion = this.settings.getHopsworksVersion();
        Matcher installationVersionMatcher = versionPattern.matcher(hopsworksVersion);
        if (!projectDockerImageMatcher.find()) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_DOCKER_VERSION_EXTRACT_ERROR, Level.SEVERE, "dockerImage: " + dockerImage + " version: " + hopsworksVersion);
        }
        if (!installationVersionMatcher.find()) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_DOCKER_VERSION_EXTRACT_ERROR, Level.SEVERE, "dockerImage: " + dockerImage + " version: " + hopsworksVersion);
        }
        String[] projectDockerImageParts = projectDockerImageMatcher.group().split("\\.");
        String[] installationDockerImageParts = installationVersionMatcher.group().split("\\.");
        for (int i = 0; i < installationDockerImageParts.length; ++i) {
            if (Integer.parseInt(installationDockerImageParts[i]) <= Integer.parseInt(projectDockerImageParts[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isBaseDockerImage(String image) {
        Pattern basePattern = Pattern.compile("^(base:\\d+[.]\\d+[.]\\d+(|-SNAPSHOT))$");
        Matcher baseMatcher = basePattern.matcher(image);
        return baseMatcher.matches();
    }

    private boolean isPythonDockerImage(String image) {
        if (this.settings.isManagedDockerRegistry().booleanValue()) {
            Pattern pythonPattern = Pattern.compile("^(base:python\\d{2}_\\d+[.]\\d+[.]\\d+(|-SNAPSHOT))$");
            Matcher pythonMatcher = pythonPattern.matcher(image);
            return pythonMatcher.matches();
        }
        Pattern pythonPattern = Pattern.compile("^(python\\d{2}:\\d+[.]\\d+[.]\\d+(|-SNAPSHOT))$");
        Matcher pythonMatcher = pythonPattern.matcher(image);
        return pythonMatcher.matches();
    }

    public boolean dockerImageIsPreinstalled(String image) {
        return ProjectUtils.isBaseDockerImage(image) || this.isPythonDockerImage(image);
    }

    public String getFullDockerImageName(Project project, boolean useBase) throws ServiceDiscoveryException {
        return ProjectUtils.getFullDockerImageName(project, this.settings, this.serviceDiscoveryController, useBase);
    }

    public static String getFullDockerImageName(Project project, Settings settings, ServiceDiscoveryController serviceDiscoveryController, boolean useBase) throws ServiceDiscoveryException {
        String imageName = ProjectUtils.getDockerImageName(project, settings, useBase);
        return ProjectUtils.getRegistryURL(settings, serviceDiscoveryController) + "/" + imageName;
    }

    public static String getDockerImageName(Project project, Settings settings, boolean useBase) {
        if (project.getPythonEnvironment() != null && (useBase || Strings.isNullOrEmpty((String)project.getDockerImage()))) {
            return settings.getBaseDockerImagePythonName();
        }
        if (project.getPythonEnvironment() == null && ProjectUtils.isBaseDockerImage(project.getDockerImage())) {
            return project.getDockerImage();
        }
        if (project.getPythonEnvironment() == null) {
            throw new IllegalArgumentException("Error. Python has not been enabled for this project.");
        }
        return project.getDockerImage();
    }

    public String getFullDockerImageName(String imageName) throws ServiceDiscoveryException {
        return ProjectUtils.getRegistryURL(this.settings, this.serviceDiscoveryController) + "/" + imageName;
    }

    public String getRegistryURL() throws ServiceDiscoveryException {
        return ProjectUtils.getRegistryURL(this.settings, this.serviceDiscoveryController);
    }

    public static String getRegistryURL(Settings settings, ServiceDiscoveryController serviceDiscoveryController) throws ServiceDiscoveryException {
        Service registry = serviceDiscoveryController.getAnyAddressOfServiceWithDNSSRVOnly(ServiceDiscoveryController.HopsworksService.REGISTRY);
        if (settings.isManagedDockerRegistry().booleanValue()) {
            String registryUrl = registry.getAddress();
            String dockerNamespace = settings.getDockerNamespace();
            if (!dockerNamespace.isEmpty()) {
                registryUrl = registryUrl + "/" + dockerNamespace;
            }
            return registryUrl;
        }
        return registry.getName() + ":" + registry.getPort();
    }

    public String getInitialDockerImageName(Project project) {
        String initialImageTag = System.currentTimeMillis() + "-" + this.settings.getHopsworksVersion() + ".0";
        if (this.settings.isManagedDockerRegistry().booleanValue()) {
            return this.settings.getBaseNonPythonDockerImageWithNoTag() + ":" + project.getName().toLowerCase() + "_" + initialImageTag;
        }
        return project.getName().toLowerCase() + ":" + initialImageTag;
    }

    public String getFullBaseImageName() throws ServiceDiscoveryException {
        return ProjectUtils.getRegistryURL(this.settings, this.serviceDiscoveryController) + "/" + this.settings.getBaseDockerImagePythonName();
    }

    public String getProjectNameFromDockerImageName(String imageName) {
        if (this.settings.isManagedDockerRegistry().booleanValue()) {
            return imageName.split(":")[1].split("_")[0];
        }
        return this.getProjectDockerRepoName(imageName);
    }

    public String getProjectDockerRepoName(String imageName) {
        return imageName.split(":")[0];
    }

    public DockerJobConfiguration buildDockerJobConfiguration() {
        DockerJobConfiguration dockerConfig = new DockerJobConfiguration();
        dockerConfig.setResourceConfig(this.buildDockerResourceConfig());
        return dockerConfig;
    }

    public DockerResourcesConfiguration buildDockerResourceConfig() {
        DockerResourcesConfiguration dockerResourceConfig = new DockerResourcesConfiguration();
        int defaultMemory = dockerResourceConfig.getMemory();
        Integer userKubeMaxMem = this.settings.getKubeDockerMaxMemoryAllocation();
        if (userKubeMaxMem < defaultMemory) {
            dockerResourceConfig.setMemory(userKubeMaxMem.intValue());
        }
        return dockerResourceConfig;
    }
}

