/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.core;

import io.hops.hopsworks.common.provenance.core.ProvenanceCleanerController;
import io.hops.hopsworks.common.util.Settings;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.javatuples.Pair;

@Singleton
@Startup
@DependsOn(value={"Settings"})
public class ProvenanceCleaner {
    private static final Logger LOGGER = Logger.getLogger(ProvenanceCleaner.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private ProvenanceCleanerController cleanerCtrl;
    @Resource
    TimerService timerService;
    private String lastIndexChecked = "";

    @PostConstruct
    private void init() {
        long cleanerPeriod = this.settings.getProvCleanerPeriod();
        LOGGER.log(Level.INFO, "timer - provenance cleaner - period:{0}s", cleanerPeriod);
        this.timerService.createTimer(cleanerPeriod * 1000L, cleanerPeriod * 1000L, (Serializable)((Object)"Timer for provenance cleaner."));
    }

    @PreDestroy
    private void destroyTimer() {
        for (Timer timer : this.timerService.getTimers()) {
            timer.cancel();
        }
    }

    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    private void timeout(Timer timer) {
        int cleanupSize = this.settings.getProvCleanupSize();
        if (cleanupSize == 0) {
            return;
        }
        try {
            Pair<Integer, String> round = this.cleanerCtrl.indexCleanupRound(this.lastIndexChecked, cleanupSize);
            LOGGER.log(Level.FINE, "cleanup round - idx cleaned:{0} from:{1} to:{2}", new Object[]{round.getValue0(), this.lastIndexChecked, round.getValue1()});
            this.lastIndexChecked = (String)round.getValue1();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "cleanup round was not successful - error", e);
        }
    }
}

