/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security.utils;

import org.apache.commons.codec.digest.DigestUtils;

public final class Secret {
    private static final String KEY_ID_SEPARATOR = ".";
    public static final String KEY_ID_SEPARATOR_REGEX = "\\.";
    private final String prefix;
    private final String secret;
    private final String salt;
    private final int prefixMinLength;
    private final int secretMinLength;
    private final int saltMinLength;
    private final boolean prefixed;

    public Secret(String prefix, String secret, String salt, int prefixMinLength, int secretMinLength, int saltMinLength) {
        this.prefix = prefix;
        this.secret = secret;
        this.salt = salt;
        this.prefixMinLength = prefixMinLength;
        this.secretMinLength = secretMinLength;
        this.saltMinLength = saltMinLength;
        this.prefixed = true;
    }

    public Secret(String prefix, String secret, String salt) {
        this.prefix = prefix;
        this.secret = secret;
        this.salt = salt;
        this.prefixMinLength = 0;
        this.secretMinLength = 0;
        this.saltMinLength = 0;
        this.prefixed = true;
    }

    public Secret(String secret, String salt, int secretMinLength, int saltMinLength) {
        this.prefix = "";
        this.secret = secret;
        this.salt = salt;
        this.prefixMinLength = 0;
        this.secretMinLength = secretMinLength;
        this.saltMinLength = saltMinLength;
        this.prefixed = false;
    }

    public Secret(String secret, String salt) {
        this.prefix = "";
        this.secret = secret;
        this.salt = salt;
        this.prefixMinLength = 0;
        this.secretMinLength = 0;
        this.saltMinLength = 0;
        this.prefixed = false;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getSecretPlusSalt() {
        return this.secret + this.salt;
    }

    public int getPrefixMinLength() {
        return this.prefixMinLength;
    }

    public int getSecretMinLength() {
        return this.secretMinLength;
    }

    public int getSaltMinLength() {
        return this.saltMinLength;
    }

    public boolean isPrefixed() {
        return this.prefixed;
    }

    public String getPrefixPlusSecret() {
        return this.prefix + KEY_ID_SEPARATOR + this.secret;
    }

    public String getSha256HexDigest() {
        String secPlusSalt = this.getSecretPlusSalt();
        return DigestUtils.sha256Hex((String)secPlusSalt);
    }

    public String getSha512HexDigest() {
        String secPlusSalt = this.getSecretPlusSalt();
        return DigestUtils.sha512Hex((String)secPlusSalt);
    }

    public String getSha1HexDigest() {
        String secPlusSalt = this.getSecretPlusSalt();
        return DigestUtils.sha1Hex((String)secPlusSalt);
    }

    public boolean validateNotNullOrEmpty() {
        if (this.prefixed) {
            return this.prefix != null && !this.prefix.isEmpty() && this.secret != null && !this.secret.isEmpty() && this.salt != null && !this.salt.isEmpty();
        }
        return this.secret != null && !this.secret.isEmpty() && this.salt != null && !this.salt.isEmpty();
    }

    public boolean validateSize() {
        boolean notNullOrEmpty = this.validateNotNullOrEmpty();
        if (this.prefixed) {
            return notNullOrEmpty && this.prefix.length() >= this.prefixMinLength && this.secret.length() >= this.secretMinLength && this.salt.length() >= this.saltMinLength;
        }
        return notNullOrEmpty && this.secret.length() >= this.secretMinLength && this.salt.length() >= this.saltMinLength;
    }
}

