/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.provenance.app;

import com.lambdista.util.Try;
import io.hops.hopsworks.common.opensearch.OpenSearchClientController;
import io.hops.hopsworks.common.provenance.app.dto.ProvAppStateOpenSearch;
import io.hops.hopsworks.common.provenance.core.ProvParser;
import io.hops.hopsworks.common.provenance.core.Provenance;
import io.hops.hopsworks.common.provenance.core.opensearch.BasicOpenSearchHit;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchHelper;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchHits;
import io.hops.hopsworks.common.provenance.util.ProvHelper;
import io.hops.hopsworks.common.provenance.util.functional.CheckedFunction;
import io.hops.hopsworks.common.provenance.util.functional.CheckedSupplier;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.javatuples.Pair;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.sort.SortOrder;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ProvAppController {
    @EJB
    private Settings settings;
    @EJB
    private OpenSearchClientController client;

    public Map<String, Map<Provenance.AppState, ProvAppStateOpenSearch>> provAppState(Map<ProvParser.Field, ProvParser.FilterVal> filterBy) throws ProvenanceException {
        return this.provAppState(filterBy, new LinkedList<Pair<ProvParser.Field, SortOrder>>(), 0, Settings.PROVENANCE_OPENSEARCH_PAGE_DEFAULT_SIZE);
    }

    public Map<String, Map<Provenance.AppState, ProvAppStateOpenSearch>> provAppState(Map<ProvParser.Field, ProvParser.FilterVal> filterBy, List<Pair<ProvParser.Field, SortOrder>> sortBy, Integer offset, Integer limit) throws ProvenanceException {
        Pair<Long, Try<OpenSearchAppStatesObj>> searchResult;
        CheckedSupplier<SearchRequest, ProvenanceException> srF = OpenSearchHelper.scrollingSearchRequest("app_provenance", this.settings.getOpenSearchDefaultScrollPageSize()).andThen(this.provAppStateQB(filterBy)).andThen(OpenSearchHelper.sortBy(sortBy)).andThen(OpenSearchHelper.withPagination(offset, limit, this.settings.getOpenSearchMaxScrollPageSize().intValue()));
        SearchRequest request = srF.get();
        try {
            searchResult = this.client.searchScrolling(request, OpenSearchAppStatesObj.getHandler());
        }
        catch (OpenSearchException e) {
            String msg = "provenance - opensearch query problem";
            throw ProvHelper.fromOpenSearch(e, msg, msg + " - app state");
        }
        return OpenSearchAppStatesObj.checkedResult(searchResult);
    }

    private CheckedFunction<SearchRequest, SearchRequest, ProvenanceException> provAppStateQB(Map<ProvParser.Field, ProvParser.FilterVal> filterBy) {
        return sr -> {
            BoolQueryBuilder query = QueryBuilders.boolQuery();
            query = OpenSearchHelper.filterByBasicFields(query, filterBy);
            sr.source().query((QueryBuilder)query);
            return sr;
        };
    }

    private static class OpenSearchAppStatesObj
    extends HashMap<String, Map<Provenance.AppState, ProvAppStateOpenSearch>> {
        private OpenSearchAppStatesObj() {
        }

        private static OpenSearchHits.Merger<ProvAppStateOpenSearch, OpenSearchAppStatesObj> getMerger() {
            return (item, states) -> {
                Map appIdStates = states.computeIfAbsent(item.getAppId(), key -> new TreeMap());
                appIdStates.put(item.getAppState(), item);
                return Try.apply(() -> states);
            };
        }

        static OpenSearchHits.Handler<ProvAppStateOpenSearch, OpenSearchAppStatesObj> getHandler() {
            OpenSearchHits.Parser parser = hit -> ProvAppStateOpenSearch.tryInstance(BasicOpenSearchHit.instance(hit));
            return OpenSearchHits.handlerBasic(parser, new OpenSearchAppStatesObj(), OpenSearchAppStatesObj.getMerger());
        }

        static Map<String, Map<Provenance.AppState, ProvAppStateOpenSearch>> checkedResult(Pair<Long, Try<OpenSearchAppStatesObj>> result) throws ProvenanceException {
            try {
                return (Map)((Try)result.getValue1()).checkedGet();
            }
            catch (Throwable t) {
                if (t instanceof ProvenanceException) {
                    throw (ProvenanceException)t;
                }
                throw new ProvenanceException(RESTCodes.ProvenanceErrorCode.INTERNAL_ERROR, Level.INFO, "unhandled error", "unhandled error", t);
            }
        }
    }
}

