/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.online;

import io.hops.hopsworks.common.featurestore.feature.FeatureGroupFeatureDTO;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.sql.DataSource;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class OnlineFeaturestoreFacade {
    private static final Logger LOGGER = Logger.getLogger(OnlineFeaturestoreFacade.class.getName());
    @Resource(name="jdbc/featurestore")
    private DataSource featureStoreDataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Double getDbSize(String dbName) {
        try (ResultSet resultSet = null;
             Connection connection = this.featureStoreDataSource.getConnection();
             PreparedStatement pStmt = connection.prepareStatement("SELECT ROUND(SUM(`tables`.`data_length` + `index_length`) / 1024 / 1024, 1) AS 'size_mb' FROM information_schema.`tables` WHERE `tables`.`table_schema`=? GROUP BY `tables`.`table_schema`");){
            pStmt.setString(1, dbName);
            resultSet = pStmt.executeQuery();
            if (!resultSet.next()) return 0.0;
            Double d = resultSet.getDouble("size_mb");
            return d;
        }
        catch (SQLException se) {
            LOGGER.log(Level.SEVERE, "Could not get database size", se);
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FeatureGroupFeatureDTO> getMySQLFeatures(String tableName, String db) throws FeaturestoreException {
        ArrayList<FeatureGroupFeatureDTO> featureGroupFeatureDTOS = new ArrayList<FeatureGroupFeatureDTO>();
        try (ResultSet resultSet = null;
             Connection connection = this.featureStoreDataSource.getConnection();
             PreparedStatement pStmt = connection.prepareStatement("SELECT `COLUMNS`.`COLUMN_NAME`,`COLUMNS`.`COLUMN_TYPE`, `COLUMNS`.`COLUMN_COMMENT` FROM INFORMATION_SCHEMA.`COLUMNS` WHERE `COLUMNS`.`TABLE_NAME`=? AND `COLUMNS`.`TABLE_SCHEMA`=?;");){
            pStmt.setString(1, tableName);
            pStmt.setString(2, db);
            resultSet = pStmt.executeQuery();
            while (resultSet.next()) {
                featureGroupFeatureDTOS.add(new FeatureGroupFeatureDTO(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3)));
            }
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_ONLINE_FEATURES, Level.SEVERE, "Error reading features from schema", se.getMessage(), (Throwable)se);
        }
        return featureGroupFeatureDTOS;
    }

    public void createOnlineFeaturestoreDatabase(String db) throws FeaturestoreException {
        try {
            this.executeUpdate("CREATE DATABASE " + db + ";");
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_CREATING_ONLINE_FEATURESTORE_DB, Level.SEVERE, "Error running create query", se.getMessage(), (Throwable)se);
        }
    }

    public void removeOnlineFeaturestoreDatabase(String db) throws FeaturestoreException {
        try {
            this.executeUpdate("DROP DATABASE IF EXISTS " + db + ";");
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_ONLINE_FEATURESTORE_DB, Level.SEVERE, "Error running drop query", se.getMessage(), (Throwable)se);
        }
    }

    public void createOnlineFeaturestoreUser(String user, String pw) throws FeaturestoreException {
        try {
            try (Connection connection = this.featureStoreDataSource.getConnection();
                 PreparedStatement pStmt = connection.prepareStatement("CREATE USER IF NOT EXISTS ? IDENTIFIED BY ?;");){
                pStmt.setString(1, user);
                pStmt.setString(2, pw);
                pStmt.executeUpdate();
            }
            this.executeUpdate("GRANT NDB_STORED_USER ON *.* TO " + user + ";");
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_CREATING_ONLINE_FEATURESTORE_USER, Level.SEVERE, "Error occurred when trying to create the MySQL database user for an online feature store", se.getMessage(), (Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeUserPrivileges(String dbName, String dbUser) {
        ResultSet resultSet = null;
        try {
            try (Connection connection = this.featureStoreDataSource.getConnection();
                 PreparedStatement pStmt = connection.prepareStatement("SELECT COUNT(*) FROM information_schema.SCHEMA_PRIVILEGES WHERE GRANTEE = ? AND TABLE_SCHEMA = ?");){
                String grantee = "'" + dbUser + "'@'%'";
                pStmt.setString(1, grantee);
                pStmt.setString(2, dbName);
                resultSet = pStmt.executeQuery();
                if (resultSet.next() && resultSet.getInt(1) != 0) {
                    this.executeUpdate("REVOKE ALL PRIVILEGES ON " + dbName + ".* FROM " + dbUser + ";");
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in revoking the privileges", e);
        }
    }

    public void grantDataOwnerPrivileges(String dbName, String dbUser) throws FeaturestoreException {
        try {
            this.grantUserPrivileges(dbUser, "GRANT ALL PRIVILEGES ON " + dbName + ".* TO " + dbUser + ";");
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_GRANTING_ONLINE_FEATURESTORE_USER_PRIVILEGES, Level.SEVERE, "Error running the grant query", se.getMessage(), (Throwable)se);
        }
    }

    public void grantDataScientistPrivileges(String dbName, String dbUser) throws FeaturestoreException {
        try {
            this.grantUserPrivileges(dbUser, "GRANT SELECT ON " + dbName + ".* TO " + dbUser + ";");
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_GRANTING_ONLINE_FEATURESTORE_USER_PRIVILEGES, Level.SEVERE, "Error running the grant query", se.getMessage(), (Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantUserPrivileges(String dbUser, String grantQuery) throws SQLException {
        try (ResultSet resultSet = null;
             Connection connection = this.featureStoreDataSource.getConnection();
             PreparedStatement pStmt = connection.prepareStatement("SELECT COUNT(*) FROM mysql.user WHERE User = ?");){
            pStmt.setString(1, dbUser);
            resultSet = pStmt.executeQuery();
            if (resultSet.next() && resultSet.getInt(1) != 0) {
                this.executeUpdate(grantQuery);
            }
        }
    }

    public void removeOnlineFeaturestoreUser(String dbUser) throws FeaturestoreException {
        try (Connection connection = this.featureStoreDataSource.getConnection();
             PreparedStatement pStmt = connection.prepareStatement("DROP USER IF EXISTS ?");){
            pStmt.setString(1, dbUser);
            pStmt.executeUpdate();
        }
        catch (SQLException se) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ERROR_DELETING_ONLINE_FEATURESTORE_USER, Level.SEVERE, "An error occurred when trying to delete the MySQL database user for an online feature store", se.getMessage(), (Throwable)se);
        }
    }

    /*
     * Exception decompiling
     */
    public Boolean checkIfDatabaseExists(String dbName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeUpdate(String query) throws SQLException {
        try (Connection connection = this.featureStoreDataSource.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.executeUpdate(query);
        }
    }
}

