/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import io.hops.hopsworks.common.dao.git.GitOpExecutionFacade;
import io.hops.hopsworks.common.dao.git.GitPaths;
import io.hops.hopsworks.common.dao.git.GitRepositoryFacade;
import io.hops.hopsworks.common.git.util.GitCommandOperationUtil;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.config.GitOpExecutionState;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@LocalBean
public class AsynchronousGitCommandExecutor {
    private static final Logger LOGGER = Logger.getLogger(AsynchronousGitCommandExecutor.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private GitOpExecutionFacade gitOpExecutionFacade;
    @EJB
    private GitCommandOperationUtil gitCommandOperationUtil;
    @EJB
    private GitRepositoryFacade gitRepositoryFacade;

    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void execute(GitOpExecution gitOpExecution, GitPaths gitPaths) {
        int maxTries = 5;
        String pid = "";
        String gitCommand = gitOpExecution.getGitCommandConfiguration().getCommandType().getGitCommand();
        String prog = this.settings.getSudoersDir() + "/git.sh";
        String commandArgumentsFile = gitPaths.getConfDirPath() + File.separator + "git_container_launch_script_arguments";
        while (maxTries > 0 && Strings.isNullOrEmpty((String)pid)) {
            try {
                ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("start").addCommand(commandArgumentsFile).redirectErrorStream(true).setCurrentWorkingDirectory(new File(gitPaths.getGitPath())).setWaitTimeout(60L, TimeUnit.SECONDS).build();
                String pidFile = gitPaths.getRunDirPath() + "/git.pid";
                ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
                if (processResult.getExitCode() != 0) {
                    String errorMsg = "Could not start git service to execute command " + gitCommand + " . Exit code: " + processResult.getExitCode() + " Error: stdout: " + processResult.getStdout() + " stderr: " + processResult.getStderr();
                    LOGGER.log(Level.SEVERE, errorMsg);
                    throw new IOException(errorMsg);
                }
                pid = Files.readFirstLine((File)new File(pidFile), (Charset)Charset.defaultCharset());
                Optional<GitRepository> optional = this.gitRepositoryFacade.findById(gitOpExecution.getRepository().getId());
                this.gitRepositoryFacade.updateRepositoryCid(optional.get(), pid);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Problem executing shell script to start git command service", ex);
                --maxTries;
            }
        }
        if (Strings.isNullOrEmpty((String)pid)) {
            this.updateExecutionStateToFail(gitOpExecution);
        }
    }

    private void updateExecutionStateToFail(GitOpExecution gitOpExecution) {
        this.gitCommandOperationUtil.cleanUp(gitOpExecution.getRepository().getProject(), gitOpExecution.getUser(), gitOpExecution.getConfigSecret());
        this.gitOpExecutionFacade.updateState(gitOpExecution, GitOpExecutionState.FAILED, "Could not launch container to execute git command.");
        this.gitRepositoryFacade.updateRepositoryCid(gitOpExecution.getRepository(), null);
        LOGGER.log(Level.SEVERE, "Problem executing shell script to start git command service.");
    }
}

