/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.yarn;

import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;

public class LogReader {
    private static final Log LOG = LogFactory.getLog(LogReader.class);
    private final FSDataInputStream fsDataIStream;
    private final TFile.Reader.Scanner scanner;
    private final TFile.Reader reader;
    private static final Map<String, AggregatedLogFormat.LogKey> RESERVED_KEYS;
    private static final AggregatedLogFormat.LogKey APPLICATION_ACL_KEY;
    private static final AggregatedLogFormat.LogKey APPLICATION_OWNER_KEY;
    private static final AggregatedLogFormat.LogKey VERSION_KEY;
    private boolean atBeginning = true;

    public LogReader(Configuration conf, DistributedFileSystemOps dfs, Path remoteAppLogFile) throws IOException {
        this.fsDataIStream = dfs.open(remoteAppLogFile);
        this.reader = new TFile.Reader(this.fsDataIStream, dfs.getFileStatus(remoteAppLogFile).getLen(), conf);
        this.scanner = this.reader.createScanner();
    }

    public DataInputStream next(AggregatedLogFormat.LogKey key) throws IOException {
        if (!this.atBeginning) {
            this.scanner.advance();
        } else {
            this.atBeginning = false;
        }
        if (this.scanner.atEnd()) {
            return null;
        }
        TFile.Reader.Scanner.Entry entry = this.scanner.entry();
        key.readFields((DataInput)entry.getKeyStream());
        if (RESERVED_KEYS.containsKey(key.toString())) {
            return this.next(key);
        }
        return entry.getValueStream();
    }

    public void close() {
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.scanner, this.reader, this.fsDataIStream});
    }

    static {
        APPLICATION_ACL_KEY = new AggregatedLogFormat.LogKey("APPLICATION_ACL");
        APPLICATION_OWNER_KEY = new AggregatedLogFormat.LogKey("APPLICATION_OWNER");
        VERSION_KEY = new AggregatedLogFormat.LogKey("VERSION");
        RESERVED_KEYS = new HashMap<String, AggregatedLogFormat.LogKey>();
        RESERVED_KEYS.put(APPLICATION_ACL_KEY.toString(), APPLICATION_ACL_KEY);
        RESERVED_KEYS.put(APPLICATION_OWNER_KEY.toString(), APPLICATION_OWNER_KEY);
        RESERVED_KEYS.put(VERSION_KEY.toString(), VERSION_KEY);
    }
}

