/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.maggy;

import io.hops.hopsworks.common.dao.maggy.MaggyFacade;
import io.hops.hopsworks.common.livy.LivyController;
import io.hops.hopsworks.common.livy.LivyMsg;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.maggy.MaggyDriver;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;

@Singleton
public class MaggyCleaner {
    private static final Logger LOGGER = Logger.getLogger(MaggyCleaner.class.getName());
    @EJB
    private LivyController livyService;
    @EJB
    private MaggyFacade maggyFacade;
    @EJB
    private Settings settings;

    @Schedule(hour="*", info="Maggy Cleaner timer")
    public void maggyCleaner(Timer timer) {
        try {
            List<MaggyDriver> drivers = this.maggyFacade.getAllDrivers();
            ArrayList<MaggyDriver> driversToRemove = new ArrayList<MaggyDriver>();
            if (drivers != null) {
                LivyMsg msg = this.livyService.getLivySessions();
                if (msg == null) {
                    LOGGER.info("Maggy Cleaner could not contact Livy. Exiting....");
                    return;
                }
                LivyMsg.Session[] sessions = msg.getSessions();
                for (MaggyDriver md : drivers) {
                    if (!md.getCreated().before(new Date(System.currentTimeMillis() - (long)this.settings.getMaggyCleanupInterval()))) continue;
                    driversToRemove.add(md);
                    if (sessions == null) continue;
                    for (LivyMsg.Session s : sessions) {
                        String h = s.getAppId();
                        if (h == null || h.compareToIgnoreCase(md.getAppId()) != 0) continue;
                        driversToRemove.remove(md);
                    }
                }
                for (MaggyDriver md : driversToRemove) {
                    this.maggyFacade.remove(md);
                }
            } else {
                LOGGER.info("No Maggy Drivers running. Sleeping again.");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got an exception while cleaning up maggy drivers", e);
        }
    }
}

