/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.featurestore.storageconnectors.s3;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.user.security.secrets.SecretsFacade;
import io.hops.hopsworks.common.featurestore.storageconnectors.StorageConnectorUtil;
import io.hops.hopsworks.common.featurestore.storageconnectors.s3.FeaturestoreS3ConnectorDTO;
import io.hops.hopsworks.common.security.secrets.SecretsController;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.persistence.entity.featurestore.Featurestore;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.FeaturestoreConnector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3Connector;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3ConnectorAccessAndSecretKey;
import io.hops.hopsworks.persistence.entity.featurestore.storageconnector.s3.FeaturestoreS3ConnectorEncryptionAlgorithm;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.persistence.entity.user.security.secrets.Secret;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Transactional;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class FeaturestoreS3ConnectorController {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreS3ConnectorController.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private SecretsController secretsController;
    @EJB
    private SecretsFacade secretsFacade;
    @EJB
    private StorageConnectorUtil storageConnectorUtil;

    public FeaturestoreS3Connector createFeaturestoreS3Connector(Users user, Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException, UserException, ProjectException {
        FeaturestoreS3ConnectorEncryptionAlgorithm encryptionAlgorithm = this.getEncryptionAlgorithm(featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm());
        this.verifyUserInput(featurestoreS3ConnectorDTO);
        FeaturestoreS3Connector featurestoreS3Connector = new FeaturestoreS3Connector();
        featurestoreS3Connector.setBucket(featurestoreS3ConnectorDTO.getBucket());
        featurestoreS3Connector.setServerEncryptionAlgorithm(encryptionAlgorithm);
        featurestoreS3Connector.setServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
        featurestoreS3Connector.setIamRole(featurestoreS3ConnectorDTO.getIamRole());
        this.setSecret(user, featurestoreS3ConnectorDTO, featurestoreS3Connector, featurestore);
        featurestoreS3Connector.setArguments(this.storageConnectorUtil.fromOptions(featurestoreS3ConnectorDTO.getArguments()));
        return featurestoreS3Connector;
    }

    private void setSecret(Users user, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, FeaturestoreS3Connector featurestoreS3Connector, Featurestore featurestore) throws UserException, ProjectException {
        if (this.keysNotNullOrEmpty(featurestoreS3ConnectorDTO)) {
            String jsonSecretString = this.createS3AccessAndSecretKeysSecret(featurestoreS3ConnectorDTO.getAccessKey(), featurestoreS3ConnectorDTO.getSecretKey());
            String secretName = this.storageConnectorUtil.createSecretName(featurestore.getId(), featurestoreS3ConnectorDTO.getName(), featurestoreS3ConnectorDTO.getStorageConnectorType());
            Integer projectId = featurestore.getProject().getId();
            Secret secret = this.secretsController.createSecretForProject(user, secretName, jsonSecretString, projectId);
            featurestoreS3Connector.setSecret(secret);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Transactional(rollbackOn={FeaturestoreException.class, UserException.class, ProjectException.class})
    public FeaturestoreS3Connector updateFeaturestoreS3Connector(Users user, Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, FeaturestoreS3Connector featurestoreS3Connector) throws FeaturestoreException, UserException, ProjectException {
        String currentEncryptionAlgorithm;
        if (this.storageConnectorUtil.shouldUpdate(featurestoreS3Connector.getBucket(), featurestoreS3ConnectorDTO.getBucket())) {
            this.verifyS3ConnectorBucket(featurestoreS3ConnectorDTO.getBucket());
            featurestoreS3Connector.setBucket(featurestoreS3ConnectorDTO.getBucket());
        }
        if (this.storageConnectorUtil.shouldUpdate(featurestoreS3Connector.getIamRole(), featurestoreS3ConnectorDTO.getIamRole())) {
            featurestoreS3Connector.setIamRole(featurestoreS3ConnectorDTO.getIamRole());
        }
        Secret secret = this.updateSecret(user, featurestoreS3ConnectorDTO, featurestore, featurestoreS3Connector);
        String string = currentEncryptionAlgorithm = featurestoreS3Connector.getServerEncryptionAlgorithm() != null ? featurestoreS3Connector.getServerEncryptionAlgorithm().getAlgorithm() : null;
        if (this.storageConnectorUtil.shouldUpdate(currentEncryptionAlgorithm, featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm())) {
            if (featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm() != null) {
                FeaturestoreS3ConnectorEncryptionAlgorithm serverEncryptionAlgorithm = this.getEncryptionAlgorithm(featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm());
                featurestoreS3Connector.setServerEncryptionAlgorithm(serverEncryptionAlgorithm);
                if (serverEncryptionAlgorithm != null && serverEncryptionAlgorithm.isRequiresKey()) {
                    this.verifyS3ConnectorServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
                    featurestoreS3Connector.setServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
                } else {
                    featurestoreS3Connector.setServerEncryptionKey(null);
                }
            } else {
                if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getServerEncryptionKey())) {
                    throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_ALGORITHM, Level.FINE, "Illegal server encryption algorithm, encryption algorithm not provided");
                }
                featurestoreS3Connector.setServerEncryptionAlgorithm(null);
                featurestoreS3Connector.setServerEncryptionKey(null);
            }
        }
        featurestoreS3Connector.setArguments(this.storageConnectorUtil.fromOptions(featurestoreS3ConnectorDTO.getArguments()));
        this.verifyKeyAndIAMRole(featurestoreS3Connector.getIamRole(), featurestoreS3Connector.getSecret());
        if (featurestoreS3Connector.getSecret() == null && secret != null) {
            this.secretsFacade.deleteSecret(secret.getId());
        }
        return featurestoreS3Connector;
    }

    private void verifyKeyAndIAMRole(String iamRole, Secret secret) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)iamRole) && secret != null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_ARG, Level.FINE, "S3 Access Keys are not allowed");
        }
    }

    private Secret updateSecret(Users user, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, Featurestore featurestore, FeaturestoreS3Connector featurestoreS3Connector) throws UserException, FeaturestoreException, ProjectException {
        Secret secret = featurestoreS3Connector.getSecret();
        if (secret != null) {
            this.secretsController.checkCanAccessSecret(secret, user);
        }
        if (secret == null && this.keysNotNullOrEmpty(featurestoreS3ConnectorDTO)) {
            this.verifyS3ConnectorAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
            this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
            this.setSecret(user, featurestoreS3ConnectorDTO, featurestoreS3Connector, featurestore);
        } else if (this.keysNotNullOrEmpty(featurestoreS3ConnectorDTO)) {
            try {
                this.verifyS3ConnectorAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
                this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
                String jsonSecretString = this.createS3AccessAndSecretKeysSecret(featurestoreS3ConnectorDTO.getAccessKey(), featurestoreS3ConnectorDTO.getSecretKey());
                secret.setSecret(this.secretsController.encryptSecret(jsonSecretString));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new UserException(RESTCodes.UserErrorCode.SECRET_ENCRYPTION_ERROR, Level.SEVERE, "Error encrypting secret", "Could not encrypt Secret " + secret.getId().getName(), (Throwable)e);
            }
        } else {
            featurestoreS3Connector.setSecret(null);
        }
        return secret;
    }

    private boolean keysNotNullOrEmpty(FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) {
        return !Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getSecretKey()) && !Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getAccessKey());
    }

    private void verifyS3ConnectorBucket(String bucket) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)bucket) || bucket.length() > 5000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_BUCKET, Level.FINE, "Illegal S3 connector bucket, the S3 bucket string should not be empty and not exceed: 5000 characters");
        }
    }

    private void verifyS3ConnectorAccessKey(String accessKey) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)accessKey)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_ACCESS_KEY, Level.FINE, "The S3 access key cannot be empty and must be less than 1000");
        }
        if (accessKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_ACCESS_KEY, Level.FINE, "Illegal S3 connector access key, the S3 access key should not exceed: 1000 characters");
        }
    }

    private void verifyS3ConnectorSecretKey(String secretKey) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)secretKey)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SECRET_KEY, Level.FINE, "The S3 secret key cannot be empty and must be less than 1000");
        }
        if (secretKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SECRET_KEY, Level.FINE, "Illegal S3 connector secret key, the S3 secret key should not exceed: 1000 characters");
        }
    }

    private void verifyS3ConnectorServerEncryptionKey(String serverEncryptionKey) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)serverEncryptionKey)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_KEY, Level.FINE, "S3 server encryption key cannot be empty");
        }
        if (serverEncryptionKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_KEY, Level.FINE, "Illegal server encryption key provided, the S3 server encryption key should not exceed: 1000 characters");
        }
    }

    private void verifyUserInput(FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException {
        FeaturestoreS3ConnectorEncryptionAlgorithm encryptionAlgorithm;
        if (featurestoreS3ConnectorDTO == null) {
            throw new IllegalArgumentException("Null input data");
        }
        this.verifyS3ConnectorBucket(featurestoreS3ConnectorDTO.getBucket());
        if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getIamRole())) {
            this.verifySecretAndAccessKeysForIamRole(featurestoreS3ConnectorDTO);
        }
        if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getAccessKey()) || !Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getSecretKey())) {
            this.verifyS3ConnectorAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
            this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
        }
        if ((encryptionAlgorithm = this.getEncryptionAlgorithm(featurestoreS3ConnectorDTO.getServerEncryptionAlgorithm())) != null) {
            if (encryptionAlgorithm.isRequiresKey()) {
                this.verifyS3ConnectorServerEncryptionKey(featurestoreS3ConnectorDTO.getServerEncryptionKey());
            } else {
                featurestoreS3ConnectorDTO.setServerEncryptionKey(null);
            }
        } else if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getServerEncryptionKey())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_ALGORITHM, Level.FINE, "Illegal server encryption algorithm, encryption algorithm not provided");
        }
    }

    private void verifySecretAndAccessKeysForIamRole(FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getAccessKey()) || !Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getSecretKey())) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.S3_KEYS_FORBIDDEN, Level.FINE, "S3 Access Keys are not allowed");
        }
    }

    private FeaturestoreS3ConnectorEncryptionAlgorithm getEncryptionAlgorithm(String s) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)s)) {
            return null;
        }
        FeaturestoreS3ConnectorEncryptionAlgorithm serverEncryptionAlgrithm = null;
        try {
            serverEncryptionAlgrithm = FeaturestoreS3ConnectorEncryptionAlgorithm.fromValue((String)s);
        }
        catch (IllegalArgumentException e) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SERVER_ENCRYPTION_ALGORITHM, Level.FINE, "Illegal server encryption algorithm provided, " + e.getMessage());
        }
        return serverEncryptionAlgrithm;
    }

    public String createS3AccessAndSecretKeysSecret(String accessKey, String secretKey) {
        return new JSONObject((Object)new FeaturestoreS3ConnectorAccessAndSecretKey(accessKey, secretKey)).toString();
    }

    public FeaturestoreS3ConnectorDTO getS3ConnectorDTO(FeaturestoreConnector featurestoreConnector) throws FeaturestoreException {
        FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO = new FeaturestoreS3ConnectorDTO(featurestoreConnector);
        if (featurestoreConnector.getS3Connector().getSecret() != null) {
            FeaturestoreS3ConnectorAccessAndSecretKey accessAndSecretKey = this.storageConnectorUtil.getSecret(featurestoreConnector.getS3Connector().getSecret(), FeaturestoreS3ConnectorAccessAndSecretKey.class);
            this.setAccessAndSecretKeysInDTO(featurestoreS3ConnectorDTO, accessAndSecretKey);
        }
        featurestoreS3ConnectorDTO.setArguments(this.storageConnectorUtil.toOptions(featurestoreConnector.getS3Connector().getArguments()));
        return featurestoreS3ConnectorDTO;
    }

    private void setAccessAndSecretKeysInDTO(FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, FeaturestoreS3ConnectorAccessAndSecretKey featurestoreS3ConnectorAccessAndSecretKey) {
        featurestoreS3ConnectorDTO.setAccessKey(featurestoreS3ConnectorAccessAndSecretKey.getAccessKey());
        featurestoreS3ConnectorDTO.setSecretKey(featurestoreS3ConnectorAccessAndSecretKey.getSecretKey());
    }
}

