/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.git;

import io.hops.hopsworks.common.dao.git.GitOpExecutionFacade;
import io.hops.hopsworks.common.dao.git.GitRepositoryFacade;
import io.hops.hopsworks.common.git.util.GitCommandOperationUtil;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.git.GitOpExecution;
import io.hops.hopsworks.persistence.entity.git.GitRepository;
import io.hops.hopsworks.persistence.entity.git.config.GitOpExecutionState;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timer;

@Singleton
@Startup
@DependsOn(value={"Settings"})
public class GitTimeoutCommandsMonitor {
    private static final Logger LOGGER = Logger.getLogger(GitTimeoutCommandsMonitor.class.getName());
    private static final Integer BONUS_TIME = 90000;
    private static final Integer WAIT_TIME_BEFORE_EXECUTION_OBJECT_CREATION = 3000;
    @EJB
    private GitOpExecutionFacade gitOpExecutionFacade;
    @EJB
    private GitRepositoryFacade gitRepositoryFacade;
    @EJB
    private GitCommandOperationUtil gitCommandOperationUtil;
    @EJB
    private Settings settings;

    @Schedule(minute="*/1", hour="*", info="Git Commands Monitor timer")
    public void gitCommandMonitor(Timer timer) {
        LOGGER.log(Level.FINE, "Running GitTimeoutCommandsMonitor");
        List<GitRepository> repositories = this.gitRepositoryFacade.findAllWithOngoingOperations();
        for (GitRepository repository : repositories) {
            Optional<GitOpExecution> optional = this.gitOpExecutionFacade.findRunningInRepository(repository);
            if (optional.isPresent()) {
                GitOpExecution execution = optional.get();
                Long timeElapsed = System.currentTimeMillis() - execution.getExecutionStart();
                if (timeElapsed <= this.settings.getGitJwtExpMs() + (long)BONUS_TIME.intValue()) continue;
                LOGGER.log(Level.INFO, "Killing git execution with Id + [" + execution.getId() + "] with state " + execution.getState().toString());
                this.gitOpExecutionFacade.updateState(execution, GitOpExecutionState.TIMEDOUT, "Timeout");
                this.gitCommandOperationUtil.shutdownCommandService(repository, execution);
                continue;
            }
            try {
                long executionStart = Long.parseLong(repository.getCid());
                Long timeElapsed = System.currentTimeMillis() - executionStart;
                if (timeElapsed <= (long)WAIT_TIME_BEFORE_EXECUTION_OBJECT_CREATION.intValue()) continue;
                LOGGER.log(Level.INFO, "Failed to create execution in repository with Id + [" + repository.getId() + "] ");
                this.gitRepositoryFacade.updateRepositoryCid(repository, null);
            }
            catch (NumberFormatException e) {
                this.gitRepositoryFacade.updateRepositoryCid(repository, null);
            }
        }
    }
}

