/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.hdfs;

import com.google.common.base.CharMatcher;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.persistence.entity.dataset.Dataset;
import io.hops.hopsworks.persistence.entity.dataset.DatasetType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.FeatureView;
import io.hops.hopsworks.persistence.entity.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.persistence.entity.jobs.configuration.JobType;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.hadoop.fs.Path;

public final class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());

    public static String getFileName(String path) {
        int lastSlash = path.lastIndexOf("/");
        int startName = lastSlash > -1 ? lastSlash + 1 : 0;
        return path.substring(startName);
    }

    public static Optional<String> getExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }

    public static String getDirectoryPart(String path) {
        int lastSlash = path.lastIndexOf("/");
        int startName = lastSlash > -1 ? lastSlash + 1 : 0;
        return path.substring(0, startName);
    }

    public static String getProjectPath(String projectName) {
        return "/Projects/" + projectName + "/";
    }

    public static String getFileSystemDatasetPath(Dataset dataset, Settings settings) {
        if (DatasetType.FEATURESTORE.equals((Object)dataset.getDsType())) {
            return Utils.getFeaturestorePath(dataset.getProject(), settings);
        }
        if (DatasetType.HIVEDB.equals((Object)dataset.getDsType())) {
            return Utils.getHiveDBPath(dataset.getProject(), settings);
        }
        return "/Projects/" + dataset.getProject().getName() + "/" + dataset.getName() + "/";
    }

    public static Path getDatasetPath(Dataset ds, Settings settings) {
        Path path = null;
        switch (ds.getDsType()) {
            case DATASET: {
                path = new Path(Utils.getProjectPath(ds.getProject().getName()), ds.getName());
                break;
            }
            case FEATURESTORE: 
            case HIVEDB: {
                path = new Path(settings.getHiveWarehouse(), ds.getName());
            }
        }
        return path;
    }

    public static String[] getJobLogLocation(String projectName, JobType jobType) {
        String defaultOutputPath;
        switch (jobType) {
            case SPARK: 
            case PYSPARK: 
            case FLINK: 
            case YARN: {
                defaultOutputPath = Settings.BaseDataset.LOGS.getName() + "/" + jobType.getName() + "/";
                break;
            }
            default: {
                defaultOutputPath = "Logs/";
            }
        }
        String stdOutFinalDestination = Utils.getProjectPath(projectName) + defaultOutputPath;
        String stdErrFinalDestination = Utils.getProjectPath(projectName) + defaultOutputPath;
        return new String[]{stdOutFinalDestination, stdErrFinalDestination};
    }

    public static String getHiveDBName(Project project) {
        return project.getName().toLowerCase() + ".db";
    }

    public static String getHiveDBPath(Project project, Settings settings) {
        return settings.getHiveWarehouse() + "/" + Utils.getHiveDBName(project);
    }

    public static String getFeaturestoreName(Project project) {
        return project.getName().toLowerCase() + "_featurestore.db";
    }

    public static String getFeaturestorePath(Project project, Settings settings) {
        return settings.getHiveWarehouse() + "/" + Utils.getFeaturestoreName(project);
    }

    public static String getFeaturegroupName(Featuregroup featuregroup) {
        return Utils.getFeatureStoreEntityName(featuregroup.getName(), featuregroup.getVersion());
    }

    public static String getTrainingDatasetName(TrainingDataset trainingDataset) {
        return Utils.getFeatureStoreEntityName(trainingDataset.getName(), trainingDataset.getVersion());
    }

    public static String getFeatureViewName(FeatureView featureView) {
        return Utils.getFeatureStoreEntityName(featureView.getName(), featureView.getVersion());
    }

    public static String getFeatureStoreEntityName(String entityName, Integer version) {
        return entityName + "_" + version.toString();
    }

    public static int pathLen(String path) {
        return CharMatcher.is((char)'/').countIn((CharSequence)path);
    }

    public static String prepPath(String path) throws UnsupportedEncodingException {
        String result = path;
        if (path.contains("::")) {
            String[] parts = path.split("::");
            Path p = new Path(parts[0]);
            p = new Path(URLDecoder.decode(p.toUri().getRawPath(), StandardCharsets.UTF_8.toString()));
            result = p.toString() + "::" + parts[1];
        } else {
            Path p = new Path(path);
            p = new Path(URLDecoder.decode(p.toUri().getRawPath(), StandardCharsets.UTF_8.toString()));
            result = p.toString();
        }
        return result;
    }

    public static String pathStripSlash(String path) {
        while (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

