/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.pushgateway;

import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.service.Service;
import io.hops.hopsworks.common.hosts.ServiceDiscoveryController;
import io.hops.hopsworks.common.jobs.pushgateway.PushgatewayMetric;
import io.hops.hopsworks.common.jobs.pushgateway.PushgatewayResults;
import io.hops.hopsworks.common.jobs.pushgateway.PushgatewaySerie;
import io.hops.hopsworks.common.proxies.client.HttpClient;
import io.hops.hopsworks.common.yarn.YarnClientService;
import io.hops.hopsworks.common.yarn.YarnClientWrapper;
import io.hops.hopsworks.servicediscovery.HopsworksService;
import io.hops.hopsworks.servicediscovery.tags.PrometheusTags;
import io.hops.hopsworks.servicediscovery.tags.ServiceTags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Timer;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;

@Singleton
@DependsOn(value={"Settings"})
public class PushgatewayMonitor {
    private static final Logger LOGGER = Logger.getLogger(PushgatewayMonitor.class.getName());
    private static final String METRICS_ENDPOINT = "/api/v1/metrics";
    private static final Pattern applicationIdPattern = Pattern.compile("(application_.*?_\\d*)");
    @EJB
    private HttpClient httpClient;
    @EJB
    private ServiceDiscoveryController serviceDiscoveryController;
    @EJB
    private YarnClientService ycs;

    @Schedule(second="0", minute="*", hour="*", info="Prometheus push gateway timer")
    public synchronized void monitor(Timer timer) {
        try {
            PushgatewayResults results = this.scrapeMetrics();
            Set<String> activeApplications = this.getActiveApplications(results);
            List<String> applicationsToRemove = this.getApplicationsToRemove(activeApplications);
            this.removeActiveApplications(results, applicationsToRemove);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error processing pushgateway timer", e);
        }
    }

    private PushgatewayResults scrapeMetrics() throws ServiceDiscoveryException, IOException {
        Service pushgatewayService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.PROMETHEUS.getNameWithTag((ServiceTags)PrometheusTags.pushgateway));
        HttpHost pushgatewayHost = new HttpHost(pushgatewayService.getAddress(), pushgatewayService.getPort().intValue());
        return this.httpClient.execute(pushgatewayHost, (HttpRequest)new HttpGet(METRICS_ENDPOINT), new HttpClient.ObjectResponseHandler<PushgatewayResults>(PushgatewayResults.class, this.httpClient.getObjectMapper()));
    }

    private Set<String> getActiveApplications(PushgatewayResults pushgatewayResults) {
        return pushgatewayResults.getData().stream().flatMap(m -> m.values().stream()).filter(serie -> serie.getMetrics() != null).map(PushgatewaySerie::getMetrics).map(metric -> ((PushgatewayMetric)metric.get(0)).getLabels().get("job")).filter(applicationId -> applicationIdPattern.matcher((CharSequence)applicationId).matches()).collect(Collectors.toSet());
    }

    private void removeActiveApplications(PushgatewayResults pushgatewayResults, List<String> applications) throws ServiceDiscoveryException {
        HashSet groupsToRemove = new HashSet();
        for (String application : applications) {
            groupsToRemove.addAll(pushgatewayResults.getData().stream().flatMap(m -> m.values().stream()).filter(serie -> serie.getMetrics() != null).map(PushgatewaySerie::getMetrics).map(metric -> ((PushgatewayMetric)metric.get(0)).getLabels()).filter(labels -> ((String)labels.get("job")).equalsIgnoreCase(application)).collect(Collectors.toSet()));
        }
        Service pushgatewayService = this.serviceDiscoveryController.getAnyAddressOfServiceWithDNS(HopsworksService.PROMETHEUS.getNameWithTag((ServiceTags)PrometheusTags.pushgateway));
        HttpHost pushgatewayHost = new HttpHost(pushgatewayService.getAddress(), pushgatewayService.getPort().intValue());
        String groupPath = "";
        for (Map group : groupsToRemove) {
            String job = (String)group.remove("job");
            groupPath = "/metrics/job/" + job + "/" + group.entrySet().stream().map(e -> (String)e.getKey() + "/" + (String)e.getValue()).collect(Collectors.joining("/"));
            HttpDelete httpDelete = new HttpDelete(groupPath);
            try {
                this.httpClient.execute(pushgatewayHost, (HttpRequest)httpDelete, new HttpClient.NoBodyResponseHandler());
            }
            catch (IOException e2) {
                LOGGER.log(Level.SEVERE, "Error deleting group: " + groupPath, e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getApplicationsToRemove(Set<String> activeApplications) {
        ArrayList<String> applicationsToRemove = new ArrayList<String>();
        YarnClientWrapper yarnClientWrapper = null;
        try {
            yarnClientWrapper = this.ycs.getYarnClientSuper();
            YarnClient yarnClient = yarnClientWrapper.getYarnClient();
            for (String application : activeApplications) {
                FinalApplicationStatus applicationStatus = null;
                try {
                    applicationStatus = yarnClient.getApplicationReport(ApplicationId.fromString((String)application)).getFinalApplicationStatus();
                }
                catch (IOException | YarnException yex) {
                    LOGGER.log(Level.SEVERE, "Error retrieving status for application: " + application, yex);
                }
                if (applicationStatus == null || applicationStatus == FinalApplicationStatus.UNDEFINED) continue;
                applicationsToRemove.add(application);
            }
        }
        finally {
            this.ycs.closeYarnClient(yarnClientWrapper);
        }
        return applicationsToRemove;
    }
}

