/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import io.hops.hopsworks.common.jupyter.CidAndPort;
import io.hops.hopsworks.common.jupyter.JupyterJWT;
import io.hops.hopsworks.common.util.DateUtils;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

public class JupyterJWTDTO
implements Serializable {
    private static final long serialVersionUID = -5687462769985361531L;
    private Project project;
    private Users user;
    private LocalDateTime expiration;
    private String token;
    private String tokenFile;
    private final CidAndPort pidAndPort;

    public JupyterJWTDTO(JupyterJWT jupyterJWT) {
        this.project = jupyterJWT.project;
        this.user = jupyterJWT.user;
        this.expiration = jupyterJWT.expiration;
        this.token = jupyterJWT.token;
        this.tokenFile = jupyterJWT.tokenFile.toString();
        this.pidAndPort = jupyterJWT.pidAndPort;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Users getUser() {
        return this.user;
    }

    public void setUser(Users user) {
        this.user = user;
    }

    public LocalDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(LocalDateTime expiration) {
        this.expiration = expiration;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTokenFile() {
        return this.tokenFile;
    }

    public void setTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
    }

    public CidAndPort getPidAndPort() {
        return this.pidAndPort;
    }

    public boolean maybeRenew(LocalDateTime now) {
        return now.isAfter(this.expiration) || now.isEqual(this.expiration);
    }

    public boolean isExpired() {
        LocalDateTime now = DateUtils.getNow();
        return now.isAfter(this.expiration) || now.isEqual(this.expiration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JupyterJWTDTO that = (JupyterJWTDTO)o;
        return Objects.equals(this.project.getId(), that.project.getId()) && Objects.equals(this.user.getUid(), that.user.getUid());
    }

    public int hashCode() {
        return Objects.hash(this.project.getId(), this.user.getUid());
    }
}

