/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jwt;

import io.hops.hopsworks.jwt.JWTController;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timer;

@Startup
@Singleton
public class InvalidatedJWTCleanup {
    private static final Logger LOGGER = Logger.getLogger(InvalidatedJWTCleanup.class.getName());
    @EJB
    private JWTController jWTController;

    @Schedule(info="Invalidated JWT cleanup")
    public void cleanInvalidatedJwt(Timer timer) {
        try {
            int count = this.jWTController.cleanupInvalidTokens();
            LOGGER.log(Level.INFO, "{0} timer event: {1}, removed {2} tokens.", new Object[]{timer.getInfo(), new Date(), count});
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got an exception while cleaning up invalidated jwts", e);
        }
    }
}

