/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jwt;

import io.hops.hopsworks.jwt.JWTController;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;

@Startup
@Singleton
public class OneTimeJWTRotation {
    private static final Logger LOGGER = Logger.getLogger(OneTimeJWTRotation.class.getName());
    @EJB
    private JWTController jWTController;
    @Resource
    TimerService timerService;

    @Schedule(info="Mark old JWT signing keys")
    public void markOldSigningKeys() {
        boolean marked = this.jWTController.markOldSigningKeys();
        if (marked) {
            long duration = 240000L;
            TimerConfig config = new TimerConfig();
            config.setInfo((Serializable)((Object)"Remove old JWT signing keys"));
            config.setPersistent(false);
            this.timerService.createSingleActionTimer(duration, config);
        }
    }

    @Timeout
    public void performTimeout(Timer timer) {
        try {
            this.jWTController.removeMarkedKeys();
            LOGGER.log(Level.INFO, "{0} timer event: {1}.", new Object[]{timer.getInfo(), new Date()});
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Got an exception while rotating one-time jwt", e);
        }
    }
}

