/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.opensearch;

import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.hdfs.inode.InodeController;
import io.hops.hopsworks.common.opensearch.OpenSearchUtils;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.jwt.JWTController;
import io.hops.hopsworks.jwt.SignatureAlgorithm;
import io.hops.hopsworks.jwt.exception.DuplicateSigningKeyException;
import io.hops.hopsworks.jwt.exception.SigningKeyNotFoundException;
import io.hops.hopsworks.persistence.entity.hdfs.inode.Inode;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.team.ProjectRoleTypes;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.logging.Level;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class OpenSearchJWTController {
    @EJB
    private JWTController jwtController;
    @EJB
    private Settings settings;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private InodeController inodeController;

    public String getSigningKeyForELK() throws OpenSearchException {
        SignatureAlgorithm alg = SignatureAlgorithm.valueOf((String)this.settings.getJWTSignatureAlg());
        try {
            return this.jwtController.getSigningKeyForELK(alg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.SIGNING_KEY_ERROR, Level.SEVERE, "Failed to get elk signing key", e.getMessage(), (Throwable)e);
        }
    }

    public String createTokenForELK(Users user, Project project) throws OpenSearchException {
        String userRole = this.projectTeamFacade.findCurrentRole(project, user);
        return this.createTokenForELK(project, userRole);
    }

    public String createTokenForELKAsDataOwner(Project project) throws OpenSearchException {
        return this.createTokenForELK(project, ProjectRoleTypes.DATA_OWNER.getRole());
    }

    public String createTokenForELKAsAdmin() throws OpenSearchException {
        return this.createTokenForELK(this.settings.getOpenSearchAdminUser(), Optional.empty(), "admin");
    }

    public String createTokenForELKServices() throws OpenSearchException {
        return this.createTokenForELK(this.settings.getOpenSearchServiceLogUser(), Optional.empty(), "service_log_viewer");
    }

    private String createTokenForELK(Project project, String role) throws OpenSearchException {
        Inode projectInode = this.inodeController.getProjectRoot(project.getName());
        String userRole = OpenSearchUtils.getValidRole(role);
        return this.createTokenForELK(project.getName(), Optional.of(projectInode.getId()), userRole);
    }

    private String createTokenForELK(String project, Optional<Long> projectInodeId, String userRole) throws OpenSearchException {
        SignatureAlgorithm alg = SignatureAlgorithm.valueOf((String)this.settings.getJWTSignatureAlg());
        Date expiresAt = new Date(System.currentTimeMillis() + this.settings.getOpenSearchJwtExpMs());
        try {
            HashMap<String, Object> claims = new HashMap<String, Object>();
            claims.put("roles", userRole);
            claims.put("pn", OpenSearchUtils.getProjectNameWithNoSpecialCharacters(project));
            if (projectInodeId.isPresent()) {
                claims.put("piid", projectInodeId.get());
            }
            return this.jwtController.createTokenForELK(project, this.settings.getJWTIssuer(), claims, expiresAt, alg);
        }
        catch (DuplicateSigningKeyException | SigningKeyNotFoundException | NoSuchAlgorithmException e) {
            throw new OpenSearchException(RESTCodes.OpenSearchErrorCode.JWT_NOT_CREATED, Level.SEVERE, "Failed to create jwt token for elk", e.getMessage(), e);
        }
    }
}

