/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.python.library;

import com.lambdista.util.Try;
import io.hops.hopsworks.common.dao.python.LibraryFacade;
import io.hops.hopsworks.common.opensearch.OpenSearchClientController;
import io.hops.hopsworks.common.provenance.core.opensearch.BasicOpenSearchHit;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchHelper;
import io.hops.hopsworks.common.provenance.core.opensearch.OpenSearchHits;
import io.hops.hopsworks.common.provenance.util.functional.CheckedSupplier;
import io.hops.hopsworks.common.python.commands.CommandsController;
import io.hops.hopsworks.common.python.library.LibraryVersionDTO;
import io.hops.hopsworks.common.python.search.PyPiLibraryOpenSearchIndexer;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.GenericException;
import io.hops.hopsworks.exceptions.OpenSearchException;
import io.hops.hopsworks.exceptions.ProvenanceException;
import io.hops.hopsworks.exceptions.PythonException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.persistence.entity.jupyter.config.GitBackend;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.python.CondaCommands;
import io.hops.hopsworks.persistence.entity.python.CondaInstallType;
import io.hops.hopsworks.persistence.entity.python.CondaOp;
import io.hops.hopsworks.persistence.entity.python.PythonDep;
import io.hops.hopsworks.persistence.entity.user.Users;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.javatuples.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.search.builder.SearchSourceBuilder;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class LibraryController {
    private static final Logger LOGGER = Logger.getLogger(LibraryController.class.getName());
    @EJB
    private CommandsController commandsController;
    @EJB
    private Settings settings;
    @EJB
    private LibraryFacade libraryFacade;
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private OpenSearchClientController provOpenSearchController;
    @EJB
    private PyPiLibraryOpenSearchIndexer pypiIndexer;

    public PythonDep getPythonDep(String dependency, Project project) throws PythonException {
        return this.libraryFacade.findByDependencyAndProject(dependency, project).orElseThrow(() -> new PythonException(RESTCodes.PythonErrorCode.PYTHON_LIBRARY_NOT_FOUND, Level.FINE));
    }

    public void uninstallLibrary(Project project, Users user, String libName) throws GenericException, ServiceException {
        for (PythonDep dep : project.getPythonDepCollection()) {
            if (!dep.getDependency().equals(libName)) continue;
            this.uninstallLibrary(project, user, dep.getInstallType(), dep.getRepoUrl(), libName, dep.getVersion());
            break;
        }
    }

    public PythonDep installLibrary(Project proj, Users user, CondaInstallType installType, String channelUrl, String dependency, String version, String arg, GitBackend gitBackend, String apiKeyName) throws GenericException, ServiceException {
        return this.commandsController.condaOp(CondaOp.INSTALL, user, installType, proj, channelUrl, dependency, version, arg, gitBackend, apiKeyName);
    }

    public void uninstallLibrary(Project proj, Users user, CondaInstallType installType, String channelUrl, String dependency, String version) throws GenericException, ServiceException {
        this.commandsController.condaOp(CondaOp.UNINSTALL, user, installType, proj, channelUrl, dependency, version, "", null, null);
    }

    public HashMap<String, List<LibraryVersionDTO>> condaSearch(String library, String url) throws ServiceException {
        HashMap<String, List<LibraryVersionDTO>> libVersions = new HashMap<String, List<LibraryVersionDTO>>();
        String prog = this.settings.getHopsworksDomainDir() + "/bin/condasearch.sh";
        String[] lines = this.condaList(prog, library, url);
        String foundLib = "";
        for (String line : lines) {
            String[] libVersion = line.split(",");
            if (libVersion.length != 2) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_FORMAT_ERROR, Level.WARNING);
            }
            String key = libVersion[0];
            String value = libVersion[1];
            if (key.isEmpty() || key.equalsIgnoreCase("Loading") && value.equalsIgnoreCase("channels:") || key.equalsIgnoreCase("#") && value.equalsIgnoreCase("Name") || key.equalsIgnoreCase("no") && value.equalsIgnoreCase("match")) continue;
            foundLib = key;
            String foundVersion = value;
            if (!libVersions.containsKey(foundLib)) {
                LinkedList<LibraryVersionDTO> versions = new LinkedList<LibraryVersionDTO>();
                versions.add(new LibraryVersionDTO(foundVersion));
                libVersions.put(foundLib, versions);
                continue;
            }
            LibraryVersionDTO libraryVersionDTO = new LibraryVersionDTO(foundVersion);
            if (libVersions.get(foundLib).contains(libraryVersionDTO)) continue;
            libVersions.get(foundLib).add(0, libraryVersionDTO);
        }
        if (libVersions.isEmpty()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_NOT_FOUND, Level.FINE);
        }
        return libVersions;
    }

    private void findPipLibPyPi(String libName, HashMap<String, List<LibraryVersionDTO>> versions) {
        Response resp = null;
        try {
            resp = ClientBuilder.newClient().target(this.settings.getPyPiRESTEndpoint().replaceFirst("\\{package}", libName)).request().header("Content-Type", (Object)"application/json").get();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "PyPi REST endpoint connection failed" + this.settings.getPyPiRESTEndpoint().replaceFirst("\\{package}", libName), e);
            return;
        }
        if (resp.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            return;
        }
        JSONObject jsonObject = new JSONObject((String)resp.readEntity(String.class));
        if (jsonObject.has("releases")) {
            JSONObject releases = jsonObject.getJSONObject("releases");
            versions.put(libName, this.getVersions(releases));
        }
    }

    private List<LibraryVersionDTO> getVersions(JSONObject releases) {
        ArrayList<LibraryVersionDTO> versions = new ArrayList<LibraryVersionDTO>();
        Iterator keys = releases.keys();
        Date releaseDate = new Date(0L);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (releases.get(key) instanceof JSONArray) {
                JSONObject versionMeta;
                JSONObject jSONObject = versionMeta = ((JSONArray)releases.get(key)).length() > 0 ? (JSONObject)((JSONArray)releases.get(key)).get(0) : null;
                if (versionMeta != null && versionMeta.has("upload_time")) {
                    String strDate = versionMeta.getString("upload_time");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    try {
                        releaseDate = sdf.parse(strDate);
                    }
                    catch (ParseException e) {
                        LOGGER.log(Level.FINE, "Failed to parse release date: {0}", strDate);
                    }
                }
            }
            versions.add(new LibraryVersionDTO(key, releaseDate));
        }
        return versions;
    }

    public HashMap<String, List<LibraryVersionDTO>> pipSearch(String query) throws ServiceException {
        String[] lines;
        HashMap<String, List<LibraryVersionDTO>> versions = new HashMap<String, List<LibraryVersionDTO>>();
        for (String library : lines = this.pipList(query, new HandlerFactory.BaseList(), "pypi_libraries")) {
            this.findPipLibPyPi(library, versions);
        }
        if (versions.isEmpty()) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_NOT_FOUND, Level.FINE);
        }
        return versions;
    }

    private String[] condaList(String program, String library, String url) throws ServiceException {
        ProcessResult processResult;
        ProcessDescriptor.Builder pdBuilder = new ProcessDescriptor.Builder();
        pdBuilder.addCommand(program);
        if (url != null && !url.isEmpty()) {
            pdBuilder.addCommand(url);
            pdBuilder.addCommand(library);
        } else if (library != null && !library.isEmpty()) {
            pdBuilder.addCommand(library);
        }
        ProcessDescriptor processDescriptor = pdBuilder.redirectErrorStream(true).setWaitTimeout(5L, TimeUnit.MINUTES).build();
        try {
            processResult = this.osProcessExecutor.execute(processDescriptor);
            boolean exited = processResult.processExited();
            int errCode = processResult.getExitCode();
            if (!exited) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "errCode: " + errCode + ", " + processResult.getStderr());
            }
            if (errCode == 1 || errCode == 23) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_NOT_FOUND, Level.FINE, "errCode: " + errCode + ", " + processResult.getStderr());
            }
            if (errCode != 0) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "errCode: " + errCode + ", " + processResult.getStderr());
            }
        }
        catch (IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "lib: " + library, ex.getMessage(), (Throwable)ex);
        }
        String result = processResult.getStdout();
        return result != null && !result.isEmpty() ? result.split("\n") : new String[]{};
    }

    public <R, S1, S2> S2 pipList(String query, HandlerFactory<R, S1, S2> handlerFactory, String index) throws ServiceException {
        return this.pipList(query, 0, 10, handlerFactory, index);
    }

    private <R, S1, S2> S2 pipList(String query, Integer offset, Integer limit, HandlerFactory<R, S1, S2> handlerFactory, String index) throws ServiceException {
        Pair<Long, Try<S1>> searchResult;
        try {
            CheckedSupplier<SearchRequest, ProvenanceException> srF = OpenSearchHelper.baseSearchRequest(index, this.settings.getOpenSearchDefaultScrollPageSize()).andThen(OpenSearchHelper.withPagination(offset, limit, this.settings.getOpenSearchDefaultScrollPageSize().intValue()));
            SearchRequest request = srF.get();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query(OpenSearchHelper.fullTextSearch("library", query));
            request.source(sourceBuilder);
            searchResult = this.provOpenSearchController.search(request, handlerFactory.getHandler());
        }
        catch (OpenSearchException | ProvenanceException pe) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.FINE, "Unable to list python libraries", pe.getMessage(), pe);
        }
        return handlerFactory.checkedResult(searchResult);
    }

    public static Try<String[]> tryInstance(BasicOpenSearchHit hit) {
        return Try.apply(() -> new String[]{hit.getSource().get("library").toString()});
    }

    public Collection<PythonDep> parseCondaList(String condaListStr) {
        ArrayList<PythonDep> deps = new ArrayList<PythonDep>();
        String[] lines = condaListStr.split(System.getProperty("line.separator"));
        for (int i = 3; i < lines.length; ++i) {
            String[] split = lines[i].split(" +");
            String libraryName = split[0];
            String version = split[1];
            String channel = "conda";
            if (split.length > 3) {
                channel = split[3].trim().isEmpty() ? channel : split[3];
            }
            CondaInstallType installType = CondaInstallType.PIP;
            if (!channel.equals("pypi")) {
                installType = CondaInstallType.CONDA;
            }
            PythonDep pyDep = this.getOrCreateDep(channel, installType, libraryName, version, this.settings.getImmutablePythonLibraryNames().contains(libraryName));
            deps.add(pyDep);
        }
        return deps;
    }

    public Collection<PythonDep> addOngoingOperations(Collection<CondaCommands> projectCondaCommands, Collection<PythonDep> projectDeps) {
        for (CondaCommands condaCommand : projectCondaCommands) {
            PythonDep pythonDep;
            if (condaCommand.getInstallType().equals((Object)CondaInstallType.ENVIRONMENT) || projectDeps.contains(pythonDep = this.getOrCreateDep(condaCommand.getChannelUrl(), condaCommand.getInstallType(), condaCommand.getLib(), condaCommand.getVersion(), false))) continue;
            projectDeps.add(pythonDep);
        }
        return projectDeps;
    }

    public boolean isPyPiIndexed() {
        return this.pypiIndexer.isIndexed();
    }

    public PythonDep getOrCreateDep(String repo, CondaInstallType installType, String dependency, String version, boolean preinstalled) {
        Optional<PythonDep> depOptional = this.libraryFacade.get(repo, installType, dependency, version);
        if (depOptional.isPresent()) {
            return depOptional.get();
        }
        depOptional = this.libraryFacade.create(repo, installType, dependency, version, preinstalled);
        if (depOptional.isPresent()) {
            return depOptional.get();
        }
        return this.libraryFacade.get(repo, installType, dependency, version).orElseGet(null);
    }

    public static interface HandlerFactory<R, S1, S2> {
        public OpenSearchHits.Handler<R, S1> getHandler();

        public S2 checkedResult(Pair<Long, Try<S1>> var1) throws ServiceException;

        public static class BaseList
        implements HandlerFactory<String[], List<String[]>, String[]> {
            @Override
            public OpenSearchHits.Handler<String[], List<String[]>> getHandler() {
                OpenSearchHits.Parser parser = hit -> LibraryController.tryInstance(BasicOpenSearchHit.instance(hit));
                return OpenSearchHits.handlerAddToList(parser);
            }

            @Override
            public String[] checkedResult(Pair<Long, Try<List<String[]>>> result) throws ServiceException {
                try {
                    ArrayList<String> hits = new ArrayList<String>();
                    for (String[] lib : (List)((Try)result.getValue1()).checkedGet()) {
                        hits.add(lib[0]);
                    }
                    return hits.toArray(new String[0]);
                }
                catch (Throwable t) {
                    throw new ServiceException(RESTCodes.ServiceErrorCode.ANACONDA_LIST_LIB_ERROR, Level.WARNING, "Failed to list libraries");
                }
            }
        }
    }
}

