/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.security;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import io.hops.hopsworks.common.security.CertificatesMgmService;
import io.hops.hopsworks.common.util.Settings;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;

@Startup
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class MasterEncryptionPasswordMsgListener {
    private final Logger LOGGER = Logger.getLogger(MasterEncryptionPasswordMsgListener.class.getName());
    @EJB
    private CertificatesMgmService certificatesMgmService;
    @EJB
    private Settings settings;
    @Inject
    private HazelcastInstance hazelcastInstance;
    private UUID myUUID;
    private ITopic<String> masterPasswordUpdatedTopic;
    private File masterPasswordFile;

    @PostConstruct
    public void init() {
        this.masterPasswordFile = new File(this.settings.getHopsworksMasterEncPasswordFile());
        if (!this.masterPasswordFile.exists()) {
            throw new IllegalStateException("Master encryption file does not exist");
        }
        if (this.hazelcastInstance != null) {
            this.masterPasswordUpdatedTopic = this.hazelcastInstance.getReliableTopic("masterPasswordUpdated");
            this.myUUID = this.masterPasswordUpdatedTopic.addMessageListener((MessageListener)new MessageListenerImpl());
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.masterPasswordUpdatedTopic != null) {
            this.masterPasswordUpdatedTopic.removeMessageListener(this.myUUID);
        }
    }

    public class MessageListenerImpl
    implements MessageListener<String> {
        public void onMessage(Message<String> message) {
            MasterEncryptionPasswordMsgListener.this.LOGGER.log(Level.INFO, "Got master password updated notification from UUID: {0}, This: {1}", new Object[]{message.getPublishingMember().getUuid(), message.getPublishingMember().localMember()});
            if (!message.getPublishingMember().localMember()) {
                try {
                    MasterEncryptionPasswordMsgListener.this.certificatesMgmService.updateMasterEncryptionPassword((String)message.getMessageObject());
                }
                catch (IOException e) {
                    MasterEncryptionPasswordMsgListener.this.LOGGER.log(Level.SEVERE, "*** Failed to write new encryption password to file: {0}, Update request PublishingMember: {1}", new Object[]{MasterEncryptionPasswordMsgListener.this.masterPasswordFile.getAbsolutePath(), message.getPublishingMember()});
                }
            }
        }
    }
}

