/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.user;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.UsersDTO;
import io.hops.hopsworks.exceptions.UserException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class UserValidator {
    @EJB
    private UserFacade userBean;
    public static final int PASSWORD_MIN_LENGTH = 6;
    public static final int TEMP_PASSWORD_LENGTH = 8;
    public static final int PASSWORD_MAX_LENGTH = 255;
    private static final String PASSWORD_PATTERN = "(?=.*[a-z])(?=.*[A-Z])(?=.*[\\d\\W]).*$";
    private static final String EMAIL_PATTERN = "[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";

    public boolean isValidEmail(String email) throws UserException {
        if (Strings.isNullOrEmpty((String)email)) {
            throw new IllegalArgumentException("Email was not provided");
        }
        if (!this.isValid(email, EMAIL_PATTERN)) {
            throw new UserException(RESTCodes.UserErrorCode.INVALID_EMAIL, Level.FINE);
        }
        return true;
    }

    public boolean isValidPassword(String password, String confirmedPassword) throws UserException {
        if (password.length() == 0) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_EMPTY, Level.FINE);
        }
        if (password.length() < 6) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_TOO_SHORT, Level.FINE);
        }
        if (password.length() > 255) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_TOO_LONG, Level.FINE);
        }
        if (!this.isValid(password, PASSWORD_PATTERN)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_PATTERN_NOT_CORRECT, Level.FINE);
        }
        if (!password.equals(confirmedPassword)) {
            throw new UserException(RESTCodes.UserErrorCode.PASSWORD_MISS_MATCH, Level.FINE);
        }
        return true;
    }

    public boolean isValidNewUser(UsersDTO newUser) throws UserException {
        this.isValidEmail(newUser.getEmail());
        this.isValidPassword(newUser.getChosenPassword(), newUser.getRepeatedPassword());
        if (this.userBean.findByEmail(newUser.getEmail()) != null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_EXISTS, Level.FINE);
        }
        if (!newUser.getTos()) {
            throw new UserException(RESTCodes.UserErrorCode.TOS_NOT_AGREED, Level.FINE);
        }
        return true;
    }

    public void isValidNewUser(UsersDTO newUser, boolean checkPassword) throws UserException {
        this.isValidEmail(newUser.getEmail());
        if (checkPassword) {
            this.isValidPassword(newUser.getChosenPassword(), newUser.getRepeatedPassword());
        }
        if (this.userBean.findByEmail(newUser.getEmail()) != null) {
            throw new UserException(RESTCodes.UserErrorCode.USER_EXISTS, Level.FINE);
        }
        if (!newUser.getTos()) {
            throw new UserException(RESTCodes.UserErrorCode.TOS_NOT_AGREED, Level.FINE);
        }
        if (newUser.getFirstName() == null || newUser.getFirstName().isEmpty() || newUser.getLastName() == null || newUser.getLastName().isEmpty()) {
            throw new UserException(RESTCodes.UserErrorCode.USER_NAME_NOT_SET, Level.FINE, "User name is required");
        }
    }

    private boolean isValid(String u, String inPattern) {
        Pattern pattern = Pattern.compile(inPattern);
        Matcher matcher = pattern.matcher(u);
        return matcher.matches();
    }
}

